/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingDataNodeMessages;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.junit.Assert;
import org.junit.Test;

public class TestPendingDataNodeMessages {
    final PendingDataNodeMessages msgs = new PendingDataNodeMessages();
    private final Block block1Gs1 = new Block(1L, 0L, 1L);
    private final Block block1Gs2 = new Block(1L, 0L, 2L);
    private final Block block1Gs2DifferentInstance = new Block(1L, 0L, 2L);
    private final Block block2Gs1 = new Block(2L, 0L, 1L);

    @Test
    public void testQueues() {
        DatanodeDescriptor fakeDN = DFSTestUtil.getLocalDatanodeDescriptor();
        DatanodeStorage storage = new DatanodeStorage("STORAGE_ID");
        DatanodeStorageInfo storageInfo = new DatanodeStorageInfo(fakeDN, storage);
        this.msgs.enqueueReportedBlock(storageInfo, this.block1Gs1, HdfsServerConstants.ReplicaState.FINALIZED);
        this.msgs.enqueueReportedBlock(storageInfo, this.block1Gs2, HdfsServerConstants.ReplicaState.FINALIZED);
        Assert.assertEquals((long)2L, (long)this.msgs.count());
        Assert.assertNull((Object)this.msgs.takeBlockQueue(this.block2Gs1));
        Assert.assertEquals((long)2L, (long)this.msgs.count());
        Queue q = this.msgs.takeBlockQueue(this.block1Gs2DifferentInstance);
        Assert.assertEquals((Object)"ReportedBlockInfo [block=blk_1_1, dn=127.0.0.1:9866, reportedState=FINALIZED],ReportedBlockInfo [block=blk_1_2, dn=127.0.0.1:9866, reportedState=FINALIZED]", (Object)Joiner.on((String)",").join((Iterable)q));
        Assert.assertEquals((long)0L, (long)this.msgs.count());
        Assert.assertNull((Object)this.msgs.takeBlockQueue(this.block1Gs1));
        Assert.assertEquals((long)0L, (long)this.msgs.count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingDataNodeMessagesWithEC() throws Exception {
        ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)4);
        Path dirPath = new Path("/testPendingDataNodeMessagesWithEC");
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1200000);
        int numDn = ecPolicy.getNumDataUnits() + ecPolicy.getNumParityUnits();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDn).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        try {
            cluster.transitionToActive(0);
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            fs.enableErasureCodingPolicy(ecPolicy.getName());
            fs.mkdirs(dirPath);
            fs.setErasureCodingPolicy(dirPath, ecPolicy.getName());
            DFSTestUtil.createFile((FileSystem)fs, new Path(dirPath, "file"), ecPolicy.getCellSize() * ecPolicy.getNumDataUnits(), (short)1, 0L);
            cluster.getNameNode(0).getRpcServer().rollEditLog();
            cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
            int pendingIBRMsg = cluster.getNameNode(1).getNamesystem().getBlockManager().getPendingDataNodeMessageCount();
            Assert.assertEquals((String)"All DN message should processed after tail edits", (long)0L, (long)pendingIBRMsg);
        }
        finally {
            cluster.shutdown();
        }
    }
}

