/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CredentialsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LocalResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LogAggregationContextInfo;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RMWebAppUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RMWebAppUtil.class);

    private RMWebAppUtil() {
    }

    public static void setupSecurityAndFilters(Configuration conf, RMDelegationTokenSecretManager rmDTSecretManager) {
        boolean enableCorsFilter = conf.getBoolean("yarn.resourcemanager.webapp.cross-origin.enabled", false);
        boolean useYarnAuthenticationFilter = conf.getBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        String authPrefix = "hadoop.http.authentication.";
        String authTypeKey = authPrefix + "type";
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        String actualInitializers = "";
        Class[] initializersClasses = conf.getClasses(filterInitializerConfKey, new Class[0]);
        if (enableCorsFilter) {
            conf.setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        boolean hasHadoopAuthFilterInitializer = false;
        boolean hasRMAuthFilterInitializer = false;
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                }
                if (!initializer.getName().equals(RMAuthenticationFilterInitializer.class.getName())) continue;
                hasRMAuthFilterInitializer = true;
            }
            if (UserGroupInformation.isSecurityEnabled() && useYarnAuthenticationFilter && hasHadoopAuthFilterInitializer && conf.get(authTypeKey, "").equals("kerberos")) {
                ArrayList<String> target = new ArrayList<String>();
                for (Class filterInitializer : initializersClasses) {
                    if (filterInitializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                        if (hasRMAuthFilterInitializer) continue;
                        target.add(RMAuthenticationFilterInitializer.class.getName());
                        continue;
                    }
                    target.add(filterInitializer.getName());
                }
                target.remove(ProxyUserAuthenticationFilterInitializer.class.getName());
                actualInitializers = StringUtils.join((CharSequence)",", target);
                LOG.info("Using RM authentication filter(kerberos/delegation-token) for RM webapp authentication");
                RMAuthenticationFilter.setDelegationTokenSecretManager(rmDTSecretManager);
                conf.set(filterInitializerConfKey, actualInitializers);
            }
        }
        String initializers = conf.get(filterInitializerConfKey);
        if (!UserGroupInformation.isSecurityEnabled()) {
            if (initializersClasses == null || initializersClasses.length == 0) {
                conf.set(filterInitializerConfKey, RMAuthenticationFilterInitializer.class.getName());
                conf.set(authTypeKey, "simple");
            } else if (initializers.equals(StaticUserWebFilter.class.getName())) {
                conf.set(filterInitializerConfKey, RMAuthenticationFilterInitializer.class.getName() + "," + initializers);
                conf.set(authTypeKey, "simple");
            }
        }
    }

    public static ApplicationSubmissionContext createAppSubmissionContext(ApplicationSubmissionContextInfo newApp, Configuration conf) throws IOException {
        String reservationIdStr;
        ApplicationId appid;
        String error = "Could not parse application id " + newApp.getApplicationId();
        try {
            appid = ApplicationId.fromString((String)newApp.getApplicationId());
        }
        catch (Exception e) {
            throw new BadRequestException(error);
        }
        ApplicationSubmissionContext appContext = ApplicationSubmissionContext.newInstance((ApplicationId)appid, (String)newApp.getApplicationName(), (String)newApp.getQueue(), (Priority)Priority.newInstance((int)newApp.getPriority()), (ContainerLaunchContext)RMWebAppUtil.createContainerLaunchContext(newApp), (boolean)newApp.getUnmanagedAM(), (boolean)newApp.getCancelTokensWhenComplete(), (int)newApp.getMaxAppAttempts(), (Resource)RMWebAppUtil.createAppSubmissionContextResource(newApp, conf), (String)newApp.getApplicationType(), (boolean)newApp.getKeepContainersAcrossApplicationAttempts(), (String)newApp.getAppNodeLabelExpression(), (String)newApp.getAMContainerNodeLabelExpression());
        appContext.setApplicationTags(newApp.getApplicationTags());
        appContext.setAttemptFailuresValidityInterval(newApp.getAttemptFailuresValidityInterval());
        if (newApp.getLogAggregationContextInfo() != null) {
            appContext.setLogAggregationContext(RMWebAppUtil.createLogAggregationContext(newApp.getLogAggregationContextInfo()));
        }
        if ((reservationIdStr = newApp.getReservationId()) != null && !reservationIdStr.isEmpty()) {
            ReservationId reservationId = ReservationId.parseReservationId((String)reservationIdStr);
            appContext.setReservationID(reservationId);
        }
        return appContext;
    }

    private static Resource createAppSubmissionContextResource(ApplicationSubmissionContextInfo newApp, Configuration conf) throws BadRequestException {
        if (newApp.getResource().getvCores() > conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4)) {
            String msg = "Requested more cores than configured max";
            throw new BadRequestException(msg);
        }
        if (newApp.getResource().getMemorySize() > (long)conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192)) {
            String msg = "Requested more memory than configured max";
            throw new BadRequestException(msg);
        }
        Resource r = Resource.newInstance((long)newApp.getResource().getMemorySize(), (int)newApp.getResource().getvCores());
        return r;
    }

    private static ContainerLaunchContext createContainerLaunchContext(ApplicationSubmissionContextInfo newApp) throws BadRequestException, IOException {
        HashMap<String, ByteBuffer> hmap = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, String> entry : newApp.getContainerLaunchContextInfo().getAuxillaryServiceData().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Base64 base64 = new Base64(0, null, true);
            byte[] data = base64.decode((String)entry.getValue());
            hmap.put((String)entry.getKey(), ByteBuffer.wrap(data));
        }
        HashMap<String, LocalResource> hlr = new HashMap<String, LocalResource>();
        for (Map.Entry entry : newApp.getContainerLaunchContextInfo().getResources().entrySet()) {
            LocalResourceInfo l = (LocalResourceInfo)entry.getValue();
            LocalResource lr = LocalResource.newInstance((URL)URL.fromURI((URI)l.getUrl()), (LocalResourceType)l.getType(), (LocalResourceVisibility)l.getVisibility(), (long)l.getSize(), (long)l.getTimestamp());
            hlr.put((String)entry.getKey(), lr);
        }
        DataOutputBuffer out = new DataOutputBuffer();
        Credentials credentials = RMWebAppUtil.createCredentials(newApp.getContainerLaunchContextInfo().getCredentials());
        credentials.writeTokenStorageToStream((DataOutputStream)out);
        ByteBuffer tokens = ByteBuffer.wrap(out.getData());
        ContainerLaunchContext ctx = ContainerLaunchContext.newInstance(hlr, newApp.getContainerLaunchContextInfo().getEnvironment(), newApp.getContainerLaunchContextInfo().getCommands(), hmap, (ByteBuffer)tokens, newApp.getContainerLaunchContextInfo().getAcls());
        return ctx;
    }

    private static Credentials createCredentials(CredentialsInfo credentials) {
        Credentials ret = new Credentials();
        try {
            Text alias;
            for (Map.Entry<String, String> entry : credentials.getTokens().entrySet()) {
                alias = new Text(entry.getKey());
                Token token = new Token();
                token.decodeFromUrlString(entry.getValue());
                ret.addToken(alias, token);
            }
            for (Map.Entry<String, String> entry : credentials.getSecrets().entrySet()) {
                alias = new Text(entry.getKey());
                Base64 decoder = new Base64(0, null, true);
                byte[] secret = decoder.decode(entry.getValue());
                ret.addSecretKey(alias, secret);
            }
        }
        catch (IOException ie) {
            throw new BadRequestException("Could not parse credentials data; exception message = " + ie.getMessage());
        }
        return ret;
    }

    private static LogAggregationContext createLogAggregationContext(LogAggregationContextInfo logAggregationContextInfo) {
        return LogAggregationContext.newInstance((String)logAggregationContextInfo.getIncludePattern(), (String)logAggregationContextInfo.getExcludePattern(), (String)logAggregationContextInfo.getRolledLogsIncludePattern(), (String)logAggregationContextInfo.getRolledLogsExcludePattern(), (String)logAggregationContextInfo.getLogAggregationPolicyClassName(), (String)logAggregationContextInfo.getLogAggregationPolicyParameters());
    }

    public static UserGroupInformation getCallerUserGroupInformation(HttpServletRequest hsr, boolean usePrincipal) {
        String remoteUser = hsr.getRemoteUser();
        if (usePrincipal) {
            Principal princ = hsr.getUserPrincipal();
            remoteUser = princ == null ? null : princ.getName();
        }
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }
}

