/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import org.apache.hadoop.shaded.javax.websocket.EndpointConfig;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdDecoder;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnCloseCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnErrorCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnMessageBinaryCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnMessageBinaryStreamCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnMessagePongCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnMessageTextCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnMessageTextStreamCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.OnOpenCallable;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.DecoderMetadata;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.DecoderMetadataSet;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.EncoderMetadataSet;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;

public abstract class AnnotatedEndpointMetadata<T extends Annotation, C extends EndpointConfig>
implements EndpointMetadata {
    public OnOpenCallable onOpen;
    public OnCloseCallable onClose;
    public OnErrorCallable onError;
    public OnMessageTextCallable onText;
    public OnMessageTextStreamCallable onTextStream;
    public OnMessageBinaryCallable onBinary;
    public OnMessageBinaryStreamCallable onBinaryStream;
    public OnMessagePongCallable onPong;
    private final Class<?> endpointClass;
    private DecoderMetadataSet decoders;
    private EncoderMetadataSet encoders;
    private long maxTextMessageSize = -1L;
    private long maxBinaryMessageSize = -1L;

    protected AnnotatedEndpointMetadata(Class<?> endpointClass) {
        this.endpointClass = endpointClass;
        this.decoders = new DecoderMetadataSet();
        this.encoders = new EncoderMetadataSet();
    }

    public void customizeParamsOnClose(LinkedList<IJsrParamId> params) {
    }

    public void customizeParamsOnError(LinkedList<IJsrParamId> params) {
    }

    public void customizeParamsOnMessage(LinkedList<IJsrParamId> params) {
        for (DecoderMetadata metadata : this.decoders) {
            params.add(new JsrParamIdDecoder(metadata));
        }
    }

    public void customizeParamsOnOpen(LinkedList<IJsrParamId> params) {
    }

    public abstract T getAnnotation();

    public abstract C getConfig();

    @Override
    public long maxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    @Override
    public long maxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    @Override
    public DecoderMetadataSet getDecoders() {
        return this.decoders;
    }

    @Override
    public EncoderMetadataSet getEncoders() {
        return this.encoders;
    }

    @Override
    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public void setMaxBinaryMessageSize(long maxBinaryMessageSize) {
        this.maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public void setMaxTextMessageSize(long maxTextMessageSize) {
        this.maxTextMessageSize = maxTextMessageSize;
    }
}

