/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import org.apache.hadoop.shaded.javax.servlet.MultipartConfigElement;
import org.apache.hadoop.shaded.javax.servlet.Servlet;
import org.apache.hadoop.shaded.javax.servlet.annotation.MultipartConfig;
import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.Descriptor;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.MetaData;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.WebAppContext;

public class MultiPartConfigAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _context;

    public MultiPartConfigAnnotationHandler(WebAppContext context) {
        super(false);
        this._context = context;
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        MultipartConfig multi = clazz.getAnnotation(MultipartConfig.class);
        if (multi == null) {
            return;
        }
        MetaData metaData = this._context.getMetaData();
        for (ServletHolder holder : this._context.getServletHandler().getServlets(clazz)) {
            Descriptor d = metaData.getOriginDescriptor(holder.getName() + ".servlet.multipart-config");
            if (d != null) continue;
            metaData.setOrigin(holder.getName() + ".servlet.multipart-config", (Annotation)multi, clazz);
            holder.getRegistration().setMultipartConfig(new MultipartConfigElement(multi));
        }
    }
}

