/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.wildfly.openssl.OpenSSLSessionContext;
import org.wildfly.openssl.OpenSSlSession;
import org.wildfly.openssl.SSL;
import org.wildfly.openssl.util.ConcurrentDirectDeque;

public final class OpenSSLClientSessionContext
extends OpenSSLSessionContext {
    private final Map<ClientSessionKey, CacheEntry> cache;
    private final ConcurrentDirectDeque<CacheEntry> accessQueue;
    private volatile int timeout;
    private final long context;
    private int maxCacheSize = 100;
    private String handshakeKeyHost;
    private int handshakeKeyPort;

    OpenSSLClientSessionContext(long context) {
        super(context);
        this.context = context;
        this.cache = new ConcurrentHashMap<ClientSessionKey, CacheEntry>();
        this.accessQueue = ConcurrentDirectDeque.newInstance();
    }

    @Override
    synchronized void sessionCreatedCallback(long ssl, long session, byte[] sessionId) {
        this.storeClientSideSession(this.getHandshakeKey(), ssl, session, sessionId);
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = seconds;
    }

    @Override
    public int getSessionTimeout() {
        return this.timeout;
    }

    @Override
    public void setSessionCacheSize(int size) {
        this.maxCacheSize = size;
        this.purgeOld();
    }

    @Override
    void remove(byte[] session) {
        super.remove(session);
    }

    @Override
    public int getSessionCacheSize() {
        return this.maxCacheSize;
    }

    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? 1L : 0L;
        SSL.getInstance().setSessionCacheMode(this.context, mode);
    }

    public boolean isSessionCacheEnabled() {
        return SSL.getInstance().getSessionCacheMode(this.context) == 1L;
    }

    void setHandshakeKeyHost(String handshakeKeyHost) {
        this.handshakeKeyHost = handshakeKeyHost;
    }

    void setHandshakeKeyPort(int handshakeKeyPort) {
        this.handshakeKeyPort = handshakeKeyPort;
    }

    public ClientSessionKey getHandshakeKey() {
        if (this.handshakeKeyHost != null && this.handshakeKeyPort >= 0) {
            return new ClientSessionKey(this.handshakeKeyHost, this.handshakeKeyPort);
        }
        return null;
    }

    synchronized void storeClientSideSession(ClientSessionKey key, long ssl, long sessionPointer, byte[] sessionId) {
        if (sessionId != null && key != null) {
            ClientSessionInfo foundSessionPtr = this.getCacheValue(key);
            if (foundSessionPtr != null) {
                if (this.getSession(foundSessionPtr.sessionId) != null) {
                    this.removeCacheEntry(key);
                } else {
                    this.removeCacheEntry(key);
                }
            }
            this.addCacheEntry(key, new ClientSessionInfo(sessionPointer, sessionId, System.currentTimeMillis()));
            this.clientSessionCreated(ssl, sessionPointer, sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryAttachClientSideSession(long ssl, String host, int port) {
        ClientSessionKey key;
        ClientSessionInfo foundSessionPtr;
        if (host != null && port >= 0 && (foundSessionPtr = this.getCacheValue(key = new ClientSessionKey(host, port))) != null) {
            OpenSSlSession existingSession = this.getOpenSSlSession(foundSessionPtr.sessionId);
            if (existingSession == null) {
                this.removeCacheEntry(key);
            } else {
                OpenSSlSession openSSlSession = existingSession;
                synchronized (openSSlSession) {
                    if (existingSession.isValid()) {
                        SSL.getInstance().setSession(ssl, foundSessionPtr.session);
                    }
                }
            }
        }
    }

    private void purgeOld() {
        int removeSize;
        if (this.maxCacheSize > 0 && (removeSize = this.cache.size() - this.maxCacheSize) > 0) {
            CacheEntry oldest;
            for (int i = 0; i < removeSize && (oldest = (CacheEntry)this.accessQueue.poll()) != null; ++i) {
                this.removeCacheEntry(oldest.key());
            }
        }
    }

    private void addCacheEntry(ClientSessionKey key, ClientSessionInfo newValue) {
        CacheEntry value = this.cache.get(key);
        if (value == null) {
            CacheEntry oldest;
            value = new CacheEntry(key, newValue);
            CacheEntry result = this.cache.putIfAbsent(key, value);
            if (result != null) {
                value = result;
                value.setValue(newValue);
            }
            this.bumpAccess(value);
            if (this.maxCacheSize > 0 && this.cache.size() > this.maxCacheSize && (oldest = (CacheEntry)this.accessQueue.poll()) != value) {
                this.removeCacheEntry(oldest.key());
            }
        }
    }

    private ClientSessionInfo getCacheValue(ClientSessionKey key) {
        CacheEntry cacheEntry = this.cache.get(key);
        if (cacheEntry == null) {
            return null;
        }
        if (this.timeout > 0) {
            long expires = cacheEntry.getTime() + (long)(this.timeout * 1000);
            if (System.currentTimeMillis() > expires) {
                this.removeCacheEntry(key);
                return null;
            }
        }
        if (cacheEntry.hit() % 5 == 0) {
            this.bumpAccess(cacheEntry);
        }
        return cacheEntry.getValue();
    }

    private ClientSessionInfo removeCacheEntry(ClientSessionKey key) {
        CacheEntry remove = this.cache.remove(key);
        if (remove != null) {
            ClientSessionInfo result;
            Object old = remove.clearToken();
            if (old != null) {
                this.accessQueue.removeToken(old);
            }
            if ((result = remove.getValue()) != null) {
                this.invalidateIfPresent(result.sessionId);
            }
            return result;
        }
        return null;
    }

    private void bumpAccess(CacheEntry cacheEntry) {
        Object prevToken = cacheEntry.claimToken();
        if (prevToken != Boolean.FALSE) {
            if (prevToken != null) {
                this.accessQueue.removeToken(prevToken);
            }
            Object token = null;
            try {
                token = this.accessQueue.offerLastAndReturnToken(cacheEntry);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!cacheEntry.setToken(token) && token != null) {
                this.accessQueue.removeToken(token);
            }
        }
    }

    private static final class CacheEntry {
        private static final Object CLAIM_TOKEN = new Object();
        private static final AtomicIntegerFieldUpdater<CacheEntry> hitsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "hits");
        private static final AtomicReferenceFieldUpdater<CacheEntry, Object> tokenUpdater = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, Object.class, "accessToken");
        private final ClientSessionKey key;
        private volatile ClientSessionInfo value;
        private volatile int hits = 1;
        private volatile Object accessToken;

        private CacheEntry(ClientSessionKey key, ClientSessionInfo value) {
            this.key = key;
            this.value = value;
        }

        void setValue(ClientSessionInfo value) {
            this.value = value;
        }

        ClientSessionInfo getValue() {
            return this.value;
        }

        int hit() {
            int i;
            do {
                i = this.hits;
            } while (!hitsUpdater.weakCompareAndSet(this, i++, i));
            return i;
        }

        ClientSessionKey key() {
            return this.key;
        }

        Object claimToken() {
            Object current;
            do {
                if ((current = this.accessToken) != CLAIM_TOKEN) continue;
                return Boolean.FALSE;
            } while (!tokenUpdater.compareAndSet(this, current, CLAIM_TOKEN));
            return current;
        }

        boolean setToken(Object token) {
            return tokenUpdater.compareAndSet(this, CLAIM_TOKEN, token);
        }

        Object clearToken() {
            Object old = tokenUpdater.getAndSet(this, null);
            return old == CLAIM_TOKEN ? null : old;
        }

        long getTime() {
            return this.value.time;
        }
    }

    private static final class ClientSessionInfo {
        final long session;
        final byte[] sessionId;
        final long time;

        private ClientSessionInfo(long session, byte[] sessionId, long time) {
            this.session = session;
            this.sessionId = sessionId;
            this.time = time;
        }
    }

    private static class ClientSessionKey {
        private final String host;
        private final int port;

        private ClientSessionKey(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClientSessionKey)) {
                return false;
            }
            ClientSessionKey other = (ClientSessionKey)obj;
            return Objects.equals(this.host, other.host) && this.port == other.port;
        }
    }
}

