/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.shaded.org.xbill.DNS.DClass;
import org.apache.hadoop.shaded.org.xbill.DNS.Message;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.Rcode;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.Resolver;
import org.apache.hadoop.shaded.org.xbill.DNS.SOARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Section;
import org.apache.hadoop.shaded.org.xbill.DNS.SimpleResolver;
import org.apache.hadoop.shaded.org.xbill.DNS.TSIG;
import org.apache.hadoop.shaded.org.xbill.DNS.TTL;
import org.apache.hadoop.shaded.org.xbill.DNS.TextParseException;
import org.apache.hadoop.shaded.org.xbill.DNS.Tokenizer;
import org.apache.hadoop.shaded.org.xbill.DNS.Type;

public class update {
    Message query;
    Message response;
    Resolver res;
    String server = null;
    Name zone = Name.root;
    long defaultTTL;
    int defaultClass = 1;
    PrintStream log = null;

    void print(Object o) {
        System.out.println(o);
        if (this.log != null) {
            this.log.println(o);
        }
    }

    public Message newMessage() {
        Message msg = new Message();
        msg.getHeader().setOpcode(5);
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    public update(InputStream in) {
        super();
        inputs = new LinkedList<BufferedReader>();
        istreams = new LinkedList<InputStream>();
        this.query = this.newMessage();
        isr = new InputStreamReader(in);
        br = new BufferedReader(isr);
        inputs.add(br);
        istreams.add(in);
        while (true) {
            try {
                while (true) lbl-1000:
                // 35 sources

                {
                    is = (InputStream)istreams.get(0);
                    br = (BufferedReader)inputs.get(0);
                    if (is == System.in) {
                        System.out.print("> ");
                    }
                    if ((line = br.readLine()) == null) {
                        br.close();
                        inputs.remove(0);
                        istreams.remove(0);
                        if (inputs.isEmpty()) {
                            return;
                        }
                    }
                    if (line == null) continue;
                    if (this.log != null) {
                        this.log.println("> " + line);
                    }
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    if (line.charAt(0) == '>') {
                        line = line.substring(1);
                    }
                    st = new Tokenizer(line);
                    try {
                        token = st.get();
                        if (token.isEOL()) ** GOTO lbl-1000
                        var10_16 = operation = token.value();
                        var11_17 = -1;
                        switch (var10_16.hashCode()) {
                            case -905826493: {
                                if (!var10_16.equals("server")) break;
                                var11_17 = 0;
                                break;
                            }
                            case 106079: {
                                if (!var10_16.equals("key")) break;
                                var11_17 = 1;
                                break;
                            }
                            case 3108516: {
                                if (!var10_16.equals("edns")) break;
                                var11_17 = 2;
                                break;
                            }
                            case 3446913: {
                                if (!var10_16.equals("port")) break;
                                var11_17 = 3;
                                break;
                            }
                            case 114657: {
                                if (!var10_16.equals("tcp")) break;
                                var11_17 = 4;
                                break;
                            }
                            case 94742904: {
                                if (!var10_16.equals("class")) break;
                                var11_17 = 5;
                                break;
                            }
                            case 115180: {
                                if (!var10_16.equals("ttl")) break;
                                var11_17 = 6;
                                break;
                            }
                            case -1008619738: {
                                if (!var10_16.equals("origin")) break;
                                var11_17 = 7;
                                break;
                            }
                            case 3744684: {
                                if (!var10_16.equals("zone")) break;
                                var11_17 = 8;
                                break;
                            }
                            case 1095696741: {
                                if (!var10_16.equals("require")) break;
                                var11_17 = 9;
                                break;
                            }
                            case -1000426017: {
                                if (!var10_16.equals("prohibit")) break;
                                var11_17 = 10;
                                break;
                            }
                            case 96417: {
                                if (!var10_16.equals("add")) break;
                                var11_17 = 11;
                                break;
                            }
                            case -1335458389: {
                                if (!var10_16.equals("delete")) break;
                                var11_17 = 12;
                                break;
                            }
                            case 3175989: {
                                if (!var10_16.equals("glue")) break;
                                var11_17 = 13;
                                break;
                            }
                            case 3198785: {
                                if (!var10_16.equals("help")) break;
                                var11_17 = 14;
                                break;
                            }
                            case 63: {
                                if (!var10_16.equals("?")) break;
                                var11_17 = 15;
                                break;
                            }
                            case 3107365: {
                                if (!var10_16.equals("echo")) break;
                                var11_17 = 16;
                                break;
                            }
                            case 3526536: {
                                if (!var10_16.equals("send")) break;
                                var11_17 = 17;
                                break;
                            }
                            case 3529469: {
                                if (!var10_16.equals("show")) break;
                                var11_17 = 18;
                                break;
                            }
                            case 94746189: {
                                if (!var10_16.equals("clear")) break;
                                var11_17 = 19;
                                break;
                            }
                            case 107944136: {
                                if (!var10_16.equals("query")) break;
                                var11_17 = 20;
                                break;
                            }
                            case 3482191: {
                                if (!var10_16.equals("quit")) break;
                                var11_17 = 21;
                                break;
                            }
                            case 113: {
                                if (!var10_16.equals("q")) break;
                                var11_17 = 22;
                                break;
                            }
                            case 3143036: {
                                if (!var10_16.equals("file")) break;
                                var11_17 = 23;
                                break;
                            }
                            case 107332: {
                                if (!var10_16.equals("log")) break;
                                var11_17 = 24;
                                break;
                            }
                            case -1408208058: {
                                if (!var10_16.equals("assert")) break;
                                var11_17 = 25;
                                break;
                            }
                            case 109522647: {
                                if (!var10_16.equals("sleep")) break;
                                var11_17 = 26;
                                break;
                            }
                            case 3076014: {
                                if (!var10_16.equals("date")) break;
                                var11_17 = 27;
                            }
                        }
                        switch (var11_17) {
                            case 0: {
                                this.server = st.getString();
                                this.res = new SimpleResolver(this.server);
                                token = st.get();
                                if (!token.isString()) ** GOTO lbl-1000
                                portstr = token.value();
                                this.res.setPort(Short.parseShort(portstr));
                            }
                            case 1: {
                                keyname = st.getString();
                                keydata = st.getString();
                                if (this.res == null) {
                                    this.res = new SimpleResolver(this.server);
                                }
                                this.res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, keyname, keydata));
                            }
                            case 2: {
                                if (this.res == null) {
                                    this.res = new SimpleResolver(this.server);
                                }
                                this.res.setEDNS(st.getUInt16());
                            }
                            case 3: {
                                if (this.res == null) {
                                    this.res = new SimpleResolver(this.server);
                                }
                                this.res.setPort(st.getUInt16());
                            }
                            case 4: {
                                if (this.res == null) {
                                    this.res = new SimpleResolver(this.server);
                                }
                                this.res.setTCP(true);
                            }
                            case 5: {
                                classStr = st.getString();
                                newClass = DClass.value(classStr);
                                if (newClass > 0) {
                                    this.defaultClass = newClass;
                                }
                                this.print("Invalid class " + classStr);
                            }
                            case 6: {
                                this.defaultTTL = st.getTTL();
                            }
                            case 7: 
                            case 8: {
                                this.zone = st.getName(Name.root);
                            }
                            case 9: {
                                this.doRequire(st);
                            }
                            case 10: {
                                this.doProhibit(st);
                            }
                            case 11: {
                                this.doAdd(st);
                            }
                            case 12: {
                                this.doDelete(st);
                            }
                            case 13: {
                                this.doGlue(st);
                            }
                            case 14: 
                            case 15: {
                                token = st.get();
                                if (token.isString()) {
                                    update.help(token.value());
                                }
                                update.help(null);
                            }
                            case 16: {
                                this.print(line.substring(4).trim());
                            }
                            case 17: {
                                this.sendUpdate();
                                this.query = this.newMessage();
                            }
                            case 18: {
                                this.print(this.query);
                            }
                            case 19: {
                                this.query = this.newMessage();
                            }
                            case 20: {
                                this.doQuery(st);
                            }
                            case 21: 
                            case 22: {
                                if (this.log != null) {
                                    this.log.close();
                                }
                                for (BufferedReader input : inputs) {
                                    input.close();
                                }
                                System.exit(0);
                            }
                            case 23: {
                                this.doFile(st, inputs, istreams);
                            }
                            case 24: {
                                this.doLog(st);
                            }
                            case 25: {
                                if (this.doAssert(st)) ** GOTO lbl-1000
                                return;
                            }
                            case 26: {
                                interval = st.getUInt32();
                                try {
                                    Thread.sleep(interval);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw new IOException(e);
                                }
                            }
                            case 27: {
                                now = Instant.now();
                                token = st.get();
                                if (token.isString() && token.value().equals("-ms")) {
                                    this.print(Long.toString(now.toEpochMilli()));
                                }
                                this.print(now);
                            }
                            default: {
                                this.print("invalid keyword: " + operation);
                            }
                        }
                    }
                    finally {
                        st.close();
                        continue;
                    }
                    break;
                }
            }
            catch (TextParseException tpe) {
                System.out.println(tpe.getMessage());
                continue;
            }
            catch (InterruptedIOException iioe) {
                System.out.println("Operation timed out");
                continue;
            }
            catch (SocketException se) {
                System.out.println("Socket error");
                continue;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    void sendUpdate() throws IOException {
        if (this.query.getHeader().getCount(2) == 0) {
            this.print("Empty update message.  Ignoring.");
            return;
        }
        if (this.query.getHeader().getCount(0) == 0) {
            Name updzone = this.zone;
            int dclass = this.defaultClass;
            if (updzone == null) {
                for (Record rec : this.query.getSection(2)) {
                    if (updzone == null) {
                        updzone = new Name(rec.getName(), 1);
                    }
                    if (rec.getDClass() == 254 || rec.getDClass() == 255) continue;
                    dclass = rec.getDClass();
                    break;
                }
            }
            Record soa = Record.newRecord(updzone, 6, dclass);
            this.query.addRecord(soa, 0);
        }
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(this.query);
        this.print(this.response);
    }

    Record parseRR(Tokenizer st, int classValue, long TTLValue) throws IOException {
        int type;
        long ttl;
        Name name = st.getName(this.zone);
        String s2 = st.getString();
        try {
            ttl = TTL.parseTTL(s2);
            s2 = st.getString();
        }
        catch (NumberFormatException e) {
            ttl = TTLValue;
        }
        if (DClass.value(s2) >= 0) {
            classValue = DClass.value(s2);
            s2 = st.getString();
        }
        if ((type = Type.value(s2)) < 0) {
            throw new IOException("Invalid type: " + s2);
        }
        return Record.fromString(name, type, classValue, ttl, st, this.zone);
    }

    void doRequire(Tokenizer st) throws IOException {
        Record r;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            int type = Type.value(token.value());
            if (type < 0) {
                throw new IOException("Invalid type: " + token.value());
            }
            token = st.get();
            boolean iseol = token.isEOL();
            st.unget();
            r = !iseol ? Record.fromString(name, type, this.defaultClass, 0L, st, this.zone) : Record.newRecord(name, type, 255, 0L);
        } else {
            r = Record.newRecord(name, 255, 255, 0L);
        }
        this.query.addRecord(r, 1);
        this.print(r);
    }

    void doProhibit(Tokenizer st) throws IOException {
        int type;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            type = Type.value(token.value());
            if (type < 0) {
                throw new IOException("Invalid type: " + token.value());
            }
        } else {
            type = 255;
        }
        Record r = Record.newRecord(name, type, 254, 0L);
        this.query.addRecord(r, 1);
        this.print(r);
    }

    void doAdd(Tokenizer st) throws IOException {
        Record r = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(r, 2);
        this.print(r);
    }

    void doDelete(Tokenizer st) throws IOException {
        Record r;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            int type;
            String s2 = token.value();
            if (DClass.value(s2) >= 0) {
                s2 = st.getString();
            }
            if ((type = Type.value(s2)) < 0) {
                throw new IOException("Invalid type: " + s2);
            }
            token = st.get();
            boolean iseol = token.isEOL();
            st.unget();
            r = !iseol ? Record.fromString(name, type, 254, 0L, st, this.zone) : Record.newRecord(name, type, 255, 0L);
        } else {
            r = Record.newRecord(name, 255, 255, 0L);
        }
        this.query.addRecord(r, 2);
        this.print(r);
    }

    void doGlue(Tokenizer st) throws IOException {
        Record r = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(r, 3);
        this.print(r);
    }

    void doQuery(Tokenizer st) throws IOException {
        int type = 1;
        int dclass = this.defaultClass;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            type = Type.value(token.value());
            if (type < 0) {
                throw new IOException("Invalid type");
            }
            token = st.get();
            if (token.isString() && (dclass = DClass.value(token.value())) < 0) {
                throw new IOException("Invalid class");
            }
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message newQuery = Message.newQuery(rec);
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(newQuery);
        this.print(this.response);
    }

    void doFile(Tokenizer st, List<BufferedReader> inputs, List<InputStream> istreams) throws IOException {
        String s2 = st.getString();
        try {
            InputStream is = s2.equals("-") ? System.in : new FileInputStream(s2);
            istreams.add(0, is);
            inputs.add(0, new BufferedReader(new InputStreamReader(is)));
        }
        catch (FileNotFoundException e) {
            this.print(s2 + " not found");
        }
    }

    void doLog(Tokenizer st) throws IOException {
        String s2 = st.getString();
        try (FileOutputStream fos = new FileOutputStream(s2);){
            this.log = new PrintStream(fos);
        }
        catch (Exception e) {
            this.print("Error opening " + s2);
        }
    }

    boolean doAssert(Tokenizer st) throws IOException {
        String field = st.getString();
        String expected = st.getString();
        String value = null;
        boolean flag = true;
        if (this.response == null) {
            this.print("No response has been received");
            return true;
        }
        if (field.equalsIgnoreCase("rcode")) {
            int rcode = this.response.getHeader().getRcode();
            if (rcode != Rcode.value(expected)) {
                value = Rcode.string(rcode);
                flag = false;
            }
        } else if (field.equalsIgnoreCase("serial")) {
            List<Record> answers = this.response.getSection(1);
            if (answers.isEmpty() || !(answers.get(0) instanceof SOARecord)) {
                this.print("Invalid response (no SOA)");
            } else {
                SOARecord soa = (SOARecord)answers.get(0);
                long serial = soa.getSerial();
                if (serial != Long.parseLong(expected)) {
                    value = Long.toString(serial);
                    flag = false;
                }
            }
        } else if (field.equalsIgnoreCase("tsig")) {
            value = this.response.isSigned() ? (this.response.isVerified() ? "ok" : "failed") : "unsigned";
            if (!value.equalsIgnoreCase(expected)) {
                flag = false;
            }
        } else {
            int section = Section.value(field);
            if (section >= 0) {
                int count = this.response.getHeader().getCount(section);
                if (count != Integer.parseInt(expected)) {
                    value = Integer.toString(count);
                    flag = false;
                }
            } else {
                this.print("Invalid assertion keyword: " + field);
            }
        }
        if (!flag) {
            Tokenizer.Token token;
            this.print("Expected " + field + " " + expected + ", received " + value);
            while ((token = st.get()).isString()) {
                this.print(token.value());
            }
            st.unget();
        }
        return flag;
    }

    static void help(String topic) {
        System.out.println();
        if (topic == null) {
            System.out.println("The following are supported commands:\nadd      assert   class    clear    date     delete\necho     edns     file     glue     help     key\nlog      port     prohibit query    quit     require\nsend     server   show     sleep    tcp      ttl\nzone     #\n");
            return;
        }
        switch (topic = topic.toLowerCase()) {
            case "add": {
                System.out.println("add <name> [ttl] [class] <type> <data>\n\nspecify a record to be added\n");
                break;
            }
            case "assert": {
                System.out.println("assert <field> <value> [msg]\n\nasserts that the value of the field in the last\nresponse matches the value specified.  If not,\nthe message is printed (if present) and the\nprogram exits.  The field may be any of <rcode>,\n<serial>, <tsig>, <qu>, <an>, <au>, or <ad>.\n");
                break;
            }
            case "class": {
                System.out.println("class <class>\n\nclass of the zone to be updated (default: IN)\n");
                break;
            }
            case "clear": {
                System.out.println("clear\n\nclears the current update packet\n");
                break;
            }
            case "date": {
                System.out.println("date [-ms]\n\nprints the current date and time in human readable\nformat or as the number of milliseconds since the\nepoch");
                break;
            }
            case "delete": {
                System.out.println("delete <name> [ttl] [class] <type> <data> \ndelete <name> <type> \ndelete <name>\n\nspecify a record or set to be deleted, or that\nall records at a name should be deleted\n");
                break;
            }
            case "echo": {
                System.out.println("echo <text>\n\nprints the text\n");
                break;
            }
            case "edns": {
                System.out.println("edns <level>\n\nEDNS level specified when sending messages\n");
                break;
            }
            case "file": {
                System.out.println("file <file>\n\nopens the specified file as the new input source\n(- represents stdin)\n");
                break;
            }
            case "glue": {
                System.out.println("glue <name> [ttl] [class] <type> <data>\n\nspecify an additional record\n");
                break;
            }
            case "help": {
                System.out.println("help\nhelp [topic]\n\nprints a list of commands or help about a specific\ncommand\n");
                break;
            }
            case "key": {
                System.out.println("key <name> <data>\n\nTSIG key used to sign messages\n");
                break;
            }
            case "log": {
                System.out.println("log <file>\n\nopens the specified file and uses it to log output\n");
                break;
            }
            case "port": {
                System.out.println("port <port>\n\nUDP/TCP port messages are sent to (default: 53)\n");
                break;
            }
            case "prohibit": {
                System.out.println("prohibit <name> <type> \nprohibit <name>\n\nrequire that a set or name is not present\n");
                break;
            }
            case "query": {
                System.out.println("query <name> [type [class]] \n\nissues a query\n");
                break;
            }
            case "q": 
            case "quit": {
                System.out.println("quit\n\nquits the program\n");
                break;
            }
            case "require": {
                System.out.println("require <name> [ttl] [class] <type> <data> \nrequire <name> <type> \nrequire <name>\n\nrequire that a record, set, or name is present\n");
                break;
            }
            case "send": {
                System.out.println("send\n\nsends and resets the current update packet\n");
                break;
            }
            case "server": {
                System.out.println("server <name> [port]\n\nserver that receives send updates/queries\n");
                break;
            }
            case "show": {
                System.out.println("show\n\nshows the current update packet\n");
                break;
            }
            case "sleep": {
                System.out.println("sleep <milliseconds>\n\npause for interval before next command\n");
                break;
            }
            case "tcp": {
                System.out.println("tcp\n\nTCP should be used to send all messages\n");
                break;
            }
            case "ttl": {
                System.out.println("ttl <ttl>\n\ndefault ttl of added records (default: 0)\n");
                break;
            }
            case "zone": 
            case "origin": {
                System.out.println("zone <zone>\n\nzone to update (default: .\n");
                break;
            }
            case "#": {
                System.out.println("# <text>\n\na comment\n");
                break;
            }
            default: {
                System.out.println("Topic '" + topic + "' unrecognized\n");
            }
        }
    }

    public static void main(String[] args) {
        InputStream in = null;
        if (args.length >= 1) {
            try {
                in = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException e) {
                System.out.println(args[0] + " not found.");
                System.exit(1);
            }
        } else {
            in = System.in;
        }
        new update(in);
    }
}

