/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.hadoop.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.Mnemonic;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.Options;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.Tokenizer;
import org.apache.hadoop.shaded.org.xbill.DNS.WireParseException;
import org.apache.hadoop.shaded.org.xbill.DNS.utils.base16;

public class ZoneMDRecord
extends Record {
    private long serial;
    private int scheme;
    private int hashAlgorithm;
    private byte[] digest;

    ZoneMDRecord() {
    }

    public ZoneMDRecord(Name name, int dclass, long ttl, long serial, int scheme, int hashAlgorithm, byte[] digest) {
        super(name, 63, dclass, ttl);
        this.serial = ZoneMDRecord.checkU32("serial", serial);
        this.scheme = ZoneMDRecord.checkU8("scheme", scheme);
        this.hashAlgorithm = ZoneMDRecord.checkU8("hashAlgorithm", hashAlgorithm);
        String validateDigestSizeMessage = this.getDigestSizeExceptionMessage(hashAlgorithm, digest);
        if (validateDigestSizeMessage != null) {
            throw new IllegalArgumentException(validateDigestSizeMessage);
        }
        this.digest = digest;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU32(this.serial);
        out.writeU8(this.scheme);
        out.writeU8(this.hashAlgorithm);
        out.writeByteArray(this.digest);
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.serial = in.readU32();
        this.scheme = in.readU8();
        this.hashAlgorithm = in.readU8();
        this.digest = in.readByteArray();
        String validateDigestSizeMessage = this.getDigestSizeExceptionMessage(this.hashAlgorithm, this.digest);
        if (validateDigestSizeMessage != null) {
            throw new WireParseException(validateDigestSizeMessage);
        }
    }

    @Override
    protected String rrToString() {
        String rr = this.serial + " " + this.scheme + " " + this.hashAlgorithm + " ";
        rr = Options.multiline() ? rr + "(" + base16.toString(this.digest, 48, "\t", true) : rr + base16.toString(this.digest);
        return rr;
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.serial = st.getUInt32();
        this.scheme = st.getUInt8();
        this.hashAlgorithm = st.getUInt8();
        this.digest = st.getHex(true);
        String validateDigestSizeMessage = this.getDigestSizeExceptionMessage(this.hashAlgorithm, this.digest);
        if (validateDigestSizeMessage != null) {
            throw st.exception(validateDigestSizeMessage);
        }
    }

    private String getDigestSizeExceptionMessage(int hashAlgorithm, byte[] digest) {
        int len = Hash.hashLength(hashAlgorithm);
        if (len != -1 && len != digest.length) {
            return "Digest size for " + Hash.string(hashAlgorithm) + " be exactly " + Hash.hashLength(hashAlgorithm) + " bytes, got " + digest.length;
        }
        if (digest.length < 12) {
            return "Digest size must be at least 12 bytes, got " + digest.length;
        }
        return null;
    }

    @Generated
    public long getSerial() {
        return this.serial;
    }

    @Generated
    public int getScheme() {
        return this.scheme;
    }

    @Generated
    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Generated
    public byte[] getDigest() {
        return this.digest;
    }

    public static final class Hash {
        public static final int RESERVED = 0;
        public static final int SHA384 = 1;
        public static final int SHA512 = 2;
        private static final Mnemonic schemes = new Mnemonic("ZONEMD Hash Algorithms", 2);
        private static final Map<Integer, Integer> hashLengths = new HashMap<Integer, Integer>(2);

        public static String string(int alg) {
            return schemes.getText(alg);
        }

        public static int value(String s2) {
            return schemes.getValue(s2);
        }

        public static int hashLength(int hashAlgorithm) {
            Integer len = hashLengths.get(hashAlgorithm);
            return len == null ? -1 : len;
        }

        @Generated
        private Hash() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            schemes.setMaximum(255);
            schemes.setNumericAllowed(true);
            schemes.add(0, "RESERVED");
            schemes.add(1, "SHA384");
            hashLengths.put(1, 48);
            schemes.add(2, "SHA512");
            hashLengths.put(2, 64);
        }
    }

    public static final class Scheme {
        public static final int RESERVED = 0;
        public static final int SIMPLE = 1;
        private static final Mnemonic schemes = new Mnemonic("ZONEMD Schemes", 2);

        public static String string(int alg) {
            return schemes.getText(alg);
        }

        public static int value(String s2) {
            return schemes.getValue(s2);
        }

        @Generated
        private Scheme() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            schemes.setMaximum(255);
            schemes.setNumericAllowed(true);
            schemes.add(0, "RESERVED");
            schemes.add(1, "SIMPLE");
        }
    }
}

