/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.auth0.jwt.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.shaded.com.auth0.jwt.exceptions.JWTDecodeException;
import org.apache.hadoop.shaded.com.auth0.jwt.impl.BasicHeader;
import org.apache.hadoop.shaded.com.auth0.jwt.interfaces.Header;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

class HeaderDeserializer
extends StdDeserializer<Header> {
    HeaderDeserializer() {
        super(Header.class);
    }

    @Override
    public Header deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map<String, JsonNode> tree = p.getCodec().readValue(p, new TypeReference<Map<String, JsonNode>>(){});
        if (tree == null) {
            throw new JWTDecodeException("Parsing the Header's JSON resulted on a Null map");
        }
        String algorithm = this.getString(tree, "alg");
        String type = this.getString(tree, "typ");
        String contentType = this.getString(tree, "cty");
        String keyId = this.getString(tree, "kid");
        return new BasicHeader(algorithm, type, contentType, keyId, tree, p.getCodec());
    }

    String getString(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText(null);
    }
}

