/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.auth0.jwt.algorithms;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Base64;
import org.apache.hadoop.shaded.com.auth0.jwt.algorithms.Algorithm;
import org.apache.hadoop.shaded.com.auth0.jwt.algorithms.CryptoHelper;
import org.apache.hadoop.shaded.com.auth0.jwt.exceptions.SignatureGenerationException;
import org.apache.hadoop.shaded.com.auth0.jwt.exceptions.SignatureVerificationException;
import org.apache.hadoop.shaded.com.auth0.jwt.interfaces.DecodedJWT;
import org.apache.hadoop.shaded.com.auth0.jwt.interfaces.ECDSAKeyProvider;

class ECDSAAlgorithm
extends Algorithm {
    private final ECDSAKeyProvider keyProvider;
    private final CryptoHelper crypto;
    private final int ecNumberSize;

    ECDSAAlgorithm(CryptoHelper crypto, String id, String algorithm, int ecNumberSize, ECDSAKeyProvider keyProvider) throws IllegalArgumentException {
        super(id, algorithm);
        if (keyProvider == null) {
            throw new IllegalArgumentException("The Key Provider cannot be null.");
        }
        this.keyProvider = keyProvider;
        this.crypto = crypto;
        this.ecNumberSize = ecNumberSize;
    }

    ECDSAAlgorithm(String id, String algorithm, int ecNumberSize, ECDSAKeyProvider keyProvider) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, ecNumberSize, keyProvider);
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        try {
            byte[] signatureBytes = Base64.getUrlDecoder().decode(jwt.getSignature());
            ECPublicKey publicKey = (ECPublicKey)this.keyProvider.getPublicKeyById(jwt.getKeyId());
            if (publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            this.validateSignatureStructure(signatureBytes, publicKey);
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), (PublicKey)publicKey, jwt.getHeader(), jwt.getPayload(), this.JOSEToDER(signatureBytes));
            if (!valid) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) throws SignatureGenerationException {
        try {
            ECPrivateKey privateKey = (ECPrivateKey)this.keyProvider.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            byte[] signature = this.crypto.createSignatureFor(this.getDescription(), privateKey, headerBytes, payloadBytes);
            return this.DERToJOSE(signature);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            ECPrivateKey privateKey = (ECPrivateKey)this.keyProvider.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            byte[] signature = this.crypto.createSignatureFor(this.getDescription(), privateKey, contentBytes);
            return this.DERToJOSE(signature);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public String getSigningKeyId() {
        return this.keyProvider.getPrivateKeyId();
    }

    byte[] DERToJOSE(byte[] derSignature) throws SignatureException {
        int encodedLength;
        boolean derEncoded;
        boolean bl = derEncoded = derSignature[0] == 48 && derSignature.length != this.ecNumberSize * 2;
        if (!derEncoded) {
            throw new SignatureException("Invalid DER signature format.");
        }
        byte[] joseSignature = new byte[this.ecNumberSize * 2];
        int offset = 1;
        if (derSignature[1] == -127) {
            // empty if block
        }
        if ((encodedLength = derSignature[++offset] & 0xFF) != derSignature.length - ++offset) {
            throw new SignatureException("Invalid DER signature format.");
        }
        int n = ++offset;
        ++offset;
        byte rlength = derSignature[n];
        if (rlength > this.ecNumberSize + 1) {
            throw new SignatureException("Invalid DER signature format.");
        }
        int rpadding = this.ecNumberSize - rlength;
        System.arraycopy(derSignature, offset + Math.max(-rpadding, 0), joseSignature, Math.max(rpadding, 0), rlength + Math.min(rpadding, 0));
        offset += rlength + 1;
        byte slength = derSignature[offset++];
        if (slength > this.ecNumberSize + 1) {
            throw new SignatureException("Invalid DER signature format.");
        }
        int spadding = this.ecNumberSize - slength;
        System.arraycopy(derSignature, offset + Math.max(-spadding, 0), joseSignature, this.ecNumberSize + Math.max(spadding, 0), slength + Math.min(spadding, 0));
        return joseSignature;
    }

    void validateSignatureStructure(byte[] joseSignature, ECPublicKey publicKey) throws SignatureException {
        int sPadding;
        int sLength;
        if (joseSignature.length != this.ecNumberSize * 2) {
            throw new SignatureException("Invalid JOSE signature format.");
        }
        if (this.isAllZeros(joseSignature)) {
            throw new SignatureException("Invalid signature format.");
        }
        byte[] rBytes = new byte[this.ecNumberSize];
        System.arraycopy(joseSignature, 0, rBytes, 0, this.ecNumberSize);
        if (this.isAllZeros(rBytes)) {
            throw new SignatureException("Invalid signature format.");
        }
        byte[] sBytes = new byte[this.ecNumberSize];
        System.arraycopy(joseSignature, this.ecNumberSize, sBytes, 0, this.ecNumberSize);
        if (this.isAllZeros(sBytes)) {
            throw new SignatureException("Invalid signature format.");
        }
        int rPadding = this.countPadding(joseSignature, 0, this.ecNumberSize);
        int rLength = this.ecNumberSize - rPadding;
        int length = 2 + rLength + 2 + (sLength = this.ecNumberSize - (sPadding = this.countPadding(joseSignature, this.ecNumberSize, joseSignature.length)));
        if (length > 255) {
            throw new SignatureException("Invalid JOSE signature format.");
        }
        BigInteger order = publicKey.getParams().getOrder();
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s2 = new BigInteger(1, sBytes);
        if (order.compareTo(r) < 1) {
            throw new SignatureException("Invalid signature format.");
        }
        if (order.compareTo(s2) < 1) {
            throw new SignatureException("Invalid signature format.");
        }
    }

    byte[] JOSEToDER(byte[] joseSignature) throws SignatureException {
        int offset;
        byte[] derSignature;
        int sPadding;
        int sLength;
        int rPadding = this.countPadding(joseSignature, 0, this.ecNumberSize);
        int rLength = this.ecNumberSize - rPadding;
        int length = 2 + rLength + 2 + (sLength = this.ecNumberSize - (sPadding = this.countPadding(joseSignature, this.ecNumberSize, joseSignature.length)));
        if (length > 127) {
            derSignature = new byte[3 + length];
            derSignature[1] = -127;
            offset = 2;
        } else {
            derSignature = new byte[2 + length];
            offset = 1;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)(length & 0xFF);
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)rLength;
        if (rPadding < 0) {
            derSignature[offset++] = 0;
            System.arraycopy(joseSignature, 0, derSignature, offset, this.ecNumberSize);
            offset += this.ecNumberSize;
        } else {
            int copyLength = Math.min(this.ecNumberSize, rLength);
            System.arraycopy(joseSignature, rPadding, derSignature, offset, copyLength);
            offset += copyLength;
        }
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)sLength;
        if (sPadding < 0) {
            derSignature[offset++] = 0;
            System.arraycopy(joseSignature, this.ecNumberSize, derSignature, offset, this.ecNumberSize);
        } else {
            System.arraycopy(joseSignature, this.ecNumberSize + sPadding, derSignature, offset, Math.min(this.ecNumberSize, sLength));
        }
        return derSignature;
    }

    private boolean isAllZeros(byte[] bytes) {
        for (byte b : bytes) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private int countPadding(byte[] bytes, int fromIndex, int toIndex) {
        int padding = 0;
        while (fromIndex + padding < toIndex && bytes[fromIndex + padding] == 0) {
            ++padding;
        }
        return (bytes[fromIndex + padding] & 0xFF) > 127 ? padding - 1 : padding;
    }

    static ECDSAKeyProvider providerForKeys(final ECPublicKey publicKey, final ECPrivateKey privateKey) {
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Both provided Keys cannot be null.");
        }
        return new ECDSAKeyProvider(){

            @Override
            public ECPublicKey getPublicKeyById(String keyId) {
                return publicKey;
            }

            @Override
            public ECPrivateKey getPrivateKey() {
                return privateKey;
            }

            @Override
            public String getPrivateKeyId() {
                return null;
            }
        };
    }
}

