/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMStateStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RMStateStoreFactory.class);

    public static RMStateStore getStore(Configuration conf) {
        Class storeClass = conf.getClass("yarn.resourcemanager.store.class", MemoryRMStateStore.class, RMStateStore.class);
        LOG.info("Using RMStateStore implementation - " + storeClass);
        return (RMStateStore)((Object)ReflectionUtils.newInstance((Class)storeClass, (Configuration)conf));
    }
}

