/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ConfigurationException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerExecContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerLivenessContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerPrepareContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReacquisitionContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReapContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.LocalizerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;
import org.apache.hadoop.yarn.util.DFSLoggingHandler;
import org.apache.hadoop.yarn.util.TaskLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerExecutor
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerExecutor.class);
    protected static final String WILDCARD = "*";
    public static final String TOKEN_FILE_NAME_FMT = "%s.tokens";
    public static final FsPermission TASK_LAUNCH_SCRIPT_PERMISSION = FsPermission.createImmutable((short)448);
    public static final String DIRECTORY_CONTENTS = "directory.info";
    private Configuration conf;
    private final ConcurrentMap<ContainerId, Path> pidFiles = new ConcurrentHashMap<ContainerId, Path>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private String[] whitelistVars;
    private int exitCodeFileTimeout = 2000;
    private int containerExitCode;

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (conf != null) {
            this.whitelistVars = conf.get("yarn.nodemanager.env-whitelist", YarnConfiguration.DEFAULT_NM_ENV_WHITELIST).split(",");
            this.exitCodeFileTimeout = conf.getInt("yarn.nodemanager.container-executor.exit-code-file.timeout-ms", 2000);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public abstract void init(Context var1) throws IOException;

    public void start() {
    }

    public void stop() {
    }

    public Path localizeClasspathJar(Path jarPath, Path target, String owner) throws IOException {
        return jarPath;
    }

    public abstract void startLocalizer(LocalizerStartContext var1) throws IOException, InterruptedException;

    public void prepareContainer(ContainerPrepareContext ctx) throws IOException {
    }

    public abstract int launchContainer(ContainerStartContext var1) throws IOException, ConfigurationException;

    public abstract int relaunchContainer(ContainerStartContext var1) throws IOException, ConfigurationException;

    public abstract boolean signalContainer(ContainerSignalContext var1) throws IOException;

    public abstract boolean reapContainer(ContainerReapContext var1) throws IOException;

    public abstract IOStreamPair execContainer(ContainerExecContext var1) throws ContainerExecutionException;

    public abstract void deleteAsUser(DeletionAsUserContext var1) throws IOException, InterruptedException;

    public abstract void symLink(String var1, String var2) throws IOException;

    public abstract boolean isContainerAlive(ContainerLivenessContext var1) throws IOException;

    public Map<String, LocalResource> getLocalResources(Container container) throws IOException {
        return container.getLaunchContext().getLocalResources();
    }

    public abstract void updateYarnSysFS(Context var1, String var2, String var3, String var4) throws IOException;

    public int reacquireContainer(ContainerReacquisitionContext ctx) throws IOException, InterruptedException {
        int msecLeft;
        Container container = ctx.getContainer();
        String user = ctx.getUser();
        ContainerId containerId = ctx.getContainerId();
        Path pidPath = this.getPidFilePath(containerId);
        if (pidPath == null) {
            LOG.warn("{} is not active, returning terminated error", (Object)containerId);
            this.containerExitCode = ExitCode.TERMINATED.getExitCode();
            return ExitCode.TERMINATED.getExitCode();
        }
        String pid = ProcessIdFileReader.getProcessId(pidPath);
        if (pid == null) {
            throw new IOException("Unable to determine pid for " + containerId);
        }
        LOG.info("Reacquiring {} with pid {}", (Object)containerId, (Object)pid);
        ContainerLivenessContext livenessContext = new ContainerLivenessContext.Builder().setContainer(container).setUser(user).setPid(pid).build();
        while (this.isContainerAlive(livenessContext)) {
            Thread.sleep(1000L);
        }
        int sleepMsec = 100;
        String exitCodeFile = ContainerLaunch.getExitCodeFile(pidPath.toString());
        File file = new File(exitCodeFile);
        for (msecLeft = this.exitCodeFileTimeout; !file.exists() && msecLeft >= 0; msecLeft -= 100) {
            if (!this.isContainerActive(containerId)) {
                LOG.info("{} was deactivated", (Object)containerId);
                this.containerExitCode = ExitCode.TERMINATED.getExitCode();
                return ExitCode.TERMINATED.getExitCode();
            }
            Thread.sleep(100L);
        }
        if (msecLeft < 0) {
            throw new IOException("Timeout while waiting for exit code from " + containerId);
        }
        try {
            this.containerExitCode = Integer.parseInt(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).trim());
            return this.containerExitCode;
        }
        catch (NumberFormatException e) {
            throw new IOException("Error parsing exit code from pid " + pid, e);
        }
    }

    public void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command, Path logDir, String user, LinkedHashSet<String> nmVars) throws IOException {
        this.writeLaunchEnv(out, environment, resources, command, logDir, user, ContainerLaunch.CONTAINER_SCRIPT, nmVars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    public void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command, Path logDir, String user, String outFilename, LinkedHashSet<String> nmVars) throws IOException {
        ContainerLaunch.ShellScriptBuilder sb = ContainerLaunch.ShellScriptBuilder.create();
        sb.setExitOnFailure();
        if (TaskLogUtil.isDfsLoggingEnabled() && environment.containsKey(ApplicationConstants.Environment.LD_LIBRARY_PATH.name())) {
            sb.env(ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), environment.get(ApplicationConstants.Environment.LD_LIBRARY_PATH.name()));
        }
        sb.stdout(logDir, "prelaunch.out");
        sb.stderr(logDir, "prelaunch.err");
        if (environment != null) {
            sb.echo("Setting up env variables");
            for (String var : this.whitelistVars) {
                String val;
                if (environment.containsKey(var) || (val = this.getNMEnvVar(var)) == null) continue;
                sb.whitelistedEnv(var, val);
            }
            for (String string : nmVars) {
                sb.env(string, environment.get(string));
            }
            for (Map.Entry entry : sb.orderEnvByDependencies(environment).entrySet()) {
                if (nmVars.contains(entry.getKey())) continue;
                sb.env((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (resources != null) {
            sb.echo("Setting up job resources");
            Map<Path, Path> symLinks = this.resolveSymLinks(resources, user);
            for (Map.Entry<Path, Path> symLink : symLinks.entrySet()) {
                sb.symlink(symLink.getKey(), symLink.getValue());
            }
        }
        if (this.shouldWriteDebugInformation(this.getConf())) {
            void var11_17;
            Path scriptPath;
            sb.echo("Copying debugging information");
            if (TaskLogUtil.isDfsLoggingEnabled()) {
                DFSLoggingHandler dfsLoggingHandler = TaskLogUtil.getDFSLoggingHandler();
                scriptPath = dfsLoggingHandler.getLogFileForWrite(logDir, outFilename);
                Path path = dfsLoggingHandler.getLogFileForWrite(logDir, DIRECTORY_CONTENTS);
            } else {
                scriptPath = new Path(logDir, outFilename);
                Path path = new Path(logDir, DIRECTORY_CONTENTS);
            }
            sb.copyDebugInformation(new Path(outFilename), scriptPath);
            sb.listDebugInformation((Path)var11_17);
        }
        sb.echo("Launching container");
        sb.command(command);
        PrintStream pout = null;
        try {
            pout = new PrintStream(out, false, "UTF-8");
            sb.write(pout);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected File[] readDirAsUser(String user, Path dir) {
        return new File(dir.toString()).listFiles();
    }

    private boolean shouldWriteDebugInformation(Configuration config) {
        return config != null && (config.getBoolean("yarn.nodemanager.log-container-debug-info.enabled", true) || config.getBoolean("yarn.nodemanager.log-container-debug-info-on-error.enabled", false) && this.containerExitCode != 0);
    }

    protected void logOutput(String output) {
        String shExecOutput = output;
        if (shExecOutput != null) {
            for (String str : shExecOutput.split("\n")) {
                LOG.info(str);
            }
        }
    }

    protected Path getPidFilePath(ContainerId containerId) {
        return (Path)this.pidFiles.get(containerId);
    }

    protected String[] getRunCommand(String command, String groupId, String userName, Path pidFile, Configuration config) {
        return this.getRunCommand(command, groupId, userName, pidFile, config, null);
    }

    protected String[] getRunCommand(String command, String groupId, String userName, Path pidFile, Configuration config, Resource resource) {
        if (Shell.WINDOWS) {
            return this.getRunCommandForWindows(command, groupId, userName, pidFile, config, resource);
        }
        return this.getRunCommandForOther(command, config);
    }

    protected String[] getRunCommandForWindows(String command, String groupId, String userName, Path pidFile, Configuration config, Resource resource) {
        int cpuRate = -1;
        int memory = -1;
        if (resource != null) {
            if (config.getBoolean("yarn.nodemanager.windows-container.memory-limit.enabled", false)) {
                memory = (int)resource.getMemorySize();
            }
            if (config.getBoolean("yarn.nodemanager.windows-container.cpu-limit.enabled", false)) {
                int containerVCores = resource.getVirtualCores();
                int nodeVCores = NodeManagerHardwareUtils.getVCores(config);
                int nodeCpuPercentage = NodeManagerHardwareUtils.getNodeCpuPercentage(config);
                float containerCpuPercentage = (float)(nodeCpuPercentage * containerVCores) / (float)nodeVCores;
                cpuRate = Math.min(10000, (int)(containerCpuPercentage * 100.0f));
            }
        }
        return new String[]{Shell.getWinUtilsPath(), "task", "create", "-m", String.valueOf(memory), "-c", String.valueOf(cpuRate), groupId, "cmd /c " + command};
    }

    protected String[] getRunCommandForOther(String command, Configuration config) {
        ArrayList<String> retCommand = new ArrayList<String>();
        boolean containerSchedPriorityIsSet = false;
        int containerSchedPriorityAdjustment = 0;
        if (config.get("yarn.nodemanager.container-executor.os.sched.priority.adjustment") != null) {
            containerSchedPriorityIsSet = true;
            containerSchedPriorityAdjustment = config.getInt("yarn.nodemanager.container-executor.os.sched.priority.adjustment", 0);
        }
        if (containerSchedPriorityIsSet) {
            retCommand.addAll(Arrays.asList("nice", "-n", Integer.toString(containerSchedPriorityAdjustment)));
        }
        retCommand.addAll(Arrays.asList("bash", command));
        return retCommand.toArray(new String[retCommand.size()]);
    }

    protected boolean isContainerActive(ContainerId containerId) {
        return this.pidFiles.containsKey(containerId);
    }

    @VisibleForTesting
    protected String getNMEnvVar(String varname) {
        return System.getenv(varname);
    }

    public void activateContainer(ContainerId containerId, Path pidFilePath) {
        this.pidFiles.put(containerId, pidFilePath);
    }

    public String[] getIpAndHost(Container container) throws ContainerExecutionException {
        return ContainerExecutor.getLocalIpAndHost(container);
    }

    public static String[] getLocalIpAndHost(Container container) {
        String[] ipAndHost = new String[2];
        try {
            InetAddress address = InetAddress.getLocalHost();
            ipAndHost[0] = address.getHostAddress();
            ipAndHost[1] = address.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to get Local hostname and ip for {}", (Object)container.getContainerId(), (Object)e);
        }
        return ipAndHost;
    }

    public void deactivateContainer(ContainerId containerId) {
        this.pidFiles.remove(containerId);
    }

    public void pauseContainer(Container container) {
        LOG.warn("{} doesn't support pausing.", (Object)container.getContainerId());
        throw new UnsupportedOperationException();
    }

    public void resumeContainer(Container container) {
        LOG.warn("{} doesn't support resume.", (Object)container.getContainerId());
        throw new UnsupportedOperationException();
    }

    public void cleanupBeforeRelaunch(Container container) throws IOException, InterruptedException {
        if (container.getLocalizedResources() != null) {
            Map<Path, Path> symLinks = this.resolveSymLinks(container.getLocalizedResources(), container.getUser());
            for (Map.Entry<Path, Path> symLink : symLinks.entrySet()) {
                LOG.debug("{} deleting {}", (Object)container.getContainerId(), (Object)symLink.getValue());
                this.deleteAsUser(new DeletionAsUserContext.Builder().setUser(container.getUser()).setSubDir(symLink.getValue()).build());
            }
        }
    }

    public String getProcessId(ContainerId containerID) {
        String pid = null;
        Path pidFile = (Path)this.pidFiles.get(containerID);
        if (pidFile != null) {
            try {
                pid = ProcessIdFileReader.getProcessId(pidFile);
            }
            catch (IOException e) {
                LOG.error("Got exception reading pid from pid-file {}", (Object)pidFile, (Object)e);
            }
        }
        return pid;
    }

    private Map<Path, Path> resolveSymLinks(Map<Path, List<String>> resources, String user) {
        HashMap<Path, Path> symLinks = new HashMap<Path, Path>();
        for (Map.Entry<Path, List<String>> resourceEntry : resources.entrySet()) {
            for (String linkName : resourceEntry.getValue()) {
                if (new Path(linkName).getName().equals(WILDCARD)) {
                    for (File wildLink : this.readDirAsUser(user, resourceEntry.getKey())) {
                        symLinks.put(new Path(wildLink.toString()), new Path(wildLink.getName()));
                    }
                    continue;
                }
                symLinks.put(resourceEntry.getKey(), new Path(linkName));
            }
        }
        return symLinks;
    }

    public String getExposedPorts(Container container) throws ContainerExecutionException {
        return null;
    }

    public static class DelayedProcessKiller
    extends Thread {
        private final Container container;
        private final String user;
        private final String pid;
        private final long delay;
        private final Signal signal;
        private final ContainerExecutor containerExecutor;

        public DelayedProcessKiller(Container container, String user, String pid, long delayMS, Signal signal, ContainerExecutor containerExecutor) {
            this.container = container;
            this.user = user;
            this.pid = pid;
            this.delay = delayMS;
            this.signal = signal;
            this.containerExecutor = containerExecutor;
            this.setName("Task killer for " + pid);
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                this.containerExecutor.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(this.user).setPid(this.pid).setSignal(this.signal).build());
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
            catch (IOException e) {
                String message = "Exception when user " + this.user + " killing task " + this.pid + " in DelayedProcessKiller: " + StringUtils.stringifyException((Throwable)e);
                LOG.warn(message);
                this.container.handle((Event)new ContainerDiagnosticsUpdateEvent(this.container.getContainerId(), message));
            }
        }
    }

    public static enum Signal {
        NULL(0, "NULL"),
        QUIT(3, "SIGQUIT"),
        KILL(9, "SIGKILL"),
        TERM(15, "SIGTERM");

        private final int value;
        private final String str;

        private Signal(int value, String str) {
            this.str = str;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum ExitCode {
        SUCCESS(0),
        FORCE_KILLED(137),
        TERMINATED(143),
        LOST(154);

        private final int code;

        private ExitCode(int exitCode) {
            this.code = exitCode;
        }

        public int getExitCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }
}

