/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMappingWithOneQuery
extends TestLdapGroupsMappingBase {
    public void setupMocks(List<String> listOfDNs) throws NamingException {
        Attribute groupDN = (Attribute)Mockito.mock(Attribute.class);
        NamingEnumeration<SearchResult> groupNames = this.getGroupNames();
        ((Attribute)Mockito.doReturn(groupNames).when((Object)groupDN)).getAll();
        ((NamingEnumeration)this.buildListOfGroupDNs(listOfDNs).when(groupNames)).next();
        Mockito.when((Object)groupNames.hasMore()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)this.getAttributes().get((String)ArgumentMatchers.eq((Object)"memberOf"))).thenReturn((Object)groupDN);
    }

    private Stubber buildListOfGroupDNs(List<String> listOfDNs) {
        Stubber stubber = null;
        for (String s : listOfDNs) {
            if (stubber != null) {
                stubber.doReturn((Object)s);
                continue;
            }
            stubber = Mockito.doReturn((Object)s);
        }
        return stubber;
    }

    @Test
    public void testGetGroups() throws NamingException {
        String[] testGroups = new String[]{"abc", "xyz", "sss"};
        this.doTestGetGroups(Arrays.asList(testGroups));
        this.doTestGetGroupsWithFallback();
    }

    private void doTestGetGroups(List<String> expectedGroups) throws NamingException {
        ArrayList<String> groupDns = new ArrayList<String>();
        groupDns.add("CN=abc,DC=foo,DC=bar,DC=com");
        groupDns.add("CN=xyz,DC=foo,DC=bar,DC=com");
        groupDns.add("CN=sss,DC=foo,DC=bar,DC=com");
        this.setupMocks(groupDns);
        String ldapUrl = "ldap://test";
        Configuration conf = this.getBaseConf(ldapUrl);
        conf.set("hadoop.security.group.mapping.ldap.search.attr.memberof", "memberOf");
        TestLdapGroupsMapping groupsMapping = new TestLdapGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        Assert.assertFalse((String)"Second LDAP query should NOT have been called.", (boolean)groupsMapping.isSecondaryQueryCalled());
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)1))).search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class));
    }

    private void doTestGetGroupsWithFallback() throws NamingException {
        ArrayList<String> groupDns = new ArrayList<String>();
        groupDns.add("CN=abc,DC=foo,DC=bar,DC=com");
        groupDns.add("CN=xyz,DC=foo,DC=bar,DC=com");
        groupDns.add("ipaUniqueID=e4a9a634-bb24-11ec-aec1-06ede52b5fe1,CN=sudo,DC=foo,DC=bar,DC=com");
        this.setupMocks(groupDns);
        String ldapUrl = "ldap://test";
        Configuration conf = this.getBaseConf(ldapUrl);
        conf.set("hadoop.security.group.mapping.ldap.search.attr.memberof", "memberOf");
        conf.set("hadoop.security.group.mapping.ldap.num.attempts", "1");
        TestLdapGroupsMapping groupsMapping = new TestLdapGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals((long)0L, (long)groups.size());
        Assert.assertTrue((String)"Second LDAP query should have been called.", (boolean)groupsMapping.isSecondaryQueryCalled());
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)3))).search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class));
    }

    private static final class TestLdapGroupsMapping
    extends LdapGroupsMapping {
        private boolean secondaryQueryCalled = false;

        private TestLdapGroupsMapping() {
        }

        public boolean isSecondaryQueryCalled() {
            return this.secondaryQueryCalled;
        }

        Set<String> lookupGroup(SearchResult result, DirContext c, int goUpHierarchy) throws NamingException {
            this.secondaryQueryCalled = true;
            return super.lookupGroup(result, c, goUpHierarchy);
        }
    }
}

