/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;

public class JobHistoryUtils {
    private static String applyParser(String fileName, Pattern pattern) {
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    static String extractJobID(String fileName) {
        String jobId = JobHistoryUtils.extractJobIDFromConfFileName(fileName);
        if (jobId == null) {
            jobId = JobHistoryUtils.extractJobIDFromHistoryFileName(fileName);
        }
        return jobId;
    }

    private static String extractJobIDFromCurrentHistoryFile(String fileName) {
        JobID id = null;
        if (org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils.isValidJobHistoryFileName((String)fileName)) {
            try {
                id = org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils.getJobIDFromHistoryFilePath((String)fileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    private static String extractJobIDFromHistoryFileName(String fileName) {
        String jobID = JobHistoryUtils.extractJobIDFromCurrentHistoryFile(fileName);
        if (jobID != null) {
            return jobID;
        }
        String pre21JobID = JobHistoryUtils.applyParser(fileName, Pre21JobHistoryConstants.JOBHISTORY_FILENAME_REGEX_V1);
        if (pre21JobID == null) {
            pre21JobID = JobHistoryUtils.applyParser(fileName, Pre21JobHistoryConstants.JOBHISTORY_FILENAME_REGEX_V2);
        }
        return pre21JobID;
    }

    private static String extractJobIDFromConfFileName(String fileName) {
        String pre21JobID = JobHistoryUtils.applyParser(fileName, Pre21JobHistoryConstants.CONF_FILENAME_REGEX_V1);
        if (pre21JobID == null) {
            pre21JobID = JobHistoryUtils.applyParser(fileName, Pre21JobHistoryConstants.CONF_FILENAME_REGEX_V2);
        }
        if (pre21JobID != null) {
            return pre21JobID;
        }
        return JobHistoryUtils.applyParser(fileName, JobHistory.CONF_FILENAME_REGEX);
    }

    static boolean isJobConfXml(String fileName) {
        String jobId = JobHistoryUtils.extractJobIDFromConfFileName(fileName);
        return jobId != null;
    }

    static Map<String, Long> extractCounters(JhCounters counters) {
        HashMap<String, Long> countersMap = new HashMap<String, Long>();
        if (counters != null) {
            for (JhCounterGroup group : counters.getGroups()) {
                for (JhCounter counter : group.getCounts()) {
                    countersMap.put(counter.getName().toString(), counter.getValue());
                }
            }
        }
        return countersMap;
    }
}

