/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.solver.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.solver.exceptions.InvalidInputException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolverPreprocessor.class);

    public final void validate(Map<RecurrenceId, List<ResourceSkyline>> jobHistory, int timeInterval) throws InvalidInputException {
        if (jobHistory == null || jobHistory.size() == 0) {
            LOGGER.error("Job resource skyline history is invalid, please try again with valid resource skyline history.");
            throw new InvalidInputException("Job ResourceSkyline history", "invalid");
        }
        if (timeInterval <= 0) {
            LOGGER.error("Solver timeInterval {} is invalid, please specify a positive value.", (Object)timeInterval);
            throw new InvalidInputException("Solver timeInterval", "non-positive");
        }
    }

    public final long getResourceVector(RLESparseResourceAllocation skyList, int index, long containerMemAlloc) {
        return skyList.getCapacityAtTime((long)index).getMemorySize() / containerMemAlloc;
    }

    public final int[] getDiscreteSkyline(RLESparseResourceAllocation skyList, int timeInterval, long containerMemAlloc, int jobLen) {
        long jobLifeSpan = skyList.getLatestNonNullTime() - skyList.getEarliestStartTime();
        int[] result = new int[jobLen];
        Arrays.fill(result, 0);
        int index = 0;
        long numContainerAt = 0L;
        int i = 0;
        while ((long)i < jobLifeSpan) {
            index = (int)Math.floor((double)i / (double)timeInterval);
            if ((long)result[index] < (numContainerAt = this.getResourceVector(skyList, i, containerMemAlloc))) {
                result[index] = (int)numContainerAt;
            }
            ++i;
        }
        return result;
    }

    public final ResourceSkyline mergeSkyline(List<ResourceSkyline> resourceSkylines) {
        long pipelineSubmission = Long.MAX_VALUE;
        for (int i = 0; i < resourceSkylines.size(); ++i) {
            long jobSubmission = resourceSkylines.get(i).getJobSubmissionTime();
            if (pipelineSubmission <= jobSubmission) continue;
            pipelineSubmission = jobSubmission;
        }
        TreeMap resourceOverTime = new TreeMap();
        RLESparseResourceAllocation skylineListAgg = new RLESparseResourceAllocation(resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        for (int i = 0; i < resourceSkylines.size(); ++i) {
            long jobSubmission = resourceSkylines.get(i).getJobSubmissionTime();
            long diff = (jobSubmission - pipelineSubmission) / 1000L;
            RLESparseResourceAllocation tmp = resourceSkylines.get(i).getSkylineList();
            Object[] timePoints = tmp.getCumulative().keySet().toArray();
            for (int j = 0; j < timePoints.length - 2; ++j) {
                ReservationInterval riAdd = new ReservationInterval((long)Math.toIntExact((Long)timePoints[j]) + diff, (long)Math.toIntExact((Long)timePoints[j + 1] + diff));
                skylineListAgg.addInterval(riAdd, tmp.getCapacityAtTime((long)Math.toIntExact((Long)timePoints[j])));
            }
        }
        ResourceSkyline skylineAgg = new ResourceSkyline(resourceSkylines.get(0).getJobId(), resourceSkylines.get(0).getJobInputDataSize(), resourceSkylines.get(0).getJobSubmissionTime(), resourceSkylines.get(0).getJobFinishTime(), resourceSkylines.get(0).getContainerSpec(), skylineListAgg);
        return skylineAgg;
    }

    public final List<ResourceSkyline> aggregateSkylines(Map<RecurrenceId, List<ResourceSkyline>> jobHistory, int minJobRuns) throws InvalidInputException {
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        for (Map.Entry<RecurrenceId, List<ResourceSkyline>> entry : jobHistory.entrySet()) {
            ResourceSkyline skylineAgg = null;
            skylineAgg = this.mergeSkyline(entry.getValue());
            resourceSkylines.add(skylineAgg);
        }
        int numJobs = resourceSkylines.size();
        if (numJobs < minJobRuns) {
            LOGGER.error("Solver requires job resource skyline history for at least {} runs, but it only receives history info for {}  runs.", (Object)minJobRuns, (Object)numJobs);
            throw new InvalidInputException("Job ResourceSkyline history", "containing less job runs than " + minJobRuns);
        }
        return resourceSkylines;
    }
}

