/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.lib.join.ResetableIterator;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ArrayListBackedIterator<X extends Writable>
implements ResetableIterator<X> {
    private Iterator<X> iter;
    private ArrayList<X> data;
    private X hold = null;
    private Configuration conf = new Configuration();

    public ArrayListBackedIterator() {
        this(new ArrayList());
    }

    public ArrayListBackedIterator(ArrayList<X> data) {
        this.data = data;
        this.iter = this.data.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public boolean next(X val) throws IOException {
        if (this.iter.hasNext()) {
            ReflectionUtils.copy((Configuration)this.conf, (Object)((Writable)this.iter.next()), val);
            if (null == this.hold) {
                this.hold = WritableUtils.clone(val, null);
            } else {
                ReflectionUtils.copy((Configuration)this.conf, val, this.hold);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean replay(X val) throws IOException {
        ReflectionUtils.copy((Configuration)this.conf, this.hold, val);
        return true;
    }

    @Override
    public void reset() {
        this.iter = this.data.iterator();
    }

    @Override
    public void add(X item) throws IOException {
        this.data.add(WritableUtils.clone(item, null));
    }

    @Override
    public void close() throws IOException {
        this.iter = null;
        this.data = null;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.reset();
    }
}

