/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdfs.federation.protocol.proto.HdfsServerFederationProtos;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.util.ProtoUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestRouterFederatedState {
    @Test
    public void testRpcRouterFederatedState() throws InvalidProtocolBufferException {
        byte[] uuid = ClientId.getClientId();
        HashMap<String, Long> expectedStateIds = new HashMap<String, Long>(){
            {
                this.put("namespace1", 11L);
                this.put("namespace2", 22L);
            }
        };
        AlignmentContextWithRouterState alignmentContext = new AlignmentContextWithRouterState((Map<String, Long>)expectedStateIds);
        RpcHeaderProtos.RpcRequestHeaderProto header = ProtoUtil.makeRpcRequestHeader((RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (RpcHeaderProtos.RpcRequestHeaderProto.OperationProto)RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, (int)0, (int)-1, (byte[])uuid, (AlignmentContext)alignmentContext);
        Map stateIdsFromHeader = HdfsServerFederationProtos.RouterFederatedStateProto.parseFrom((byte[])header.getRouterFederatedState().toByteArray()).getNamespaceStateIdsMap();
        Assert.assertEquals((Object)expectedStateIds, (Object)stateIdsFromHeader);
    }

    private static class AlignmentContextWithRouterState
    implements AlignmentContext {
        Map<String, Long> routerFederatedState;

        public AlignmentContextWithRouterState(Map<String, Long> namespaceStates) {
            this.routerFederatedState = namespaceStates;
        }

        public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
            HdfsServerFederationProtos.RouterFederatedStateProto fedState = HdfsServerFederationProtos.RouterFederatedStateProto.newBuilder().putAllNamespaceStateIds(this.routerFederatedState).build();
            header.setRouterFederatedState(fedState.toByteString());
        }

        public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
        }

        public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        }

        public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
            return 0L;
        }

        public long getLastSeenStateId() {
            return 0L;
        }

        public boolean isCoordinatedCall(String protocolName, String method) {
            return false;
        }
    }
}

