/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.TaskLogUtil;

public abstract class DFSLoggingHandler {
    public abstract String getStdOutCommand(String var1);

    public abstract String getStdErrCommand(String var1);

    public Path getLogDirForWrite(String relativeContainerLogDir) throws IOException {
        return new Path(TaskLogUtil.getPropertyValue("yarn.nodemanager.log-dirs"), relativeContainerLogDir);
    }

    public Path[] getLogDir(ApplicationId applicationId) throws IOException {
        return new Path[]{this.getLogDirForWrite(applicationId.toString())};
    }

    public Path getLogDir(ContainerId containerId) throws IOException {
        String dir = containerId.getApplicationAttemptId().getApplicationId().toString() + "/" + containerId.toString();
        return this.getLogDirForWrite(dir);
    }

    public Path getLogFileForWrite(Path stdOutDir, String stdOutFile) {
        return new Path(stdOutDir, stdOutFile);
    }
}

