/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.thirdparty.com.google.common.collect.HashMultiset;
import org.apache.hadoop.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CombineFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CombineFileInputFormat.class);
    public static final String SPLIT_MINSIZE_PERNODE = "mapreduce.input.fileinputformat.split.minsize.per.node";
    public static final String SPLIT_MINSIZE_PERRACK = "mapreduce.input.fileinputformat.split.minsize.per.rack";
    private long maxSplitSize = 0L;
    private long minSplitSizeNode = 0L;
    private long minSplitSizeRack = 0L;
    private int maxSplitBlocksNum = 0;
    private ArrayList<MultiPathFilter> pools = new ArrayList();
    private HashMap<String, Set<String>> rackToNodes = new HashMap();

    protected void setMaxBlocksNum(int maxSplitBlocksNum) {
        this.maxSplitBlocksNum = maxSplitBlocksNum;
    }

    protected void setMaxSplitSize(long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    protected void setMinSplitSizeNode(long minSplitSizeNode) {
        this.minSplitSizeNode = minSplitSizeNode;
    }

    protected void setMinSplitSizeRack(long minSplitSizeRack) {
        this.minSplitSizeRack = minSplitSizeRack;
    }

    protected void createPool(List<PathFilter> filters) {
        this.pools.add(new MultiPathFilter(filters));
    }

    protected void createPool(PathFilter ... filters) {
        MultiPathFilter multi = new MultiPathFilter();
        for (PathFilter f : filters) {
            multi.add(f);
        }
        this.pools.add(multi);
    }

    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long minSizeNode = 0L;
        long minSizeRack = 0L;
        long maxSize = 0L;
        int maxBlocksNum = 0;
        Configuration conf = job.getConfiguration();
        minSizeNode = this.minSplitSizeNode != 0L ? this.minSplitSizeNode : conf.getLong(SPLIT_MINSIZE_PERNODE, 0L);
        minSizeRack = this.minSplitSizeRack != 0L ? this.minSplitSizeRack : conf.getLong(SPLIT_MINSIZE_PERRACK, 0L);
        maxBlocksNum = this.maxSplitBlocksNum != 0 ? this.maxSplitBlocksNum : conf.getInt("mapreduce.input.fileinputformat.split.maxblocknum", 0);
        maxSize = this.maxSplitSize != 0L ? this.maxSplitSize : conf.getLong("mapreduce.input.fileinputformat.split.maxsize", 0L);
        if (minSizeNode != 0L && maxSize != 0L && minSizeNode > maxSize) {
            throw new IOException("Minimum split size pernode " + minSizeNode + " cannot be larger than maximum split size " + maxSize);
        }
        if (minSizeRack != 0L && maxSize != 0L && minSizeRack > maxSize) {
            throw new IOException("Minimum split size per rack " + minSizeRack + " cannot be larger than maximum split size " + maxSize);
        }
        if (minSizeRack != 0L && minSizeNode > minSizeRack) {
            throw new IOException("Minimum split size per node " + minSizeNode + " cannot be larger than minimum split size per rack " + minSizeRack);
        }
        List<FileStatus> stats = this.listStatus(job);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (stats.size() == 0) {
            return splits;
        }
        for (MultiPathFilter onepool : this.pools) {
            ArrayList<FileStatus> myPaths = new ArrayList<FileStatus>();
            Iterator<FileStatus> iter = stats.iterator();
            while (iter.hasNext()) {
                FileStatus p = iter.next();
                if (!onepool.accept(p.getPath())) continue;
                myPaths.add(p);
                iter.remove();
            }
            this.getMoreSplits(job, myPaths, maxBlocksNum, maxSize, minSizeNode, minSizeRack, splits);
        }
        this.getMoreSplits(job, stats, maxBlocksNum, maxSize, minSizeNode, minSizeRack, splits);
        this.rackToNodes.clear();
        return splits;
    }

    private void getMoreSplits(JobContext job, List<FileStatus> stats, int maxBlocksNum, long maxSize, long minSizeNode, long minSizeRack, List<InputSplit> splits) throws IOException {
        Configuration conf = job.getConfiguration();
        HashMap<String, List<OneBlockInfo>> rackToBlocks = new HashMap<String, List<OneBlockInfo>>();
        HashMap<OneBlockInfo, String[]> blockToNodes = new HashMap<OneBlockInfo, String[]>();
        HashMap<String, Set<OneBlockInfo>> nodeToBlocks = new HashMap<String, Set<OneBlockInfo>>();
        OneFileInfo[] files = new OneFileInfo[stats.size()];
        if (stats.size() == 0) {
            return;
        }
        long totLength = 0L;
        int i = 0;
        for (FileStatus stat : stats) {
            files[i] = new OneFileInfo(stat, conf, this.isSplitable(job, stat.getPath()), rackToBlocks, blockToNodes, nodeToBlocks, this.rackToNodes, maxSize);
            totLength += files[i].getLength();
        }
        this.createSplits(nodeToBlocks, blockToNodes, rackToBlocks, totLength, maxBlocksNum, maxSize, minSizeNode, minSizeRack, splits, conf);
    }

    @VisibleForTesting
    void createSplits(Map<String, Set<OneBlockInfo>> nodeToBlocks, Map<OneBlockInfo, String[]> blockToNodes, Map<String, List<OneBlockInfo>> rackToBlocks, long totLength, int maxBlocksNum, long maxSize, long minSizeNode, long minSizeRack, List<InputSplit> splits, Configuration conf) {
        ArrayList<OneBlockInfo> validBlocks = new ArrayList<OneBlockInfo>();
        long curSplitSize = 0L;
        int curBlockNum = 0;
        int totalNodes = nodeToBlocks.size();
        long totalLength = totLength;
        HashMultiset splitsPerNode = HashMultiset.create();
        HashSet<String> completedNodes = new HashSet<String>();
        do {
            for (Map.Entry<String, Set<OneBlockInfo>> one : nodeToBlocks.entrySet()) {
                String node = one.getKey();
                if (completedNodes.contains(node)) continue;
                Set<OneBlockInfo> blocksInCurrentNode = one.getValue();
                Iterator<OneBlockInfo> oneBlockIter = blocksInCurrentNode.iterator();
                while (oneBlockIter.hasNext()) {
                    OneBlockInfo oneblock = oneBlockIter.next();
                    if (!blockToNodes.containsKey(oneblock)) {
                        oneBlockIter.remove();
                        continue;
                    }
                    validBlocks.add(oneblock);
                    blockToNodes.remove(oneblock);
                    if ((maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) && (maxBlocksNum == 0 || ++curBlockNum < maxBlocksNum)) continue;
                    this.addCreatedSplit(splits, Collections.singleton(node), validBlocks, conf);
                    totalLength -= curSplitSize;
                    curSplitSize = 0L;
                    curBlockNum = 0;
                    splitsPerNode.add((Object)node);
                    blocksInCurrentNode.removeAll(validBlocks);
                    validBlocks.clear();
                    break;
                }
                if (validBlocks.size() != 0) {
                    if (minSizeNode != 0L && curSplitSize >= minSizeNode && splitsPerNode.count((Object)node) == 0) {
                        this.addCreatedSplit(splits, Collections.singleton(node), validBlocks, conf);
                        totalLength -= curSplitSize;
                        splitsPerNode.add((Object)node);
                        blocksInCurrentNode.removeAll(validBlocks);
                    } else {
                        for (OneBlockInfo oneblock : validBlocks) {
                            blockToNodes.put(oneblock, oneblock.hosts);
                        }
                    }
                    validBlocks.clear();
                    curSplitSize = 0L;
                    curBlockNum = 0;
                    completedNodes.add(node);
                    continue;
                }
                if (blocksInCurrentNode.size() != 0) continue;
                completedNodes.add(node);
            }
        } while (completedNodes.size() != totalNodes && totalLength != 0L);
        LOG.debug("Terminated node allocation with : CompletedNodes: {}, size left: {}", (Object)completedNodes.size(), (Object)totalLength);
        ArrayList<OneBlockInfo> overflowBlocks = new ArrayList<OneBlockInfo>();
        HashSet<String> racks = new HashSet<String>();
        while (blockToNodes.size() > 0) {
            for (Map.Entry<String, List<OneBlockInfo>> one : rackToBlocks.entrySet()) {
                racks.add(one.getKey());
                List<OneBlockInfo> blocks = one.getValue();
                boolean createdSplit = false;
                for (OneBlockInfo oneblock : blocks) {
                    if (!blockToNodes.containsKey(oneblock)) continue;
                    validBlocks.add(oneblock);
                    blockToNodes.remove(oneblock);
                    if ((maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) && (maxBlocksNum == 0 || ++curBlockNum < maxBlocksNum)) continue;
                    this.addCreatedSplit(splits, this.getHosts(racks), validBlocks, conf);
                    createdSplit = true;
                    break;
                }
                if (createdSplit) {
                    curSplitSize = 0L;
                    curBlockNum = 0;
                    validBlocks.clear();
                    racks.clear();
                    continue;
                }
                if (!validBlocks.isEmpty()) {
                    if (minSizeRack != 0L && curSplitSize >= minSizeRack) {
                        this.addCreatedSplit(splits, this.getHosts(racks), validBlocks, conf);
                    } else {
                        overflowBlocks.addAll(validBlocks);
                    }
                }
                curBlockNum = 0;
                curSplitSize = 0L;
                validBlocks.clear();
                racks.clear();
            }
        }
        assert (blockToNodes.isEmpty());
        assert (curSplitSize == 0L);
        assert (validBlocks.isEmpty());
        assert (racks.isEmpty());
        for (OneBlockInfo oneblock : overflowBlocks) {
            validBlocks.add(oneblock);
            curSplitSize += oneblock.length;
            ++curBlockNum;
            for (int i = 0; i < oneblock.racks.length; ++i) {
                racks.add(oneblock.racks[i]);
            }
            if ((maxSize == 0L || curSplitSize < maxSize) && (maxBlocksNum == 0 || curBlockNum < maxBlocksNum)) continue;
            this.addCreatedSplit(splits, this.getHosts(racks), validBlocks, conf);
            curSplitSize = 0L;
            curBlockNum = 0;
            validBlocks.clear();
            racks.clear();
        }
        if (!validBlocks.isEmpty()) {
            this.addCreatedSplit(splits, this.getHosts(racks), validBlocks, conf);
        }
    }

    private void addCreatedSplit(List<InputSplit> splitList, Collection<String> locations, ArrayList<OneBlockInfo> validBlocks, Configuration conf) {
        CombineFileSplit thissplit;
        HashMap<String, HostCounter> hostCounterMap = new HashMap<String, HostCounter>();
        Path[] fl = new Path[validBlocks.size()];
        long[] offset = new long[validBlocks.size()];
        long[] length = new long[validBlocks.size()];
        for (int i = 0; i < validBlocks.size(); ++i) {
            OneBlockInfo oneblock = validBlocks.get(i);
            fl[i] = oneblock.onepath;
            offset[i] = oneblock.offset;
            length[i] = oneblock.length;
            for (String host : oneblock.hosts) {
                HostCounter hostCounter = (HostCounter)hostCounterMap.get(host);
                if (hostCounter == null) {
                    hostCounter = new HostCounter(host);
                    hostCounterMap.put(host, hostCounter);
                }
                hostCounter.val += oneblock.length;
            }
        }
        boolean isMultiSplitLocationsEnabled = conf.getBoolean("mapreduce.multi.split.locations.enabled", true);
        if (isMultiSplitLocationsEnabled) {
            String[] topKArray;
            Set hostKeySet;
            int hostKeySetSize;
            int k = conf.getInt("mapreduce.multi.split.locations", 3);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Determine top-" + k + " bytes locations for split");
            }
            if (k < (hostKeySetSize = (hostKeySet = hostCounterMap.keySet()).size())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("k=" + k + " < keySetSize" + hostKeySetSize + ": use PriorityQueue for top-k");
                }
                TopLocations topKHosts = new TopLocations(k);
                Iterator it = hostCounterMap.values().iterator();
                while (it.hasNext()) {
                    topKHosts.insert((HostCounter)it.next());
                    it.remove();
                }
                topKArray = new String[k];
                for (int i = topKArray.length - 1; i >= 0; --i) {
                    HostCounter hc = (HostCounter)topKHosts.pop();
                    topKArray[i] = hc.host;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("PQ.pop top location: " + hc);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("k=" + k + " >= keySetSize=" + hostKeySetSize + ": using all locations");
                    for (HostCounter hc : hostCounterMap.values()) {
                        LOG.debug("Location: " + hc);
                    }
                }
                topKArray = new String[hostCounterMap.size()];
                hostKeySet.toArray(topKArray);
            }
            thissplit = new CombineFileSplit(fl, offset, length, topKArray);
        } else {
            thissplit = new CombineFileSplit(fl, offset, length, locations.toArray(new String[0]));
        }
        splitList.add(thissplit);
    }

    @Override
    public abstract RecordReader<K, V> createRecordReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    protected BlockLocation[] getFileBlockLocations(FileSystem fs, FileStatus stat) throws IOException {
        if (stat instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)stat).getBlockLocations();
        }
        return fs.getFileBlockLocations(stat, 0L, stat.getLen());
    }

    private static void addHostToRack(Map<String, Set<String>> rackToNodes, String rack, String host) {
        Set<String> hosts = rackToNodes.get(rack);
        if (hosts == null) {
            hosts = new HashSet<String>();
            rackToNodes.put(rack, hosts);
        }
        hosts.add(host);
    }

    private Set<String> getHosts(Set<String> racks) {
        HashSet<String> hosts = new HashSet<String>();
        for (String rack : racks) {
            if (!this.rackToNodes.containsKey(rack)) continue;
            hosts.addAll((Collection<String>)this.rackToNodes.get(rack));
        }
        return hosts;
    }

    private final class TopLocations
    extends PriorityQueue<HostCounter> {
        private TopLocations(int max) {
            this.initialize(max);
        }

        @Override
        protected boolean lessThan(Object a, Object b) {
            HostCounter ahc = (HostCounter)a;
            HostCounter bhc = (HostCounter)b;
            return ahc.val - bhc.val < 0L;
        }
    }

    private final class HostCounter {
        final String host;
        long val;

        private HostCounter(String host) {
            this.host = host;
        }

        public String toString() {
            return "HostCounter [ " + this.host + ", " + this.val + " ]";
        }
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter() {
            this.filters = new ArrayList<PathFilter>();
        }

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public void add(PathFilter one) {
            this.filters.add(one);
        }

        @Override
        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (!filter.accept(path)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            for (PathFilter f : this.filters) {
                buf.append(f);
                buf.append(",");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    @VisibleForTesting
    static class OneBlockInfo {
        Path onepath;
        long offset;
        long length;
        String[] hosts;
        String[] racks;

        OneBlockInfo(Path path, long offset, long len, String[] hosts, String[] topologyPaths) {
            int i;
            this.onepath = path;
            this.offset = offset;
            this.hosts = hosts;
            this.length = len;
            assert (hosts.length == topologyPaths.length || topologyPaths.length == 0);
            if (topologyPaths.length == 0) {
                topologyPaths = new String[hosts.length];
                for (i = 0; i < topologyPaths.length; ++i) {
                    topologyPaths[i] = new NodeBase(hosts[i], "/default-rack").toString();
                }
            }
            this.racks = new String[topologyPaths.length];
            for (i = 0; i < topologyPaths.length; ++i) {
                this.racks[i] = new NodeBase(topologyPaths[i]).getNetworkLocation();
            }
        }
    }

    @VisibleForTesting
    static class OneFileInfo {
        private long fileSize = 0L;
        private OneBlockInfo[] blocks;

        OneFileInfo(FileStatus stat, Configuration conf, boolean isSplitable, HashMap<String, List<OneBlockInfo>> rackToBlocks, HashMap<OneBlockInfo, String[]> blockToNodes, HashMap<String, Set<OneBlockInfo>> nodeToBlocks, HashMap<String, Set<String>> rackToNodes, long maxSize) throws IOException {
            BlockLocation[] locations;
            if (stat instanceof LocatedFileStatus) {
                locations = ((LocatedFileStatus)stat).getBlockLocations();
            } else {
                FileSystem fs = stat.getPath().getFileSystem(conf);
                locations = fs.getFileBlockLocations(stat, 0L, stat.getLen());
            }
            if (locations == null) {
                this.blocks = new OneBlockInfo[0];
            } else {
                if (locations.length == 0 && !stat.isDirectory()) {
                    locations = new BlockLocation[]{new BlockLocation()};
                }
                if (!isSplitable) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("File is not splittable so no parallelization is possible: " + stat.getPath());
                    }
                    this.blocks = new OneBlockInfo[1];
                    this.fileSize = stat.getLen();
                    this.blocks[0] = new OneBlockInfo(stat.getPath(), 0L, this.fileSize, locations[0].getHosts(), locations[0].getTopologyPaths());
                } else {
                    ArrayList<OneBlockInfo> blocksList = new ArrayList<OneBlockInfo>(locations.length);
                    for (int i = 0; i < locations.length; ++i) {
                        this.fileSize += locations[i].getLength();
                        long left = locations[i].getLength();
                        long myOffset = locations[i].getOffset();
                        long myLength = 0L;
                        do {
                            myLength = maxSize == 0L ? left : (left > maxSize && left < 2L * maxSize ? left / 2L : Math.min(maxSize, left));
                            OneBlockInfo oneblock = new OneBlockInfo(stat.getPath(), myOffset, myLength, locations[i].getHosts(), locations[i].getTopologyPaths());
                            myOffset += myLength;
                            blocksList.add(oneblock);
                        } while ((left -= myLength) > 0L);
                    }
                    this.blocks = blocksList.toArray(new OneBlockInfo[blocksList.size()]);
                }
                OneFileInfo.populateBlockInfo(this.blocks, rackToBlocks, blockToNodes, nodeToBlocks, rackToNodes);
            }
        }

        @VisibleForTesting
        static void populateBlockInfo(OneBlockInfo[] blocks, Map<String, List<OneBlockInfo>> rackToBlocks, Map<OneBlockInfo, String[]> blockToNodes, Map<String, Set<OneBlockInfo>> nodeToBlocks, Map<String, Set<String>> rackToNodes) {
            for (OneBlockInfo oneblock : blocks) {
                Collection<OneBlockInfo> blklist;
                int j;
                blockToNodes.put(oneblock, oneblock.hosts);
                String[] racks = null;
                racks = oneblock.hosts.length == 0 ? new String[]{"/default-rack"} : oneblock.racks;
                for (j = 0; j < racks.length; ++j) {
                    String rack = racks[j];
                    blklist = rackToBlocks.get(rack);
                    if (blklist == null) {
                        blklist = new ArrayList<OneBlockInfo>();
                        rackToBlocks.put(rack, (List<OneBlockInfo>)blklist);
                    }
                    blklist.add(oneblock);
                    if (racks[j].equals("/default-rack")) continue;
                    CombineFileInputFormat.addHostToRack(rackToNodes, racks[j], oneblock.hosts[j]);
                }
                for (j = 0; j < oneblock.hosts.length; ++j) {
                    String node = oneblock.hosts[j];
                    blklist = nodeToBlocks.get(node);
                    if (blklist == null) {
                        blklist = new LinkedHashSet();
                        nodeToBlocks.put(node, (Set<OneBlockInfo>)blklist);
                    }
                    blklist.add(oneblock);
                }
            }
        }

        long getLength() {
            return this.fileSize;
        }

        OneBlockInfo[] getBlocks() {
            return this.blocks;
        }
    }
}

