/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.AbstractMapRClusterConnection;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.GenericHFactory;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.MasterCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RegionServerCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.MapRUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HBaseAdmin
implements Admin {
    public static final String HBASE_ADMIN_CONNECT_AT_CONSTRUCTION = "hbase.admin.connect.at.construction";
    private static final GenericHFactory<AbstractHBaseAdmin> adminFactory_ = new GenericHFactory();
    private static final AtomicBoolean balancer_ = new AtomicBoolean();
    private volatile boolean connected_ = false;
    private volatile boolean isHbaseAvailable_ = true;
    private volatile AbstractHBaseAdmin maprHBaseAdmin_ = null;
    private volatile Throwable hbaseException_ = null;
    private BaseTableMappingRules tableMappingRule_;
    private final HBaseConnector hbaseConnector_;
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);
    private static final String ZK_IDENTIFIER_PREFIX = "hbase-admin-on-";
    private ClusterConnection connection;
    private ClusterConnection maprConnection_ = null;
    private boolean cleanupMapRConnectionOnClose_ = false;
    private volatile Configuration conf;
    private long pause;
    private int numRetries;
    private int retryLongerMultiplier;
    private int syncWaitTimeout;
    private boolean aborted;
    private boolean cleanupConnectionOnClose = false;
    private boolean closed = false;
    private int operationTimeout;
    private int rpcTimeout;
    private RpcRetryingCallerFactory rpcCallerFactory;
    private RpcControllerFactory rpcControllerFactory;
    private NonceGenerator ng;

    @Deprecated
    public HBaseAdmin(Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.conf = new Configuration(c);
        if (this.conf != null) {
            this.conf.set("mapr.hbase.default.db", "unsetDB");
        }
        this.hbaseConnector_ = new HBaseConnector(){

            @Override
            void connect() throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
                HBaseAdmin.this.connectWithConfiguration(HBaseAdmin.this.conf);
            }
        };
        this.commonInit(this.conf);
    }

    void connectWithConfiguration(Configuration c) throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
        this.conf = new Configuration(c);
        this.connection = ConnectionManager.getConnectionInternal(this.conf);
        this.cleanupConnectionOnClose = true;
        this.pause = this.conf.getLong("hbase.client.pause", 100L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 31);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.syncWaitTimeout = this.conf.getInt("hbase.client.sync.wait.timeout.msec", 600000);
        this.rpcCallerFactory = this.connection.getRpcRetryingCallerFactory();
        this.rpcControllerFactory = this.connection.getRpcControllerFactory();
        this.ng = this.connection.getNonceGenerator();
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Deprecated
    public HBaseAdmin(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this((ClusterConnection)connection);
    }

    public HBaseAdmin(final ClusterConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.conf = connection.getConfiguration();
        if (connection instanceof AbstractMapRClusterConnection) {
            try {
                this.tableMappingRule_ = ((AbstractMapRClusterConnection)connection).getTableMappingRule();
                this.maprHBaseAdmin_ = ((AbstractMapRClusterConnection)connection).createAbstractHBaseAdmin();
            }
            catch (IOException e) {
                throw new MasterNotRunningException("Failed to connect to mapr cluster. Reason:" + e.getStackTrace());
            }
            this.maprHBaseAdmin_.setUser(((AbstractMapRClusterConnection)connection).getUser());
            this.hbaseConnector_ = null;
            this.maprConnection_ = connection;
            this.cleanupMapRConnectionOnClose_ = false;
            return;
        }
        this.hbaseConnector_ = new HBaseConnector(){

            @Override
            void connect() throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
                HBaseAdmin.this.connectWithHConnection(connection);
            }
        };
        this.commonInit(connection.getConfiguration());
        if (this.maprHBaseAdmin_ != null && connection instanceof ConnectionManager.HConnectionImplementation) {
            this.maprHBaseAdmin_.setUser(((ConnectionManager.HConnectionImplementation)connection).getUser());
        }
    }

    private void connectWithHConnection(ClusterConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.connection = connection;
        this.pause = this.conf.getLong("hbase.client.pause", 100L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 31);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.operationTimeout = this.conf.getInt("hbase.client.operation.timeout", 1200000);
        this.rpcTimeout = this.conf.getInt("hbase.rpc.timeout", 60000);
        this.syncWaitTimeout = this.conf.getInt("hbase.client.sync.wait.timeout.msec", 600000);
        this.rpcCallerFactory = connection.getRpcRetryingCallerFactory();
        this.rpcControllerFactory = connection.getRpcControllerFactory();
        this.ng = this.connection.getNonceGenerator();
    }

    private synchronized boolean ensureConnectedToHBase() throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.ensureConnectedToHBase(true);
    }

    private synchronized boolean ensureConnectedToHBase(boolean throwException) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (!this.connected_) {
            if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
                if (throwException) {
                    throw new MasterNotRunningException("This client is configured as MapR only.");
                }
                return false;
            }
            if (this.isHbaseAvailable_) {
                try {
                    this.hbaseConnector_.connect();
                    this.connected_ = true;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    this.hbaseException_ = e;
                }
                finally {
                    this.isHbaseAvailable_ = this.connected_;
                }
            }
            if (throwException) {
                if (this.hbaseException_ instanceof RuntimeException) {
                    throw (RuntimeException)this.hbaseException_;
                }
                if (this.hbaseException_ instanceof ZooKeeperConnectionException) {
                    throw (ZooKeeperConnectionException)this.hbaseException_;
                }
                if (!(this.hbaseException_ instanceof MasterNotRunningException)) {
                    this.hbaseException_ = new MasterNotRunningException().initCause(this.hbaseException_);
                }
                throw (MasterNotRunningException)this.hbaseException_;
            }
            return false;
        }
        return true;
    }

    private boolean isMapRDefault() {
        if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
            return true;
        }
        return this.tableMappingRule_.isMapRDefault();
    }

    private boolean checkIfMapRDefault(boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.isMapRDefault()) {
            return true;
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(TableName tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.tableMappingRule_.isMapRTable(tableName)) {
            return true;
        }
        if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
            throw new ZooKeeperConnectionException("This Admin is a MapR cluster Admin, but the table " + tableName + " is not a MapRDB table.");
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(String tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.checkIfMapRTable(TableName.valueOf((String)tableName), connectToHBaseOtherwise);
    }

    private boolean checkIfMapRTable(byte[] tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.checkIfMapRTable(TableName.valueOf((byte[])tableName), connectToHBaseOtherwise);
    }

    private void commonInit(Configuration inConf) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (BaseTableMappingRules.isInHBaseService()) {
            this.tableMappingRule_ = BaseTableMappingRules.INSTANCE;
        } else {
            try {
                this.tableMappingRule_ = TableMappingRulesFactory.create(inConf);
                if (this.tableMappingRule_.getClusterType() != BaseTableMappingRules.ClusterType.HBASE_ONLY) {
                    this.maprHBaseAdmin_ = adminFactory_.getImplementorInstance(inConf.get("hbaseadmin.impl.mapr", "com.mapr.fs.hbase.HBaseAdminImpl"), new Object[]{inConf, this.tableMappingRule_}, Configuration.class, BaseTableMappingRules.class);
                }
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
        if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.HBASE_ONLY || inConf.getBoolean(HBASE_ADMIN_CONNECT_AT_CONSTRUCTION, false)) {
            this.ensureConnectedToHBase();
        }
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.abortProcedure(procId, mayInterruptIfRunning);
        }
        Future<Boolean> future = this.abortProcedureAsync(procId, mayInterruptIfRunning);
        try {
            return future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for procedure to be cancelled");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public Future<Boolean> abortProcedureAsync(final long procId, boolean mayInterruptIfRunning) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.abortProcedureAsync(procId, mayInterruptIfRunning);
        }
        Boolean abortProcResponse = this.executeCallable(new MasterCallable<MasterProtos.AbortProcedureResponse>(this.getConnection()){

            @Override
            public MasterProtos.AbortProcedureResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.AbortProcedureRequest abortProcRequest = MasterProtos.AbortProcedureRequest.newBuilder().setProcId(procId).build();
                return this.master.abortProcedure(controller, abortProcRequest);
            }
        }).getIsProcedureAborted();
        AbortProcedureFuture abortProcFuture = new AbortProcedureFuture(this, (Long)procId, abortProcResponse);
        return abortProcFuture;
    }

    private ClusterConnection getClusterConnection() {
        try {
            this.ensureConnectedToHBase();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to get hbase connection. " + e.getStackTrace()));
            this.connection = null;
        }
        return this.connection;
    }

    @Override
    public HConnection getConnection() {
        if (this.isMapRDefault()) {
            if (this.maprConnection_ == null) {
                try {
                    UserProvider provider = UserProvider.instantiate((Configuration)this.conf);
                    this.maprConnection_ = (ClusterConnection)AbstractMapRClusterConnection.createMapRClusterConnection(this.getConfiguration(), true, provider.getCurrent(), this.tableMappingRule_);
                    this.cleanupMapRConnectionOnClose_ = true;
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to get mapr connection. " + e.getStackTrace()));
                }
            }
            return this.maprConnection_;
        }
        return this.getClusterConnection();
    }

    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(false)) {
            return this.maprHBaseAdmin_.isMasterRunning();
        }
        int numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        try {
            this.conf.setInt("hbase.client.retries.number", this.conf.getInt("hbase.client.retries.number.alternate", 1));
            this.ensureConnectedToHBase();
        }
        finally {
            this.conf.setInt("hbase.client.retries.number", numRetries);
            this.numRetries = numRetries;
        }
        return this.getConnection().isMasterRunning();
    }

    public static void logDefaultDb(Configuration inConf) {
        if (inConf == null) {
            LOG.info((Object)"Input Configuration is null.");
            return;
        }
        LOG.info((Object)("defaultDb = " + inConf.get("mapr.hbase.default.db")));
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.tableExists(tableName.getAliasAsString());
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return MetaTableAccessor.tableExists(this.getConnection(), tableName);
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(TableName.valueOf((byte[])tableName));
    }

    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    @Override
    public HTableDescriptor[] listTables() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTables();
        }
        return this.listTablesInternal(null, false);
    }

    @Override
    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables(pattern, false);
    }

    @Override
    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(regex, false);
    }

    @Override
    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        if (pattern == null) {
            if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
                return this.maprHBaseAdmin_.listTables();
            }
            return this.listTablesInternal(pattern, includeSysTables);
        }
        return this.listTables(pattern.pattern(), includeSysTables);
    }

    private HTableDescriptor[] listTablesInternal(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(pattern, includeSysTables);
                return ProtobufUtil.getHTableDescriptorArray(this.master.getTableDescriptors(controller, req));
            }
        });
    }

    @Override
    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        if (regex == null) {
            if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
                return this.maprHBaseAdmin_.listTables();
            }
            return this.listTablesInternal(null, includeSysTables);
        }
        if (this.checkIfMapRTable(regex, false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTables(regex);
        }
        String adjustedRegex = MapRUtil.adjustTableNameString((String)regex);
        return this.listTablesInternal(Pattern.compile(adjustedRegex), includeSysTables);
    }

    @Deprecated
    public String[] getTableNames() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.getTableNames();
        }
        TableName[] tableNames = this.listTableNames();
        String[] result = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            result[i] = tableNames[i].getNameAsString();
        }
        return result;
    }

    @Deprecated
    public String[] getTableNames(Pattern pattern) throws IOException {
        if (pattern == null) {
            return this.getTableNames();
        }
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.getTableNames(pattern.pattern());
        }
        TableName[] tableNames = this.listTableNames(pattern);
        String[] result = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            result[i] = tableNames[i].getNameAsString();
        }
        return result;
    }

    @Deprecated
    public String[] getTableNames(String regex) throws IOException {
        if (regex == null) {
            return this.getTableNames();
        }
        if (this.checkIfMapRTable(regex, true)) {
            return this.maprHBaseAdmin_.getTableNames(regex);
        }
        return this.getTableNames(Pattern.compile(regex));
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTableNames();
        }
        return this.listTableNamesInternal(null, false);
    }

    @Override
    public TableName[] listTableNames(Pattern pattern) throws IOException {
        if (pattern == null) {
            return this.listTableNames();
        }
        return this.listTableNames(pattern, false);
    }

    @Override
    public TableName[] listTableNames(String regex) throws IOException {
        if (regex == null) {
            return this.listTableNames();
        }
        return this.listTableNames(Pattern.compile(regex), false);
    }

    @Override
    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        if (pattern == null) {
            if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
                return this.maprHBaseAdmin_.listTableNames();
            }
            return this.listTableNamesInternal(null, includeSysTables);
        }
        return this.listTableNames(pattern.pattern(), includeSysTables);
    }

    public TableName[] listTableNamesInternal(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return this.executeCallable(new MasterCallable<TableName[]>(this.getConnection()){

            @Override
            public TableName[] call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.GetTableNamesRequest req = RequestConverter.buildGetTableNamesRequest(pattern, includeSysTables);
                return ProtobufUtil.getTableNameArray(this.master.getTableNames(controller, req).getTableNamesList());
            }
        });
    }

    @Override
    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        if (regex == null) {
            if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
                return this.maprHBaseAdmin_.listTableNames();
            }
            return this.listTableNamesInternal(null, includeSysTables);
        }
        if (this.checkIfMapRTable(regex, false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTableNames(regex);
        }
        String adjustedRegex = MapRUtil.adjustTableNameString((String)regex);
        return this.listTableNamesInternal(Pattern.compile(adjustedRegex), includeSysTables);
    }

    @Override
    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        if (tableName == null) {
            return null;
        }
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getTableDescriptor(tableName.getAliasAsString());
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return HBaseAdmin.getTableDescriptor(tableName, this.getConnection(), this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeout, this.rpcTimeout);
    }

    static HTableDescriptor getTableDescriptor(final TableName tableName, HConnection connection, RpcRetryingCallerFactory rpcCallerFactory, final RpcControllerFactory rpcControllerFactory, int operationTimeout, int rpcTimeout) throws TableNotFoundException, IOException {
        if (tableName == null) {
            return null;
        }
        HTableDescriptor htd = HBaseAdmin.executeCallable(new MasterCallable<HTableDescriptor>(connection){

            @Override
            public HTableDescriptor call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                MasterProtos.GetTableDescriptorsResponse htds = this.master.getTableDescriptors(controller, req);
                if (!htds.getTableSchemaList().isEmpty()) {
                    return HTableDescriptor.convert((HBaseProtos.TableSchema)htds.getTableSchemaList().get(0));
                }
                return null;
            }
        }, rpcCallerFactory, operationTimeout, rpcTimeout);
        if (htd != null) {
            return htd;
        }
        throw new TableNotFoundException(tableName.getNameAsString());
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        if (tableName == null) {
            return null;
        }
        return this.getTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    @Override
    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        try {
            Future<Void> future = this.createTableAsyncV2(desc, splitKeys);
            if (this.checkIfMapRTable(desc.getTableName(), false)) {
                return;
            }
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be enabled; meta scan was done");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTableAsyncV2(desc, splitKeys);
    }

    private Future<Void> createTableAsyncV2(final HTableDescriptor desc, final byte[][] splitKeys) throws IOException {
        if (desc.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        desc.validate();
        if (this.checkIfMapRTable(desc.getTableName(), true)) {
            this.maprHBaseAdmin_.createTable(desc, splitKeys);
            return null;
        }
        TableName.isLegalFullyQualifiedTableName((byte[])desc.getTableName().getName());
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo((byte[])splitKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
                }
                if (lastKey != null && Bytes.equals((byte[])splitKey, (byte[])lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary((byte[])splitKey) + ", " + Bytes.toStringBinary((byte[])lastKey));
                }
                lastKey = splitKey;
            }
        }
        MasterProtos.CreateTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.CreateTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.CreateTableResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(desc.getTableName());
                MasterProtos.CreateTableRequest request = RequestConverter.buildCreateTableRequest(desc, splitKeys, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                return this.master.createTable(controller, request);
            }
        });
        return new CreateTableFuture(this, desc, splitKeys, response);
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf((byte[])tableName));
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.deleteTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.deleteTableInternal(tableName);
    }

    public void deleteTableInternal(TableName tableName) throws IOException {
        Future<Void> future = this.deleteTableAsyncV2(tableName);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be deleted");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    private Future<Void> deleteTableAsyncV2(final TableName tableName) throws IOException {
        MasterProtos.DeleteTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.DeleteTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.DeleteTableResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                MasterProtos.DeleteTableRequest req = RequestConverter.buildDeleteTableRequest(tableName, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                return this.master.deleteTable(controller, req);
            }
        });
        return new DeleteTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.deleteTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to delete table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public void truncateTable(final TableName tableName, final boolean preserveSplits) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.truncateTable(tableName, preserveSplits);
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.TruncateTableRequest req = RequestConverter.buildTruncateTableRequest(tableName, preserveSplits, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                this.master.truncateTable(null, req);
                return null;
            }
        });
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.enableTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        Future<Void> future = this.enableTableAsyncV2(tableName);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be disabled");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    private void waitUntilTableIsEnabled(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return;
        }
        boolean enabled = false;
        long start = EnvironmentEdgeManager.currentTime();
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            try {
                enabled = this.isTableEnabled(tableName);
            }
            catch (TableNotFoundException tnfe) {
                enabled = false;
            }
            boolean bl = enabled = enabled && this.isTableAvailable(tableName);
            if (enabled) break;
            long sleep = this.getPauseTime(tries);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be enabled in " + tableName));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
        }
        if (!enabled) {
            long msec = EnvironmentEdgeManager.currentTime() - start;
            throw new IOException("Table '" + tableName + "' not yet enabled, after " + msec + "ms.");
        }
    }

    @Override
    public void enableTableAsync(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.enableTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.enableTableAsyncInternal(tableName);
    }

    public void enableTableAsyncInternal(TableName tableName) throws IOException {
        this.enableTableAsyncV2(tableName);
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.enableTableAsync(TableName.valueOf((byte[])tableName));
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTableAsync(TableName.valueOf((String)tableName));
    }

    private Future<Void> enableTableAsyncV2(final TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        MasterProtos.EnableTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.EnableTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.EnableTableResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                LOG.info((Object)("Started enable of " + tableName));
                MasterProtos.EnableTableRequest req = RequestConverter.buildEnableTableRequest(tableName, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                return this.master.enableTable(controller, req);
            }
        });
        return new EnableTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.enableTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getTableName())) continue;
            try {
                this.enableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to enable table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public void disableTableAsync(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.disableTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.disableTableAsyncInternal(tableName);
    }

    public void disableTableAsyncInternal(TableName tableName) throws IOException {
        this.disableTableAsyncV2(tableName);
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.disableTableAsync(TableName.valueOf((byte[])tableName));
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTableAsync(TableName.valueOf((String)tableName));
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.disableTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        Future<Void> future = this.disableTableAsyncV2(tableName);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be disabled");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    private Future<Void> disableTableAsyncV2(final TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        MasterProtos.DisableTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.DisableTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.DisableTableResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                LOG.info((Object)("Started disable of " + tableName));
                MasterProtos.DisableTableRequest req = RequestConverter.buildDisableTableRequest(tableName, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                return this.master.disableTable(controller, req);
            }
        });
        return new DisableTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        String regex = pattern.pattern();
        if (this.checkIfMapRTable(regex, true)) {
            return this.maprHBaseAdmin_.disableTables(regex);
        }
        String adjustedRegex = MapRUtil.adjustTableNameString((String)regex);
        pattern = Pattern.compile(adjustedRegex);
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getTableName())) continue;
            try {
                this.disableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to disable table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    private void checkTableExistence(TableName tableName) throws IOException {
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableEnabled(tableName.getAliasAsString());
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        this.checkTableExistence(tableName);
        return this.getConnection().isTableEnabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableDisabled(tableName.getAliasAsString());
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        this.checkTableExistence(tableName);
        return this.getConnection().isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableAvailable(tableName.getAliasAsString());
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return this.getConnection().isTableAvailable(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName));
    }

    @Override
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableAvailable(tableName.getAliasAsString(), splitKeys);
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return this.getConnection().isTableAvailable(tableName, splitKeys);
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName), splitKeys);
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getAlterStatus(tableName);
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        return this.getAlterStatusInternal(tableName);
    }

    public Pair<Integer, Integer> getAlterStatusInternal(final TableName tableName) throws IOException {
        return this.executeCallable(new MasterCallable<Pair<Integer, Integer>>(this.getConnection()){

            @Override
            public Pair<Integer, Integer> call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                MasterProtos.GetSchemaAlterStatusRequest req = RequestConverter.buildGetSchemaAlterStatusRequest(tableName);
                MasterProtos.GetSchemaAlterStatusResponse ret = this.master.getSchemaAlterStatus(controller, req);
                Pair pair = new Pair((Object)ret.getYetToUpdateRegions(), (Object)ret.getTotalRegions());
                return pair;
            }
        });
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((byte[])tableName));
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((byte[])tableName), column);
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    @Override
    public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        column.validate();
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.addColumn(tableName.getAliasAsString(), column);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.addColumnInternal(tableName, column);
    }

    public void addColumnInternal(final TableName tableName, final HColumnDescriptor column) throws IOException {
        column.validate();
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                MasterProtos.AddColumnRequest req = RequestConverter.buildAddColumnRequest(tableName, column, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                this.master.addColumn(controller, req);
                return null;
            }
        });
    }

    public void deleteColumn(byte[] tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((byte[])tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    @Override
    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.deleteColumn(tableName.getAliasAsString(), Bytes.toString((byte[])columnName));
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.deleteColumnInternal(tableName, columnName);
    }

    public void deleteColumnInternal(final TableName tableName, final byte[] columnName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                MasterProtos.DeleteColumnRequest req = RequestConverter.buildDeleteColumnRequest(tableName, columnName, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                this.master.deleteColumn(controller, req);
                return null;
            }
        });
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((byte[])tableName), descriptor);
    }

    @Override
    public void modifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        descriptor.validate();
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.modifyColumn(tableName.getAliasAsString(), descriptor);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.modifyColumnInternal(tableName, descriptor);
    }

    public void modifyColumnInternal(final TableName tableName, final HColumnDescriptor descriptor) throws IOException {
        descriptor.validate();
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                MasterProtos.ModifyColumnRequest req = RequestConverter.buildModifyColumnRequest(tableName, descriptor, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                this.master.modifyColumn(controller, req);
                return null;
            }
        });
    }

    @Override
    public void closeRegion(String regionname, String serverName) throws IOException {
        this.closeRegion(Bytes.toBytes((String)regionname), serverName);
    }

    @Override
    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionname), true)) {
            this.maprHBaseAdmin_.closeRegion(regionname, serverName);
            return;
        }
        if (serverName != null) {
            Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(this.getConnection(), regionname);
            if (pair == null || pair.getFirst() == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionname));
            }
            this.closeRegion(ServerName.valueOf(serverName), (HRegionInfo)pair.getFirst());
        } else {
            Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(this.getConnection(), regionname);
            if (pair == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionname));
            }
            if (pair.getSecond() == null) {
                throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionname));
            }
            this.closeRegion((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst());
        }
    }

    @Override
    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        byte[] regionName = this.getRegionName(encodedRegionName.getBytes());
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            return this.maprHBaseAdmin_.closeRegionWithEncodedRegionName(new String(regionName), serverName);
        }
        if (null == serverName || "".equals(serverName.trim())) {
            throw new IllegalArgumentException("The servername cannot be null or empty.");
        }
        ServerName sn = ServerName.valueOf(serverName);
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest(sn, encodedRegionName, false);
        try {
            HBaseRpcController controller = this.rpcControllerFactory.newController();
            AdminProtos.CloseRegionResponse response = admin.closeRegion((RpcController)controller, request);
            boolean isRegionClosed = response.getClosed();
            if (!isRegionClosed) {
                LOG.error((Object)("Not able to close the region " + encodedRegionName + "."));
            }
            return isRegionClosed;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        if (this.checkIfMapRTable(hri.getTable(), true)) {
            this.maprHBaseAdmin_.closeRegion(sn, hri);
            return;
        }
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        ProtobufUtil.closeRegion(controller, admin, sn, hri.getRegionName(), false);
    }

    @Override
    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.getOnlineRegions(sn);
        }
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        return ProtobufUtil.getOnlineRegions(controller, admin);
    }

    @Override
    public void flush(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.flush(tableName.getName());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        this.checkTableExists(tableName);
        if (this.isTableDisabled(tableName)) {
            LOG.info((Object)("Table is disabled: " + tableName.getNameAsString()));
            return;
        }
        this.execProcedure("flush-table-proc", tableName.getNameAsString(), new HashMap<String, String>());
    }

    @Override
    public void flushRegion(byte[] regionName) throws IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.flush(regionName);
            return;
        }
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName = MapRUtil.adjustTableName((byte[])regionName));
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Unknown regionname: " + Bytes.toStringBinary((byte[])regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName));
        }
        this.flush((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst());
    }

    @Deprecated
    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes((String)tableNameOrRegionName));
    }

    @Deprecated
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(tableNameOrRegionName), true)) {
            this.maprHBaseAdmin_.flush(tableNameOrRegionName);
            return;
        }
        tableNameOrRegionName = MapRUtil.adjustTableName((byte[])tableNameOrRegionName);
        try {
            this.flushRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException e) {
            this.flush(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    private void flush(ServerName sn, HRegionInfo hri) throws IOException {
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(hri.getRegionName());
        try {
            admin.flushRegion((RpcController)controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public void compact(TableName tableName) throws IOException {
        this.compact(tableName, null, false);
    }

    @Override
    public void compactRegion(byte[] regionName) throws IOException {
        this.compactRegion(regionName, null, false);
    }

    @Deprecated
    public void compact(String tableNameOrRegionName) throws IOException {
        this.compact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    @Deprecated
    public void compact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, null, false);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName), null, false);
        }
    }

    @Override
    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        this.compact(tableName, columnFamily, false);
    }

    @Override
    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.compactRegion(regionName, columnFamily, false);
    }

    @Deprecated
    public void compact(String tableOrRegionName, String columnFamily) throws IOException {
        this.compact(Bytes.toBytes((String)tableOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    @Deprecated
    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, columnFamily, false);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName), columnFamily, false);
        }
    }

    @Override
    public void compactRegionServer(ServerName sn, boolean major) throws IOException, InterruptedException {
        for (HRegionInfo region : this.getOnlineRegions(sn)) {
            this.compact(sn, region, major, null);
        }
    }

    @Override
    public void majorCompact(TableName tableName) throws IOException {
        this.compact(tableName, null, true);
    }

    @Override
    public void majorCompactRegion(byte[] regionName) throws IOException {
        this.compactRegion(regionName, null, true);
    }

    @Deprecated
    public void majorCompact(String tableNameOrRegionName) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    @Deprecated
    public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, null, true);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName), null, true);
        }
    }

    @Override
    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        this.compact(tableName, columnFamily, true);
    }

    @Override
    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.compactRegion(regionName, columnFamily, true);
    }

    @Deprecated
    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    @Deprecated
    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, columnFamily, true);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName), columnFamily, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(TableName tableName, byte[] columnFamily, boolean major) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.compact(tableName.getName(), columnFamily, major);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        try (ZooKeeperWatcher zookeeper = null;){
            this.checkTableExists(tableName);
            zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.getConnection().toString(), new ThrowableAbortable());
            List<Pair<HRegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(zookeeper, this.getConnection(), tableName);
            for (Pair<HRegionInfo, ServerName> pair : pairs) {
                if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                try {
                    this.compact((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst(), major, columnFamily);
                }
                catch (NotServingRegionException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Trying to" + (major ? " major" : "") + " compact " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                }
            }
        }
    }

    private void compactRegion(byte[] regionName, byte[] columnFamily, boolean major) throws IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.compact(regionName, columnFamily, major);
            return;
        }
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName = MapRUtil.adjustTableName((byte[])regionName));
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary((byte[])regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName));
        }
        this.compact((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst(), major, columnFamily);
    }

    private void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        if (this.checkIfMapRTable(hri.getTable(), true)) {
            this.maprHBaseAdmin_.compact(sn, hri, major, family);
            return;
        }
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        AdminProtos.CompactRegionRequest request = RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, family);
        try {
            admin.compactRegion((RpcController)controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public void move(final byte[] encodedRegionName, final byte[] destServerName) throws IOException {
        byte[] regionName = this.getRegionName(encodedRegionName);
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.move(regionName, destServerName);
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                if (HBaseAdmin.this.isMetaRegion(encodedRegionName)) {
                    controller.setPriority(TableName.META_TABLE_NAME);
                }
                try {
                    MasterProtos.MoveRegionRequest request = RequestConverter.buildMoveRegionRequest(encodedRegionName, destServerName);
                    this.master.moveRegion(controller, request);
                }
                catch (DeserializationException de) {
                    LOG.error((Object)("Could not parse destination server name: " + de));
                    throw new ServiceException((Throwable)((Object)new DoNotRetryIOException(de)));
                }
                return null;
            }
        });
    }

    private boolean isMetaRegion(byte[] regionName) {
        return Bytes.equals((byte[])regionName, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals((byte[])regionName, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes());
    }

    @Override
    public void assign(final byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.assign(regionName);
            return;
        }
        final byte[] toBeAssigned = this.getRegionName(regionName);
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                if (HBaseAdmin.this.isMetaRegion(regionName)) {
                    controller.setPriority(TableName.META_TABLE_NAME);
                }
                MasterProtos.AssignRegionRequest request = RequestConverter.buildAssignRegionRequest(toBeAssigned);
                this.master.assignRegion(controller, request);
                return null;
            }
        });
    }

    @Override
    public void unassign(final byte[] regionName, final boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.unassign(regionName, force);
            return;
        }
        final byte[] toBeUnassigned = this.getRegionName(regionName);
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                if (HBaseAdmin.this.isMetaRegion(regionName)) {
                    controller.setPriority(TableName.META_TABLE_NAME);
                }
                MasterProtos.UnassignRegionRequest request = RequestConverter.buildUnassignRegionRequest(toBeUnassigned, force);
                this.master.unassignRegion(controller, request);
                return null;
            }
        });
    }

    @Override
    public void offline(final byte[] regionName) throws IOException, ZooKeeperConnectionException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.offline(regionName);
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                if (HBaseAdmin.this.isMetaRegion(regionName)) {
                    controller.setPriority(TableName.META_TABLE_NAME);
                }
                this.master.offlineRegion(controller, RequestConverter.buildOfflineRegionRequest(regionName));
                return null;
            }
        });
    }

    @Override
    public boolean setBalancerRunning(final boolean on, final boolean synchronous) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return balancer_.getAndSet(on);
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.SetBalancerRunningRequest req = RequestConverter.buildSetBalancerRunningRequest(on, synchronous);
                return this.master.setBalancerRunning(controller, req).getPrevBalanceValue();
            }
        });
    }

    @Override
    public boolean balancer() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return true;
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.balance(controller, RequestConverter.buildBalanceRequest(false)).getBalancerRan();
            }
        });
    }

    @Override
    public boolean balancer(final boolean force) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return true;
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.balance(controller, RequestConverter.buildBalanceRequest(force)).getBalancerRan();
            }
        });
    }

    @Override
    public boolean isBalancerEnabled() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return true;
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.isBalancerEnabled(controller, RequestConverter.buildIsBalancerEnabledRequest()).getEnabled();
            }
        });
    }

    @Override
    public boolean normalize() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("normalize is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.normalize(controller, RequestConverter.buildNormalizeRequest()).getNormalizerRan();
            }
        });
    }

    @Override
    public boolean isNormalizerEnabled() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("isNormalizerEnabled is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.isNormalizerEnabled(controller, RequestConverter.buildIsNormalizerEnabledRequest()).getEnabled();
            }
        });
    }

    @Override
    public boolean setNormalizerRunning(final boolean on) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("setNormalizerRunning is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.SetNormalizerRunningRequest req = RequestConverter.buildSetNormalizerRunningRequest(on);
                return this.master.setNormalizerRunning(controller, req).getPrevNormalizerValue();
            }
        });
    }

    @Override
    public boolean enableCatalogJanitor(final boolean enable) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.enableCatalogJanitor(enable);
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.enableCatalogJanitor(controller, RequestConverter.buildEnableCatalogJanitorRequest(enable)).getPrevValue();
            }
        });
    }

    @Override
    public int runCatalogScan() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.runCatalogScan();
        }
        return this.executeCallable(new MasterCallable<Integer>(this.getConnection()){

            @Override
            public Integer call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.runCatalogScan(controller, RequestConverter.buildCatalogScanRequest()).getScanResult();
            }
        });
    }

    @Override
    public boolean isCatalogJanitorEnabled() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.isCatalogJanitorEnabled();
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.isCatalogJanitorEnabled(controller, RequestConverter.buildIsCatalogJanitorEnabledRequest()).getValue();
            }
        });
    }

    @Override
    public boolean setCleanerChoreRunning(final boolean on) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("setCleanerChoreRunning is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.setCleanerChoreRunning(null, RequestConverter.buildSetCleanerChoreRunningRequest(on)).getPrevValue();
            }
        });
    }

    @Override
    public boolean runCleanerChore() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("runCleanerChore is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.runCleanerChore(null, RequestConverter.buildCleanerChoreRequest()).getCleanerChoreRan();
            }
        });
    }

    @Override
    public boolean isCleanerChoreEnabled() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("isCleanerChoreEnabled is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.isCleanerChoreEnabled(null, RequestConverter.buildIsCleanerChoreEnabledRequest()).getValue();
            }
        });
    }

    private boolean isEncodedRegionName(byte[] regionName) throws IOException {
        try {
            HRegionInfo.parseRegionName(regionName);
            return false;
        }
        catch (IOException e) {
            if (StringUtils.stringifyException((Throwable)e).contains("Invalid regionName format")) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, final boolean forcible) throws IOException {
        final byte[] encodedNameOfRegionA = this.isEncodedRegionName(nameOfRegionA) ? nameOfRegionA : Bytes.toBytes((String)HRegionInfo.encodeRegionName(nameOfRegionA));
        final byte[] encodedNameOfRegionB = this.isEncodedRegionName(nameOfRegionB) ? nameOfRegionB : Bytes.toBytes((String)HRegionInfo.encodeRegionName(nameOfRegionB));
        byte[] regionNameA = this.getRegionName(encodedNameOfRegionA);
        byte[] regionNameB = this.getRegionName(encodedNameOfRegionB);
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionNameA), true) || this.checkIfMapRTable(HRegionInfo.getTable(regionNameB), true)) {
            this.maprHBaseAdmin_.mergeRegions(regionNameA, regionNameB, forcible);
            return;
        }
        Pair<HRegionInfo, ServerName> pair = this.getRegion(nameOfRegionA);
        if (pair != null && ((HRegionInfo)pair.getFirst()).getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke merge on non-default regions directly");
        }
        pair = this.getRegion(nameOfRegionB);
        if (pair != null && ((HRegionInfo)pair.getFirst()).getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke merge on non-default regions directly");
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                try {
                    MasterProtos.DispatchMergingRegionsRequest request = RequestConverter.buildDispatchMergingRegionsRequest(encodedNameOfRegionA, encodedNameOfRegionB, forcible);
                    this.master.dispatchMergingRegions(controller, request);
                }
                catch (DeserializationException de) {
                    LOG.error((Object)("Could not parse destination server name: " + de));
                }
                return null;
            }
        });
    }

    @Override
    public void split(TableName tableName) throws IOException {
        this.split(tableName, null);
    }

    @Override
    public void splitRegion(byte[] regionName) throws IOException {
        this.splitRegion(regionName, null);
    }

    @Deprecated
    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes((String)tableNameOrRegionName));
    }

    @Deprecated
    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(tableNameOrRegionName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void split(TableName tableName, byte[] splitPoint) throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.split(tableName.getName(), splitPoint);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        try (ZooKeeperWatcher zookeeper = null;){
            this.checkTableExists(tableName);
            zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.getConnection().toString(), new ThrowableAbortable());
            List<Pair<HRegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(zookeeper, this.getConnection(), tableName);
            for (Pair<HRegionInfo, ServerName> pair : pairs) {
                HRegionInfo r;
                if (pair.getSecond() == null || (r = (HRegionInfo)pair.getFirst()).isSplitParent() || r.getReplicaId() != 0 || splitPoint != null && !r.containsRow(splitPoint)) continue;
                this.split((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst(), splitPoint);
            }
        }
    }

    @Override
    public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            this.maprHBaseAdmin_.split(regionName, splitPoint);
            return;
        }
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName = MapRUtil.adjustTableName((byte[])regionName));
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary((byte[])regionName));
        }
        if (regionServerPair.getFirst() != null && ((HRegionInfo)regionServerPair.getFirst()).getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't split replicas directly. Replicas are auto-split when their primary is split.");
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName));
        }
        this.split((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst(), splitPoint);
    }

    @Deprecated
    public void split(String tableNameOrRegionName, String splitPoint) throws IOException {
        this.split(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)splitPoint));
    }

    @Deprecated
    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        try {
            this.splitRegion(tableNameOrRegionName, splitPoint);
        }
        catch (IllegalArgumentException e) {
            this.split(TableName.valueOf((byte[])tableNameOrRegionName), splitPoint);
        }
    }

    @VisibleForTesting
    public void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        if (hri.getStartKey() != null && splitPoint != null && Bytes.compareTo((byte[])hri.getStartKey(), (byte[])splitPoint) == 0) {
            throw new IOException("should not give a splitkey which equals to startkey!");
        }
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        controller.setPriority(hri.getTable());
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        ProtobufUtil.split(controller, admin, hri, splitPoint);
    }

    @Override
    public void modifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.modifyTable(tableName.getAliasAsString(), htd);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.modifyTableInternal(tableName, htd);
    }

    public void modifyTableInternal(final TableName tableName, final HTableDescriptor htd) throws IOException {
        if (!tableName.equals((Object)htd.getTableName())) {
            throw new IllegalArgumentException("the specified table name '" + tableName + "' doesn't match with the HTD one: " + htd.getTableName());
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(tableName);
                MasterProtos.ModifyTableRequest request = RequestConverter.buildModifyTableRequest(tableName, htd, HBaseAdmin.this.ng.getNonceGroup(), HBaseAdmin.this.ng.newNonce());
                this.master.modifyTable(controller, request);
                return null;
            }
        });
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((byte[])tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((String)tableName), htd);
    }

    Pair<HRegionInfo, ServerName> getRegion(byte[] regionName) throws IOException {
        if (regionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        Pair pair = MetaTableAccessor.getRegion(this.getConnection(), regionName);
        if (pair == null) {
            final AtomicReference<Object> result = new AtomicReference<Object>(null);
            final String encodedName = Bytes.toString((byte[])regionName);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result data) throws IOException {
                    HRegionInfo info = HRegionInfo.getHRegionInfo(data);
                    if (info == null) {
                        LOG.warn((Object)("No serialized HRegionInfo in " + data));
                        return true;
                    }
                    RegionLocations rl = MetaTableAccessor.getRegionLocations(data);
                    boolean matched = false;
                    ServerName sn = null;
                    for (HRegionLocation h : rl.getRegionLocations()) {
                        if (h == null || !encodedName.equals(h.getRegionInfo().getEncodedName())) continue;
                        sn = h.getServerName();
                        info = h.getRegionInfo();
                        matched = true;
                    }
                    if (!matched) {
                        return true;
                    }
                    result.set(new Pair((Object)info, sn));
                    return false;
                }
            };
            MetaScanner.metaScan(this.getConnection(), visitor, null);
            pair = result.get();
        }
        return pair;
    }

    private byte[] getRegionName(byte[] regionNameOrEncodedRegionName) throws IOException {
        if (Bytes.equals((byte[])regionNameOrEncodedRegionName, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals((byte[])regionNameOrEncodedRegionName, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes())) {
            return HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
        }
        byte[] tmp = regionNameOrEncodedRegionName;
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionNameOrEncodedRegionName);
        if (regionServerPair != null && regionServerPair.getFirst() != null) {
            tmp = ((HRegionInfo)regionServerPair.getFirst()).getRegionName();
        }
        return tmp;
    }

    private TableName checkTableExists(TableName tableName) throws IOException {
        if (!MetaTableAccessor.tableExists(this.getConnection(), tableName)) {
            throw new TableNotFoundException(tableName);
        }
        return tableName;
    }

    @Override
    public synchronized void shutdown() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.shutdown();
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(200);
                this.master.shutdown(controller, MasterProtos.ShutdownRequest.newBuilder().build());
                return null;
            }
        });
    }

    @Override
    public synchronized void stopMaster() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.stopMaster();
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                controller.setPriority(200);
                this.master.stopMaster(controller, MasterProtos.StopMasterRequest.newBuilder().build());
                return null;
            }
        });
    }

    @Override
    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.stopRegionServer(hostnamePort);
            return;
        }
        String hostname = Addressing.parseHostname((String)hostnamePort);
        int port = Addressing.parsePort((String)hostnamePort);
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(ServerName.valueOf(hostname, port, 0L));
        AdminProtos.StopServerRequest request = RequestConverter.buildStopServerRequest("Called by admin client " + this.getConnection().toString());
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        controller.setPriority(200);
        try {
            admin.stopServer((RpcController)controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public boolean isMasterInMaintenanceMode() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("isMasterInMaintenanceMode is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<MasterProtos.IsInMaintenanceModeResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsInMaintenanceModeResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.isMasterInMaintenanceMode(controller, MasterProtos.IsInMaintenanceModeRequest.newBuilder().build());
            }
        }).getInMaintenanceMode();
    }

    @Override
    public ClusterStatus getClusterStatus() throws IOException {
        if (this.checkIfMapRDefault(false)) {
            return this.maprHBaseAdmin_.getClusterStatus();
        }
        if (!this.ensureConnectedToHBase(false)) {
            LOG.warn((Object)"cannot connect to hbase cluster, return null.");
            return null;
        }
        return this.executeCallable(new MasterCallable<ClusterStatus>(this.getConnection()){

            @Override
            public ClusterStatus call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.GetClusterStatusRequest req = RequestConverter.buildGetClusterStatusRequest();
                return ClusterStatus.convert(this.master.getClusterStatus(controller, req).getClusterStatus());
            }
        });
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void createNamespace(final NamespaceDescriptor descriptor) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.createNamespace(descriptor);
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                this.master.createNamespace(controller, MasterProtos.CreateNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
                return null;
            }
        });
    }

    @Override
    public void modifyNamespace(final NamespaceDescriptor descriptor) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.modifyNamespace(descriptor);
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                this.master.modifyNamespace(controller, MasterProtos.ModifyNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
                return null;
            }
        });
    }

    @Override
    public void deleteNamespace(final String name) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.deleteNamespace(name);
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                this.master.deleteNamespace(controller, MasterProtos.DeleteNamespaceRequest.newBuilder().setNamespaceName(name).build());
                return null;
            }
        });
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(final String name) throws NamespaceNotFoundException, IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.getNamespaceDescriptor(name);
        }
        return this.executeCallable(new MasterCallable<NamespaceDescriptor>(this.getConnection()){

            @Override
            public NamespaceDescriptor call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return ProtobufUtil.toNamespaceDescriptor(this.master.getNamespaceDescriptor(controller, MasterProtos.GetNamespaceDescriptorRequest.newBuilder().setNamespaceName(name).build()).getNamespaceDescriptor());
            }
        });
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.listNamespaceDescriptors();
        }
        return this.executeCallable(new MasterCallable<NamespaceDescriptor[]>(this.getConnection()){

            @Override
            public NamespaceDescriptor[] call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                List list = this.master.listNamespaceDescriptors(controller, MasterProtos.ListNamespaceDescriptorsRequest.newBuilder().build()).getNamespaceDescriptorList();
                NamespaceDescriptor[] res = new NamespaceDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)list.get(i));
                }
                return res;
            }
        });
    }

    @Override
    public ProcedureInfo[] listProcedures() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.listProcedures();
        }
        return this.executeCallable(new MasterCallable<ProcedureInfo[]>(this.getConnection()){

            @Override
            public ProcedureInfo[] call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                List procList = this.master.listProcedures(controller, MasterProtos.ListProceduresRequest.newBuilder().build()).getProcedureList();
                ProcedureInfo[] procInfoList = new ProcedureInfo[procList.size()];
                for (int i = 0; i < procList.size(); ++i) {
                    procInfoList[i] = ProcedureInfo.convert((ProcedureProtos.Procedure)((ProcedureProtos.Procedure)procList.get(i)));
                }
                return procInfoList;
            }
        });
    }

    @Override
    public HTableDescriptor[] listTableDescriptorsByNamespace(final String name) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.listTableDescriptorsByNamespace(name);
        }
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                List list = this.master.listTableDescriptorsByNamespace(controller, MasterProtos.ListTableDescriptorsByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableSchemaList();
                HTableDescriptor[] res = new HTableDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = HTableDescriptor.convert((HBaseProtos.TableSchema)list.get(i));
                }
                return res;
            }
        });
    }

    @Override
    public TableName[] listTableNamesByNamespace(final String name) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.listTableNamesByNamespace(name);
        }
        return this.executeCallable(new MasterCallable<TableName[]>(this.getConnection()){

            @Override
            public TableName[] call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                List tableNames = this.master.listTableNamesByNamespace(controller, MasterProtos.ListTableNamesByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableNameList();
                TableName[] result = new TableName[tableNames.size()];
                for (int i = 0; i < tableNames.size(); ++i) {
                    result[i] = ProtobufUtil.toTableName((TableProtos.TableName)tableNames.get(i));
                }
                return result;
            }
        });
    }

    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, ServiceException, IOException {
        try {
            if (TableMappingRulesFactory.create(conf).getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
                LOG.warn((Object)"checkHBaseAvailable called for MAPR_ONLY cluster!");
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (BaseTableMappingRules.isInHBaseService()) {
            return;
        }
        Configuration copyOfConf = HBaseConfiguration.create((Configuration)conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        copyOfConf.setBoolean(HBASE_ADMIN_CONNECT_AT_CONSTRUCTION, true);
        copyOfConf.setInt("zookeeper.recovery.retry", 0);
        try (ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection(copyOfConf);){
            if (connection instanceof AbstractMapRClusterConnection) {
                return;
            }
            try (ZooKeeperKeepAliveConnection zkw = null;){
                zkw = ((ConnectionManager.HConnectionImplementation)connection).getKeepAliveZooKeeperWatcher();
                zkw.getRecoverableZooKeeper().getZooKeeper().exists(zkw.baseZNode, false);
            }
            connection.isMasterRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getTableRegions(tableName.getQualifier());
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        List<HRegionInfo> Regions = null;
        try (ZooKeeperWatcher zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.getConnection().toString(), new ThrowableAbortable());){
            Regions = MetaTableAccessor.getTableRegions(zookeeper, this.getConnection(), tableName, true);
        }
        return Regions;
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        return this.getTableRegions(TableName.valueOf((byte[])tableName));
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.maprHBaseAdmin_ != null) {
            this.maprHBaseAdmin_.close();
            this.maprHBaseAdmin_ = null;
        }
        if (this.cleanupMapRConnectionOnClose_ && this.maprConnection_ != null) {
            this.maprConnection_.close();
            this.maprConnection_ = null;
        }
        if (this.cleanupConnectionOnClose && this.connection != null && !this.closed) {
            this.connection.close();
            this.closed = true;
        }
    }

    @Override
    public HTableDescriptor[] getTableDescriptorsByTableName(final List<TableName> tableNames) throws IOException {
        if (this.tableMappingRule_.getClusterType() != BaseTableMappingRules.ClusterType.HBASE_ONLY) {
            ArrayList<HTableDescriptor> list = new ArrayList<HTableDescriptor>();
            for (TableName tableName : tableNames) {
                list.add(this.getTableDescriptor(tableName));
            }
            return list.toArray(new HTableDescriptor[list.size()]);
        }
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                return ProtobufUtil.getHTableDescriptorArray(this.master.getTableDescriptors(controller, req));
            }
        });
    }

    private HTableDescriptor getTableDescriptorByTableName(TableName tableName) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>(1);
        tableNames.add(tableName);
        HTableDescriptor[] htdl = this.getTableDescriptorsByTableName(tableNames);
        if (htdl == null || htdl.length == 0) {
            return null;
        }
        return htdl[0];
    }

    @Override
    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
        for (String name : names) {
            tableNames.add(TableName.valueOf((String)name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    private AdminProtos.RollWALWriterResponse rollWALWriterImpl(ServerName sn) throws IOException, FailedLogCloseException {
        AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
        AdminProtos.RollWALWriterRequest request = RequestConverter.buildRollWALWriterRequest();
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        try {
            return admin.rollWALWriter((RpcController)controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Deprecated
    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.rollHLogWriter(serverName);
        }
        ServerName sn = ServerName.valueOf(serverName);
        AdminProtos.RollWALWriterResponse response = this.rollWALWriterImpl(sn);
        int regionCount = response.getRegionToFlushCount();
        if (0 == regionCount) {
            return null;
        }
        byte[][] regionsToFlush = new byte[regionCount][];
        for (int i = 0; i < regionCount; ++i) {
            ByteString region = response.getRegionToFlush(i);
            regionsToFlush[i] = region.toByteArray();
        }
        return regionsToFlush;
    }

    @Override
    public synchronized void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.rollWALWriter(serverName);
            return;
        }
        this.rollWALWriterImpl(serverName);
    }

    @Override
    public String[] getMasterCoprocessors() {
        try {
            if (this.checkIfMapRDefault(true)) {
                return this.maprHBaseAdmin_.getMasterCoprocessors();
            }
            return this.getClusterStatus().getMasterCoprocessors();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not getClusterStatus()", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        AdminProtos.GetRegionInfoResponse.CompactionState state = AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        try (ZooKeeperWatcher zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.getConnection().toString(), new ThrowableAbortable());){
            this.checkTableExists(tableName);
            List<Pair<HRegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(zookeeper, this.getConnection(), tableName);
            Iterator<Pair<HRegionInfo, ServerName>> iterator = pairs.iterator();
            while (iterator.hasNext()) {
                Pair<HRegionInfo, ServerName> pair = iterator.next();
                if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                try {
                    ServerName sn = (ServerName)pair.getSecond();
                    AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
                    AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(((HRegionInfo)pair.getFirst()).getRegionName(), true);
                    AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
                    switch (response.getCompactionState()) {
                        case MAJOR_AND_MINOR: {
                            AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                            return compactionState;
                        }
                        case MAJOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MINOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR;
                            break;
                        }
                        case MINOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MINOR;
                            break;
                        }
                    }
                }
                catch (NotServingRegionException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                }
                catch (RemoteException e) {
                    if (e.getMessage().indexOf(NotServingRegionException.class.getName()) < 0) throw e;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            return state;
        }
    }

    @Override
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        }
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
            if (regionServerPair == null) {
                throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary((byte[])regionName));
            }
            if (regionServerPair.getSecond() == null) {
                throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            ServerName sn = (ServerName)regionServerPair.getSecond();
            AdminProtos.AdminService.BlockingInterface admin = this.getConnection().getAdmin(sn);
            AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(((HRegionInfo)regionServerPair.getFirst()).getRegionName(), true);
            HBaseRpcController controller = this.rpcControllerFactory.newController();
            AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo((RpcController)controller, request);
            return response.getCompactionState();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Deprecated
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCompactionState(Bytes.toBytes((String)tableNameOrRegionName));
    }

    @Deprecated
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        try {
            return this.getCompactionStateForRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException e) {
            return this.getCompactionState(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    @Override
    public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((String)tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), Bytes.toString((byte[])tableName), flushType);
    }

    @Override
    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), TableName.valueOf((byte[])tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    @Override
    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.snapshot(snapshotName, tableName, type);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        builder.setType(type);
        this.snapshot(builder.build());
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((String)tableName), type);
    }

    public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((byte[])tableName), type);
    }

    @Override
    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            this.maprHBaseAdmin_.snapshot(snapshot);
            return;
        }
        MasterProtos.SnapshotResponse response = this.takeSnapshotAsync(snapshot);
        final MasterProtos.IsSnapshotDoneRequest request = MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsSnapshotDoneResponse done = null;
        long start = EnvironmentEdgeManager.currentTime();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for snapshot '" + ClientSnapshotDescriptionUtils.toString(snapshot) + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug((Object)"Getting current status of snapshot from master...");
            done = this.executeCallable(new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection()){

                @Override
                public MasterProtos.IsSnapshotDoneResponse call(int callTimeout) throws ServiceException {
                    HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                    controller.setCallTimeout(callTimeout);
                    return this.master.isSnapshotDone(controller, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshot);
        }
    }

    @Override
    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            return this.maprHBaseAdmin_.takeSnapshotAsync(snapshot);
        }
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.SnapshotRequest request = MasterProtos.SnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.executeCallable(new MasterCallable<MasterProtos.SnapshotResponse>(this.getConnection()){

            @Override
            public MasterProtos.SnapshotResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.snapshot(controller, request);
            }
        });
    }

    @Override
    public boolean isSnapshotFinished(final HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            return this.maprHBaseAdmin_.isSnapshotFinished(snapshot);
        }
        return this.executeCallable(new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsSnapshotDoneResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.isSnapshotDone(controller, MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build());
            }
        }).getDone();
    }

    @Override
    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString((byte[])snapshotName));
    }

    @Override
    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        boolean takeFailSafeSnapshot = this.conf.getBoolean("hbase.snapshot.restore.take.failsafe.snapshot", false);
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    @Override
    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString((byte[])snapshotName), takeFailSafeSnapshot);
    }

    @Override
    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) throws IOException, RestoreSnapshotException {
        TableName tableName = null;
        for (HBaseProtos.SnapshotDescription snapshotInfo : this.listSnapshots()) {
            if (!snapshotInfo.getName().equals(snapshotName)) continue;
            tableName = TableName.valueOf((String)snapshotInfo.getTable());
            break;
        }
        if (tableName == null) {
            throw new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName);
        }
        if (this.checkIfMapRTable(tableName, true)) {
            throw new UnsupportedOperationException("restoreSnapshot called for a MapR Table.");
        }
        this.ensureConnectedToHBase();
        if (!this.tableExists(tableName)) {
            this.cloneSnapshot(snapshotName, tableName, restoreAcl);
            return;
        }
        if (!this.isTableDisabled(tableName)) {
            throw new TableNotDisabledException(tableName);
        }
        String failSafeSnapshotSnapshotName = null;
        if (takeFailSafeSnapshot) {
            failSafeSnapshotSnapshotName = this.conf.get("hbase.snapshot.restore.failsafe.name", "hbase-failsafe-{snapshot.name}-{restore.timestamp}");
            failSafeSnapshotSnapshotName = failSafeSnapshotSnapshotName.replace("{snapshot.name}", snapshotName).replace("{table.name}", tableName.toString().replace(':', '.')).replace("{restore.timestamp}", String.valueOf(EnvironmentEdgeManager.currentTime()));
            LOG.info((Object)("Taking restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
            this.snapshot(failSafeSnapshotSnapshotName, tableName);
        }
        try {
            this.internalRestoreSnapshot(snapshotName, tableName, restoreAcl);
        }
        catch (IOException e) {
            if (takeFailSafeSnapshot) {
                try {
                    this.internalRestoreSnapshot(failSafeSnapshotSnapshotName, tableName, restoreAcl);
                    String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + failSafeSnapshotSnapshotName + " succeeded.";
                    LOG.error((Object)msg, (Throwable)e);
                    throw new RestoreSnapshotException(msg, e);
                }
                catch (IOException ex) {
                    String msg = "Failed to restore and rollback to snapshot=" + failSafeSnapshotSnapshotName;
                    LOG.error((Object)msg, (Throwable)ex);
                    throw new RestoreSnapshotException(msg, e);
                }
            }
            throw new RestoreSnapshotException("Failed to restore snapshot=" + snapshotName, e);
        }
        if (takeFailSafeSnapshot) {
            try {
                LOG.info((Object)("Deleting restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
                this.deleteSnapshot(failSafeSnapshotSnapshotName);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to remove the failsafe snapshot: " + failSafeSnapshotSnapshotName), (Throwable)e);
            }
        }
    }

    @Override
    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot, false);
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), TableName.valueOf((byte[])tableName));
    }

    @Override
    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), tableName);
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(snapshotName, TableName.valueOf((String)tableName));
    }

    @Override
    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) throws IOException, TableExistsException, RestoreSnapshotException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.cloneSnapshot(snapshotName, tableName);
            return;
        }
        if (this.tableExists(tableName)) {
            throw new TableExistsException(tableName);
        }
        this.internalRestoreSnapshot(snapshotName, tableName, restoreAcl);
        this.waitUntilTableIsEnabled(tableName);
    }

    @Override
    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(snapshotName, tableName, false);
    }

    @Override
    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.execProcedureWithRet(signature, instance, props);
        }
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(builder.build()).build();
        MasterProtos.ExecProcedureResponse response = this.executeCallable(new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection()){

            @Override
            public MasterProtos.ExecProcedureResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.execProcedureWithRet(controller, request);
            }
        });
        return response.hasReturnData() ? response.getReturnData().toByteArray() : null;
    }

    @Override
    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.execProcedure(signature, instance, props);
            return;
        }
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(builder.build()).build();
        MasterProtos.ExecProcedureResponse response = this.executeCallable(new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection()){

            @Override
            public MasterProtos.ExecProcedureResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.execProcedure(controller, request);
            }
        });
        long start = EnvironmentEdgeManager.currentTime();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for procedure '" + signature + " : " + instance + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        boolean done = false;
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for procedure completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug((Object)"Getting current status of procedure from master...");
            done = this.isProcedureFinished(signature, instance, props);
        }
        if (!done) {
            throw new IOException("Procedure '" + signature + " : " + instance + "' wasn't completed in expectedTime:" + max + " ms");
        }
    }

    @Override
    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.isProcedureFinished(signature, instance, props);
        }
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        final HBaseProtos.ProcedureDescription desc = builder.build();
        return this.executeCallable(new MasterCallable<MasterProtos.IsProcedureDoneResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsProcedureDoneResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.isProcedureDone(controller, MasterProtos.IsProcedureDoneRequest.newBuilder().setProcedure(desc).build());
            }
        }).getDone();
    }

    private void internalRestoreSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) throws IOException, RestoreSnapshotException {
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName.getNameAsString()).build();
        this.internalRestoreSnapshotAsync(snapshot, restoreAcl);
        final MasterProtos.IsRestoreSnapshotDoneRequest request = MasterProtos.IsRestoreSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsRestoreSnapshotDoneResponse done = MasterProtos.IsRestoreSnapshotDoneResponse.newBuilder().setDone(false).buildPartial();
        long maxPauseTime = 5000L;
        int tries = 0;
        while (!done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > 5000L ? 5000L : sleep;
                LOG.debug((Object)(tries + ") Sleeping: " + sleep + " ms while we wait for snapshot restore to complete."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug((Object)"Getting current status of snapshot restore from master...");
            done = this.executeCallable(new MasterCallable<MasterProtos.IsRestoreSnapshotDoneResponse>(this.getConnection()){

                @Override
                public MasterProtos.IsRestoreSnapshotDoneResponse call(int callTimeout) throws ServiceException {
                    HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                    controller.setCallTimeout(callTimeout);
                    return this.master.isRestoreSnapshotDone(controller, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new RestoreSnapshotException("Snapshot '" + snapshot.getName() + "' wasn't restored.");
        }
    }

    private MasterProtos.RestoreSnapshotResponse internalRestoreSnapshotAsync(HBaseProtos.SnapshotDescription snapshot, boolean restoreAcl) throws IOException, RestoreSnapshotException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.RestoreSnapshotRequest request = MasterProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).setRestoreACL(restoreAcl).build();
        return this.executeCallable(new MasterCallable<MasterProtos.RestoreSnapshotResponse>(this.getConnection()){

            @Override
            public MasterProtos.RestoreSnapshotResponse call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.restoreSnapshot(controller, request);
            }
        });
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.listSnapshots();
        }
        return this.executeCallable(new MasterCallable<List<HBaseProtos.SnapshotDescription>>(this.getConnection()){

            @Override
            public List<HBaseProtos.SnapshotDescription> call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                return this.master.getCompletedSnapshots(controller, MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build()).getSnapshotsList();
            }
        });
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.listSnapshots(pattern);
        }
        LinkedList<HBaseProtos.SnapshotDescription> matched = new LinkedList<HBaseProtos.SnapshotDescription>();
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots();
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            if (!pattern.matcher(snapshot.getName()).matches()) continue;
            matched.add(snapshot);
        }
        return matched;
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        return this.listTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        TableName[] tableNames = this.listTableNames(tableNamePattern);
        LinkedList<HBaseProtos.SnapshotDescription> tableSnapshots = new LinkedList<HBaseProtos.SnapshotDescription>();
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots(snapshotNamePattern);
        List<TableName> listOfTableNames = Arrays.asList(tableNames);
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            if (!listOfTableNames.contains(TableName.valueOf((String)snapshot.getTable()))) continue;
            tableSnapshots.add(snapshot);
        }
        return tableSnapshots;
    }

    @Override
    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.deleteSnapshot(Bytes.toString((byte[])snapshotName));
    }

    @Override
    public void deleteSnapshot(final String snapshotName) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.deleteSnapshot(snapshotName);
            return;
        }
        TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)snapshotName));
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                this.master.deleteSnapshot(controller, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build()).build());
                return null;
            }
        });
    }

    @Override
    public void deleteSnapshots(String regex) throws IOException {
        this.deleteSnapshots(Pattern.compile(regex));
    }

    @Override
    public void deleteSnapshots(Pattern pattern) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.deleteSnapshots(pattern);
            return;
        }
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots(pattern);
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            try {
                this.internalDeleteSnapshot(snapshot);
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to delete snapshot " + snapshot.getName() + " for table " + snapshot.getTable()), (Throwable)ex);
            }
        }
    }

    private void internalDeleteSnapshot(final HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                this.master.deleteSnapshot(controller, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build());
                return null;
            }
        });
    }

    @Override
    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        this.deleteTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    @Override
    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("deleteTableSnapshots is not supported for MapR.");
        }
        List<HBaseProtos.SnapshotDescription> snapshots = this.listTableSnapshots(tableNamePattern, snapshotNamePattern);
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            try {
                this.internalDeleteSnapshot(snapshot);
                LOG.debug((Object)("Successfully deleted snapshot: " + snapshot.getName()));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to delete snapshot: " + snapshot.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void setQuota(final QuotaSettings quota) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("setQuota is not supported for MapR.");
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                this.master.setQuota(controller, QuotaSettings.buildSetQuotaRequestProto(quota));
                return null;
            }
        });
    }

    @Override
    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.getQuotaRetriever(filter);
        }
        return QuotaRetriever.open(this.conf, filter);
    }

    private <V> V executeCallable(MasterCallable<V> callable) throws IOException {
        return HBaseAdmin.executeCallable(callable, this.rpcCallerFactory, this.operationTimeout, this.rpcTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V executeCallable(MasterCallable<V> callable, RpcRetryingCallerFactory rpcCallerFactory, int operationTimeout, int rpcTimeout) throws IOException {
        RpcRetryingCaller<V> caller = rpcCallerFactory.newCaller(rpcTimeout);
        try {
            Object t = caller.callWithRetries(callable, operationTimeout);
            return (V)t;
        }
        finally {
            callable.close();
        }
    }

    @Override
    public CoprocessorRpcChannel coprocessorService() {
        if (this.isMapRDefault()) {
            return this.maprHBaseAdmin_.coprocessorService();
        }
        return new MasterCoprocessorRpcChannel(this.getClusterConnection());
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(ServerName sn) {
        if (this.isMapRDefault()) {
            return this.maprHBaseAdmin_.coprocessorService(sn);
        }
        return new RegionServerCoprocessorRpcChannel((ClusterConnection)this.getConnection(), sn);
    }

    @Override
    public void updateConfiguration(ServerName server) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.updateConfiguration(server);
            return;
        }
        try {
            this.getConnection().getAdmin(server).updateConfiguration(null, AdminProtos.UpdateConfigurationRequest.getDefaultInstance());
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
    }

    @Override
    public void updateConfiguration() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.maprHBaseAdmin_.updateConfiguration();
            return;
        }
        for (ServerName server : this.getClusterStatus().getServers()) {
            this.updateConfiguration(server);
        }
        this.updateConfiguration(this.getClusterStatus().getMaster());
        for (ServerName server : this.getClusterStatus().getBackupMasters()) {
            this.updateConfiguration(server);
        }
    }

    @Override
    public int getMasterInfoPort() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.getMasterInfoPort();
        }
        ConnectionManager.HConnectionImplementation connection = (ConnectionManager.HConnectionImplementation)this.connection;
        ZooKeeperKeepAliveConnection zkw = connection.getKeepAliveZooKeeperWatcher();
        try {
            return MasterAddressTracker.getMasterInfoPort(zkw);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to get master info port from MasterAddressTracker", e);
        }
    }

    @Override
    public long getLastMajorCompactionTimestamp(final TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return 0L;
        }
        return this.executeCallable(new MasterCallable<Long>(this.getConnection()){

            @Override
            public Long call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.MajorCompactionTimestampRequest req = MasterProtos.MajorCompactionTimestampRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
                return this.master.getLastMajorCompactionTimestamp(controller, req).getCompactionTimestamp();
            }
        });
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(final byte[] regionName) throws IOException {
        if (this.checkIfMapRTable(HRegionInfo.getTable(regionName), true)) {
            return this.maprHBaseAdmin_.getLastMajorCompactionTimestampForRegion(regionName);
        }
        return this.executeCallable(new MasterCallable<Long>(this.getConnection()){

            @Override
            public Long call(int callTimeout) throws ServiceException {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                controller.setCallTimeout(callTimeout);
                MasterProtos.MajorCompactionTimestampForRegionRequest req = MasterProtos.MajorCompactionTimestampForRegionRequest.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).build();
                return this.master.getLastMajorCompactionTimestampForRegion(controller, req).getCompactionTimestamp();
            }
        });
    }

    @Override
    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("getSecurityCapabilities is not supported for MapR.");
        }
        try {
            return this.executeCallable(new MasterCallable<List<SecurityCapability>>(this.getConnection()){

                @Override
                public List<SecurityCapability> call(int callTimeout) throws ServiceException {
                    HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                    controller.setCallTimeout(callTimeout);
                    MasterProtos.SecurityCapabilitiesRequest req = MasterProtos.SecurityCapabilitiesRequest.newBuilder().build();
                    return ProtobufUtil.toSecurityCapabilityList(this.master.getSecurityCapabilities(controller, req).getCapabilitiesList());
                }
            });
        }
        catch (IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)((Object)e)).unwrapRemoteException();
            }
            throw e;
        }
    }

    @Override
    public boolean[] setSplitOrMergeEnabled(final boolean enabled, final boolean synchronous, final Admin.MasterSwitchType ... switchTypes) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("setSplitOrMergeEnabled is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<boolean[]>(this.getConnection()){

            @Override
            public boolean[] call(int callTimeout) throws ServiceException {
                MasterProtos.SetSplitOrMergeEnabledResponse response = this.master.setSplitOrMergeEnabled(null, RequestConverter.buildSetSplitOrMergeEnabledRequest(enabled, synchronous, switchTypes));
                boolean[] result = new boolean[switchTypes.length];
                int i = 0;
                for (Boolean prevValue : response.getPrevValueList()) {
                    result[i++] = prevValue;
                }
                return result;
            }
        });
    }

    @Override
    public boolean isSplitOrMergeEnabled(final Admin.MasterSwitchType switchType) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("isSplitOrMergeEnabled is not supported for MapR.");
        }
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.isSplitOrMergeEnabled(null, RequestConverter.buildIsSplitOrMergeEnabledRequest(switchType)).getEnabled();
            }
        });
    }

    @Override
    public List<ServerName> listDeadServers() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("listDeadServers is not supported for MapR.");
        }
        return new ArrayList<ServerName>(this.getClusterStatus().getDeadServerNames());
    }

    @Override
    public List<ServerName> clearDeadServers(final List<ServerName> servers) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("clearDeadServers is not supported for MapR.");
        }
        if (servers == null || servers.size() == 0) {
            throw new IllegalArgumentException("servers cannot be null or empty");
        }
        return this.executeCallable(new MasterCallable<List<ServerName>>(this.getConnection()){

            @Override
            public List<ServerName> call(int callTimeout) throws Exception {
                MasterProtos.ClearDeadServersRequest req = RequestConverter.buildClearDeadServersRequest(servers);
                return ProtobufUtil.toServerNameList(this.master.clearDeadServers(null, req).getServerNameList());
            }
        });
    }

    private RpcControllerFactory getRpcControllerFactory() {
        return this.rpcControllerFactory;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected static class ProcedureFuture<V>
    implements Future<V> {
        private ExecutionException exception = null;
        private boolean procResultFound = false;
        private boolean done = false;
        private boolean cancelled = false;
        private boolean waitForOpResult = false;
        private V result = null;
        private final HBaseAdmin admin;
        private final Long procId;

        public ProcedureFuture(HBaseAdmin admin, Long procId) {
            this.admin = admin;
            this.procId = procId;
        }

        public ProcedureFuture(HBaseAdmin admin, Long procId, boolean waitForOpResult) {
            this.admin = admin;
            this.procId = procId;
            this.waitForOpResult = waitForOpResult;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            MasterProtos.AbortProcedureRequest abortProcRequest = MasterProtos.AbortProcedureRequest.newBuilder().setProcId(this.procId.longValue()).setMayInterruptIfRunning(mayInterruptIfRunning).build();
            try {
                this.cancelled = this.abortProcedureResult(abortProcRequest).getIsProcedureAborted();
                if (this.cancelled) {
                    this.done = true;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Cancelling the procedure with procId=" + this.procId + " throws exception " + e.getMessage()), (Throwable)e);
                this.cancelled = false;
            }
            return this.cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        protected MasterProtos.AbortProcedureResponse abortProcedureResult(final MasterProtos.AbortProcedureRequest request) throws IOException {
            return this.admin.executeCallable(new MasterCallable<MasterProtos.AbortProcedureResponse>(this.admin.getConnection()){

                @Override
                public MasterProtos.AbortProcedureResponse call(int callTimeout) throws ServiceException {
                    HBaseRpcController controller = admin.getRpcControllerFactory().newController();
                    controller.setCallTimeout(callTimeout);
                    return this.master.abortProcedure(controller, request);
                }
            });
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.done) {
                long deadlineTs = EnvironmentEdgeManager.currentTime() + unit.toMillis(timeout);
                try {
                    try {
                        if (this.procId != null) {
                            this.result = this.waitProcedureResult(this.procId, deadlineTs);
                        }
                        if (!this.procResultFound || this.waitForOpResult) {
                            this.result = this.waitOperationResult(deadlineTs);
                        }
                        this.result = this.postOperationResult(this.result, deadlineTs);
                        this.done = true;
                    }
                    catch (IOException e) {
                        this.result = this.postOpeartionFailure(e, deadlineTs);
                        this.done = true;
                    }
                }
                catch (IOException e) {
                    this.exception = new ExecutionException(e);
                    this.done = true;
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        protected HBaseAdmin getAdmin() {
            return this.admin;
        }

        private V waitProcedureResult(long procId, long deadlineTs) throws IOException, TimeoutException, InterruptedException {
            MasterProtos.GetProcedureResultRequest request = MasterProtos.GetProcedureResultRequest.newBuilder().setProcId(procId).build();
            int tries = 0;
            IOException serviceEx = null;
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                MasterProtos.GetProcedureResultResponse response;
                block7: {
                    response = null;
                    try {
                        response = this.getProcedureResult(request);
                    }
                    catch (IOException e) {
                        serviceEx = ProcedureFuture.unwrapException(e);
                        LOG.warn((Object)("failed to get the procedure result procId=" + procId), (Throwable)serviceEx);
                        if (!(serviceEx instanceof DoNotRetryIOException) && !(serviceEx instanceof NeedUnmanagedConnectionException)) break block7;
                        LOG.warn((Object)("Proc-v2 is unsupported on this master: " + serviceEx.getMessage()), (Throwable)serviceEx);
                        this.procResultFound = false;
                        this.waitForOpResult = false;
                        return null;
                    }
                }
                if (response != null && response.getState() != MasterProtos.GetProcedureResultResponse.State.RUNNING) {
                    this.procResultFound = response.getState() != MasterProtos.GetProcedureResultResponse.State.NOT_FOUND;
                    return this.convertResult(response);
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    throw new InterruptedException("Interrupted while waiting for the result of proc " + procId);
                }
            }
            if (serviceEx != null) {
                throw serviceEx;
            }
            throw new TimeoutException("The procedure " + procId + " is still running");
        }

        private static IOException unwrapException(IOException e) {
            if (e instanceof RemoteException) {
                return ((RemoteException)e).unwrapRemoteException();
            }
            return e;
        }

        protected MasterProtos.GetProcedureResultResponse getProcedureResult(final MasterProtos.GetProcedureResultRequest request) throws IOException {
            return this.admin.executeCallable(new MasterCallable<MasterProtos.GetProcedureResultResponse>(this.admin.getConnection()){

                @Override
                public MasterProtos.GetProcedureResultResponse call(int callTimeout) throws ServiceException {
                    return this.master.getProcedureResult(null, request);
                }
            });
        }

        protected V convertResult(MasterProtos.GetProcedureResultResponse response) throws IOException {
            if (response.hasException()) {
                throw ForeignExceptionUtil.toIOException((ErrorHandlingProtos.ForeignExceptionMessage)response.getException());
            }
            return null;
        }

        protected V waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            return null;
        }

        protected V postOperationResult(V result, long deadlineTs) throws IOException, TimeoutException {
            return result;
        }

        protected V postOpeartionFailure(IOException exception, long deadlineTs) throws IOException, TimeoutException {
            throw exception;
        }

        protected void waitForState(long deadlineTs, WaitForStateCallable callable) throws IOException, TimeoutException {
            int tries = 0;
            IOException serverEx = null;
            long startTime = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                serverEx = null;
                try {
                    if (callable.checkState(tries)) {
                        return;
                    }
                }
                catch (IOException e) {
                    serverEx = e;
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    callable.throwInterruptedException();
                }
            }
            if (serverEx != null) {
                throw ProcedureFuture.unwrapException(serverEx);
            }
            callable.throwTimeoutException(EnvironmentEdgeManager.currentTime() - startTime);
        }

        protected static interface WaitForStateCallable {
            public boolean checkState(int var1) throws IOException;

            public void throwInterruptedException() throws InterruptedIOException;

            public void throwTimeoutException(long var1) throws TimeoutException;
        }
    }

    private static class ThrowableAbortable
    implements Abortable {
        private ThrowableAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            throw new RuntimeException(why, e);
        }

        @Override
        public boolean isAborted() {
            return true;
        }
    }

    private static class DisableTableFuture
    extends ProcedureFuture<Void> {
        private final TableName tableName;

        public DisableTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DisableTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.tableName = tableName;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableDisabled(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info((Object)("Disabled " + this.tableName));
            return result;
        }

        private void waitTableDisabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return this.getAdmin().isTableDisabled(tableName);
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table to be disabled");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + tableName + " not yet disabled after " + elapsedTime + "msec");
                }
            });
        }
    }

    private static class EnableTableFuture
    extends ProcedureFuture<Void> {
        private final TableName tableName;

        public EnableTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.EnableTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null, true);
            this.tableName = tableName;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableEnabled(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info((Object)("Enabled " + this.tableName));
            return result;
        }

        private void waitTableEnabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    boolean enabled;
                    try {
                        enabled = this.getAdmin().isTableEnabled(tableName);
                    }
                    catch (TableNotFoundException tnfe) {
                        return false;
                    }
                    return enabled && this.getAdmin().isTableAvailable(tableName);
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table to be enabled");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + tableName + " not yet enabled after " + elapsedTime + "msec");
                }
            });
        }
    }

    private static class DeleteTableFuture
    extends ProcedureFuture<Void> {
        private final TableName tableName;

        public DeleteTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DeleteTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.tableName = tableName;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableNotFound(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            this.getAdmin().getConnection().clearRegionCache(this.tableName);
            LOG.info((Object)("Deleted " + this.tableName));
            return result;
        }

        private void waitTableNotFound(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return !this.getAdmin().tableExists(tableName);
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table to be deleted");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + tableName + " not yet deleted after " + elapsedTime + "msec");
                }
            });
        }
    }

    private static class CreateTableFuture
    extends ProcedureFuture<Void> {
        private final HTableDescriptor desc;
        private final byte[][] splitKeys;

        public CreateTableFuture(HBaseAdmin admin, HTableDescriptor desc, byte[][] splitKeys, MasterProtos.CreateTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null, true);
            this.splitKeys = splitKeys;
            this.desc = desc;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitForTableEnabled(deadlineTs);
            this.waitForAllRegionsOnline(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info((Object)("Created " + this.desc.getTableName()));
            return result;
        }

        private void waitForTableEnabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    try {
                        if (this.getAdmin().isTableAvailable(desc.getTableName())) {
                            return true;
                        }
                    }
                    catch (TableNotFoundException tnfe) {
                        LOG.debug((Object)("Table " + desc.getTableName() + " was not enabled, sleeping. tries=" + tries));
                    }
                    return false;
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table " + desc.getTableName() + " to be enabled");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + desc.getTableName() + " not enabled after " + elapsedTime + "msec");
                }
            });
        }

        private void waitForAllRegionsOnline(long deadlineTs) throws IOException, TimeoutException {
            final AtomicInteger actualRegCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result rowResult) throws IOException {
                    HRegionLocation[] locations;
                    RegionLocations list = MetaTableAccessor.getRegionLocations(rowResult);
                    if (list == null) {
                        LOG.warn((Object)("No serialized HRegionInfo in " + rowResult));
                        return true;
                    }
                    HRegionLocation l = list.getRegionLocation();
                    if (l == null) {
                        return true;
                    }
                    if (!l.getRegionInfo().getTable().equals((Object)desc.getTableName())) {
                        return false;
                    }
                    if (l.getRegionInfo().isOffline() || l.getRegionInfo().isSplit()) {
                        return true;
                    }
                    for (HRegionLocation location : locations = list.getRegionLocations()) {
                        ServerName serverName;
                        if (location == null || (serverName = location.getServerName()) == null || serverName.getHostAndPort() == null) continue;
                        actualRegCount.incrementAndGet();
                    }
                    return true;
                }
            };
            int tries = 0;
            Object serverEx = null;
            int numRegs = (this.splitKeys == null ? 1 : this.splitKeys.length + 1) * this.desc.getRegionReplication();
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                actualRegCount.set(0);
                MetaScanner.metaScan(this.getAdmin().getConnection(), visitor, this.desc.getTableName());
                if (actualRegCount.get() == numRegs) {
                    return;
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                }
            }
            throw new TimeoutException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
        }
    }

    private static class AbortProcedureFuture
    extends ProcedureFuture<Boolean> {
        private boolean isAbortInProgress;

        public AbortProcedureFuture(HBaseAdmin admin, Long procId, Boolean abortProcResponse) {
            super(admin, procId);
            this.isAbortInProgress = abortProcResponse;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.isAbortInProgress) {
                return false;
            }
            super.get(timeout, unit);
            return true;
        }
    }

    abstract class HBaseConnector {
        HBaseConnector() {
        }

        abstract void connect() throws ZooKeeperConnectionException, MasterNotRunningException, IOException;
    }
}

