/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUrlStreamHandler {
    private static final File TEST_ROOT_DIR = PathUtils.getTestDir(TestUrlStreamHandler.class);
    private static final FsUrlStreamHandlerFactory HANDLER_FACTORY = new FsUrlStreamHandlerFactory();

    @BeforeClass
    public static void setupHandler() {
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)HANDLER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDfsUrls() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path filePath = new Path("/thefile");
        try {
            byte[] fileContent = new byte[1024];
            for (int i = 0; i < fileContent.length; ++i) {
                fileContent[i] = (byte)i;
            }
            FSDataOutputStream os = fs.create(filePath);
            os.write(fileContent);
            os.close();
            URI uri = fs.getUri();
            URL fileURL = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), filePath.toString());
            InputStream is = fileURL.openStream();
            Assert.assertNotNull((Object)is);
            byte[] bytes = new byte[4096];
            Assert.assertEquals((long)1024L, (long)is.read(bytes));
            is.close();
            for (int i = 0; i < fileContent.length; ++i) {
                Assert.assertEquals((long)fileContent[i], (long)bytes[i]);
            }
            fs.delete(filePath, false);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUrls() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (!TEST_ROOT_DIR.exists() && !TEST_ROOT_DIR.mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + TEST_ROOT_DIR);
        }
        File tmpFile = new File(TEST_ROOT_DIR, "thefile");
        URI uri = tmpFile.toURI();
        try (FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);){
            byte[] fileContent = new byte[1024];
            for (int i = 0; i < fileContent.length; ++i) {
                fileContent[i] = (byte)i;
            }
            FSDataOutputStream os = fs.create(new Path(uri.getPath()));
            os.write(fileContent);
            os.close();
            URL fileURL = uri.toURL();
            InputStream is = fileURL.openStream();
            Assert.assertNotNull((Object)is);
            byte[] bytes = new byte[4096];
            Assert.assertEquals((long)1024L, (long)is.read(bytes));
            is.close();
            for (int i = 0; i < fileContent.length; ++i) {
                Assert.assertEquals((long)fileContent[i], (long)bytes[i]);
            }
            fs.delete(new Path(uri.getPath()), false);
        }
    }

    @Test
    public void testHttpDefaultHandler() throws Throwable {
        Assert.assertNull((String)"Handler for HTTP is the Hadoop one", (Object)HANDLER_FACTORY.createURLStreamHandler("http"));
    }

    @Test
    public void testHttpsDefaultHandler() throws Throwable {
        Assert.assertNull((String)"Handler for HTTPS is the Hadoop one", (Object)HANDLER_FACTORY.createURLStreamHandler("https"));
    }

    @Test
    public void testUnknownProtocol() throws Throwable {
        Assert.assertNull((String)"Unknown protocols are not handled", (Object)HANDLER_FACTORY.createURLStreamHandler("gopher"));
    }
}

