/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import java.io.Serializable;
import java.util.Formatter;
import java.util.List;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.inject.internal.ErrorId;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalErrorDetail;
import org.apache.hadoop.shaded.com.google.inject.internal.SourceFormatter;
import org.apache.hadoop.shaded.com.google.inject.spi.ErrorDetail;

public final class GenericErrorDetail
extends InternalErrorDetail<GenericErrorDetail>
implements Serializable {
    public GenericErrorDetail(ErrorId errorId, String message, List<Object> sources, Throwable cause) {
        super(errorId, (String)Preconditions.checkNotNull((Object)message, (Object)"message"), sources, cause);
    }

    @Override
    public void formatDetail(List<ErrorDetail<?>> mergeableErrors, Formatter formatter) {
        Preconditions.checkArgument((boolean)mergeableErrors.isEmpty(), (Object)"Unexpected mergeable errors");
        List<Object> dependencies = this.getSources();
        for (Object source : Lists.reverse(dependencies)) {
            formatter.format("  ", new Object[0]);
            new SourceFormatter(source, formatter, false).format();
        }
    }

    @Override
    public GenericErrorDetail withSources(List<Object> newSources) {
        return new GenericErrorDetail(this.errorId, this.getMessage(), newSources, this.getCause());
    }
}

