/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSecureEncryptionZoneWithKMS {
    public static final Logger LOG = LoggerFactory.getLogger(TestSecureEncryptionZoneWithKMS.class);
    private static final Path TEST_PATH = new Path("/test-dir");
    private static HdfsConfiguration baseConf;
    private static File baseDir;
    private static String keystoresDir;
    private static String sslConfDir;
    private static final EnumSet<CreateEncryptionZoneFlag> NO_TRASH;
    private static final String HDFS_USER_NAME = "hdfs";
    private static final String SPNEGO_USER_NAME = "HTTP";
    private static final String OOZIE_USER_NAME = "oozie";
    private static final String OOZIE_PROXIED_USER_NAME = "oozie_user";
    private static String hdfsPrincipal;
    private static String spnegoPrincipal;
    private static String ooziePrincipal;
    private static String keytab;
    private static MiniKdc kdc;
    private static MiniKMS miniKMS;
    private final String testKey = "test_key";
    private static boolean testKeyCreated;
    private static final long AUTH_TOKEN_VALIDITY = 1L;
    private MiniDFSCluster cluster;
    private HdfsConfiguration conf;
    private FileSystem fs;
    private HdfsAdmin dfsAdmin;
    private FileSystemTestWrapper fsWrapper;
    @Rule
    public Timeout timeout = new Timeout(120000);

    public static File getTestDir() throws Exception {
        File file = new File("dummy");
        file = file.getAbsoluteFile();
        file = file.getParentFile();
        file = new File(file, "target");
        if (!(file = new File(file, UUID.randomUUID().toString())).mkdirs()) {
            throw new RuntimeException("Could not create test directory: " + file);
        }
        return file;
    }

    @BeforeClass
    public static void init() throws Exception {
        baseDir = TestSecureEncryptionZoneWithKMS.getTestDir();
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        baseConf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)baseConf);
        UserGroupInformation.setConfiguration((Configuration)baseConf);
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        File keytabFile = new File(baseDir, "test.keytab");
        keytab = keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        kdc.createPrincipal(keytabFile, new String[]{"hdfs/" + krbInstance, "HTTP/" + krbInstance, "oozie/" + krbInstance, "oozie_user/" + krbInstance});
        hdfsPrincipal = "hdfs/" + krbInstance + "@" + kdc.getRealm();
        spnegoPrincipal = "HTTP/" + krbInstance + "@" + kdc.getRealm();
        ooziePrincipal = "oozie/" + krbInstance + "@" + kdc.getRealm();
        baseConf.set("hadoop.proxyuser.oozie.hosts", "*");
        baseConf.set("hadoop.proxyuser.oozie.groups", "*");
        baseConf.set("hadoop.user.group.static.mapping.overrides", "oozie_user=oozie");
        baseConf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        baseConf.set("dfs.namenode.keytab.file", keytab);
        baseConf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        baseConf.set("dfs.datanode.keytab.file", keytab);
        baseConf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        baseConf.setBoolean("dfs.block.access.token.enable", true);
        baseConf.set("dfs.data.transfer.protection", "authentication");
        baseConf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        baseConf.set("dfs.namenode.https-address", "localhost:0");
        baseConf.set("dfs.datanode.https.address", "localhost:0");
        baseConf.set("dfs.journalnode.https-address", "localhost:0");
        baseConf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        baseConf.set("hadoop.security.kms.client.encrypted.key.cache.size", "4");
        baseConf.set("hadoop.security.kms.client.encrypted.key.cache.low-watermark", "0.5");
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSecureEncryptionZoneWithKMS.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)baseConf, (boolean)false);
        baseConf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        baseConf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        File kmsFile = new File(baseDir, "kms-site.xml");
        if (kmsFile.exists()) {
            FileUtil.fullyDelete((File)kmsFile);
        }
        Configuration kmsConf = new Configuration(true);
        kmsConf.set("hadoop.kms.key.provider.uri", "jceks://file@" + new Path(baseDir.toString(), "kms.keystore").toUri());
        kmsConf.set("hadoop.kms.authentication.type", "kerberos");
        kmsConf.set("hadoop.kms.authentication.kerberos.keytab", keytab);
        kmsConf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        kmsConf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        kmsConf.set("hadoop.kms.acl.GENERATE_EEK", HDFS_USER_NAME);
        kmsConf.setLong("hadoop.kms.authentication.token.validity", 1L);
        FileWriter writer = new FileWriter(kmsFile);
        kmsConf.writeXml((Writer)writer);
        ((Writer)writer).close();
        MiniKMS.Builder miniKMSBuilder = new MiniKMS.Builder();
        miniKMS = miniKMSBuilder.setKmsConfDir(baseDir).build();
        miniKMS.start();
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (kdc != null) {
            kdc.stop();
        }
        if (miniKMS != null) {
            miniKMS.stop();
        }
        FileUtil.fullyDelete((File)baseDir);
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Before
    public void setup() throws Exception {
        baseConf.set("hadoop.security.key.provider.path", this.getKeyProviderURI());
        baseConf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.conf = new HdfsConfiguration((Configuration)baseConf);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fsWrapper = new FileSystemTestWrapper(this.fs);
        this.dfsAdmin = new HdfsAdmin(this.cluster.getURI(), (Configuration)this.conf);
        this.cluster.waitActive();
        if (!testKeyCreated) {
            DFSTestUtil.createKey("test_key", this.cluster, (Configuration)this.conf);
            testKeyCreated = true;
        }
    }

    @After
    public void shutdown() throws IOException {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private String getKeyProviderURI() {
        return "kms://" + miniKMS.getKMSUrl().toExternalForm().replace("://", "@");
    }

    @Test
    public void testSecureEncryptionZoneWithKMS() throws IOException, InterruptedException {
        final Path zonePath = new Path(TEST_PATH, "TestEZ1");
        this.fsWrapper.mkdir(zonePath, FsPermission.getDirDefault(), true);
        this.fsWrapper.setOwner(zonePath, OOZIE_PROXIED_USER_NAME, "supergroup");
        this.dfsAdmin.createEncryptionZone(zonePath, "test_key", NO_TRASH);
        UserGroupInformation oozieUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)ooziePrincipal, (String)keytab);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUser((String)OOZIE_PROXIED_USER_NAME, (UserGroupInformation)oozieUgi);
        proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                Void void_;
                block9: {
                    DistributedFileSystem dfs = TestSecureEncryptionZoneWithKMS.this.cluster.getFileSystem();
                    try {
                        for (int i = 0; i < 3; ++i) {
                            Path filePath = new Path(zonePath, "testData." + i + ".dat");
                            DFSTestUtil.createFile((FileSystem)dfs, filePath, 1024L, (short)3, 1L);
                        }
                        void_ = null;
                        if (dfs == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (dfs != null) {
                                try {
                                    dfs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IOException(e);
                        }
                    }
                    dfs.close();
                }
                return void_;
            }
        });
    }

    @Test
    public void testCreateZoneAfterAuthTokenExpiry() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)hdfsPrincipal, (String)keytab);
        LOG.info("Created ugi: {} ", (Object)ugi);
        ugi.doAs(() -> {
            Path zone = new Path("/expire1");
            this.fsWrapper.mkdir(zone, FsPermission.getDirDefault(), true);
            this.dfsAdmin.createEncryptionZone(zone, "test_key", NO_TRASH);
            Path zone1 = new Path("/expire2");
            this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
            long sleepInterval = 2000L;
            LOG.info("Sleeping {} seconds to wait for kms auth token expiration", (Object)2000L);
            Thread.sleep(2000L);
            this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
            return null;
        });
    }

    static {
        NO_TRASH = EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH);
        testKeyCreated = false;
    }
}

