/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilter;
import org.assertj.core.api.Assertions;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.junit.Test;
import org.mockito.Mockito;

public class TestProxyUserAuthenticationFilter {
    private String actualUser;

    @Test(timeout=10000L)
    public void testFilter() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("proxyuser.knox.users", "testuser");
        params.put("proxyuser.knox.hosts", "127.0.0.1");
        params.put("type", "simple");
        DummyFilterConfig config = new DummyFilterConfig(params);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) {
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                TestProxyUserAuthenticationFilter.this.actualUser = request.getRemoteUser();
            }
        };
        ProxyUserAuthenticationFilter testFilter = new ProxyUserAuthenticationFilter();
        testFilter.init((FilterConfig)config);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"knox");
        Mockito.when((Object)request.getParameter("doas")).thenReturn((Object)"testuser");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "knox@EXAMPLE.COM";
            }
        });
        HttpServletResponseForTest response = new HttpServletResponseForTest();
        testFilter.doFilter(chain, request, (HttpServletResponse)response);
        Assertions.assertThat((String)this.actualUser).isEqualTo((Object)"testuser");
    }

    private class HttpServletResponseForTest
    extends HttpServletResponseImpl {
        private HttpServletResponseForTest() {
        }
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        private final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String param) {
            return this.map.get(param);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            return context;
        }
    }
}

