/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn.auth;

import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.utils.StringUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.cosn.auth.AbstractCOSCredentialsProvider;

public class EnvironmentVariableCredentialsProvider
extends AbstractCOSCredentialsProvider
implements COSCredentialsProvider {
    public EnvironmentVariableCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
    }

    public COSCredentials getCredentials() {
        String secretId = System.getenv("COSN_SECRET_ID");
        String secretKey = System.getenv("COSN_SECRET_KEY");
        secretId = StringUtils.trim((String)secretId);
        secretKey = StringUtils.trim((String)secretKey);
        if (!StringUtils.isNullOrEmpty((String)secretId) && !StringUtils.isNullOrEmpty((String)secretKey)) {
            return new BasicCOSCredentials(secretId, secretKey);
        }
        return null;
    }

    public void refresh() {
    }

    public String toString() {
        return String.format("EnvironmentVariableCredentialsProvider{%s, %s}", "COSN_SECRET_ID", "COSN_SECRET_KEY");
    }
}

