/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;
    private boolean isClosed;

    public ByteBufferInputStream(ByteBuffer byteBuffer) throws IOException {
        if (null == byteBuffer) {
            throw new IOException("byte buffer is null");
        }
        this.byteBuffer = byteBuffer;
        this.isClosed = false;
    }

    @Override
    public int read() throws IOException {
        if (null == this.byteBuffer) {
            throw new IOException("this byte buffer for InputStream is null");
        }
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (!this.markSupported()) {
            return;
        }
        this.byteBuffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed in InputStream");
        }
        try {
            this.byteBuffer.reset();
        }
        catch (InvalidMarkException e) {
            throw new IOException("Invalid mark");
        }
    }

    @Override
    public int available() {
        return this.byteBuffer.remaining();
    }

    @Override
    public void close() {
        this.byteBuffer.rewind();
        this.byteBuffer = null;
        this.isClosed = true;
    }
}

