/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.BaseMapRUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMVolumeShardingUtil {
    public static final Logger LOG = LoggerFactory.getLogger(RMVolumeShardingUtil.class);
    private static final String MAPR_INSTALL_DIR = BaseMapRUtil.getPathToMaprHome();
    private static final String MAPR_RM_VOLUME_SCRIPT_PATH = "/server/createRMVolume.sh";
    private static final String appIdStrPrefix = "application_";

    public static void rebalanceVolumes(String rebalanceDir, int volumeCount, boolean useVolumeSharding, String rmDir, FileSystem fs) throws Exception {
        Integer firstVolume;
        String centralDirPath;
        List rmDirAppIds;
        Object volumeAppIds;
        Path rebalancePath = new Path(rebalanceDir);
        Path rmDirPath = new Path(rmDir);
        String rmAppRootSuffix = rebalancePath.toString().substring(rmDirPath.toString().length());
        List rmVolumes = null;
        try {
            rmVolumes = Arrays.asList(fs.listStatus(rmDirPath)).stream().filter(volume -> volume.getPath().getName().matches("\\d+")).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOG.warn("Exception while try to rebalance volumes at " + rmDirPath, (Throwable)e);
        }
        if (rmVolumes == null || rmVolumes.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rebalance for rebalanceDir is called: " + rebalanceDir);
        }
        if (!rebalancePath.toUri().getRawPath().startsWith(rmDirPath.toUri().getRawPath())) {
            LOG.warn("rebalancePath " + rebalancePath.toUri().getRawPath() + " is not the part of rmDir: " + rmDirPath.toUri().getRawPath());
            return;
        }
        HashMap<Integer, Path> volumeToDirMap = new HashMap<Integer, Path>();
        long maxVolumeNumber = rmVolumes.size();
        int volumeNumber = 0;
        while ((long)volumeNumber < maxVolumeNumber) {
            volumeToDirMap.put(volumeNumber, new Path(rmDir + "/" + volumeNumber + rmAppRootSuffix));
            ++volumeNumber;
        }
        if (!useVolumeSharding) {
            for (Map.Entry entry : volumeToDirMap.entrySet()) {
                Integer oldVolume = (Integer)entry.getKey();
                volumeAppIds = Arrays.asList(fs.listStatus((Path)entry.getValue())).stream().filter(appIdEntry -> appIdEntry.getPath().getName().startsWith(appIdStrPrefix)).collect(Collectors.toList());
                Iterator iterator = volumeAppIds.iterator();
                while (iterator.hasNext()) {
                    FileStatus appId = (FileStatus)iterator.next();
                    fs.rename(appId.getPath(), new Path(appId.getPath().toString().replaceAll(rmDir + "/" + oldVolume, rmDir)));
                }
            }
        }
        if (useVolumeSharding && (rmDirAppIds = Arrays.asList(fs.listStatus(new Path(centralDirPath = ((Path)volumeToDirMap.get(firstVolume = Integer.valueOf(0))).toString().replaceAll(rmDir + "/" + firstVolume, rmDir)))).stream().filter(appIdEntry -> appIdEntry.getPath().getName().startsWith(appIdStrPrefix)).collect(Collectors.toList())).size() > 0) {
            for (FileStatus appId : rmDirAppIds) {
                Integer newVolume = Math.abs(appId.getPath().getName().hashCode() % volumeCount);
                fs.rename(appId.getPath(), new Path(appId.getPath().toString().replaceAll(rmDir, rmDir + "/" + newVolume)));
            }
        }
        HashMap volumeToAppIdMap = new HashMap();
        for (Map.Entry entry : volumeToDirMap.entrySet()) {
            volumeAppIds = Arrays.asList(fs.listStatus((Path)entry.getValue())).stream().filter(appIdEntry -> appIdEntry.getPath().getName().startsWith(appIdStrPrefix)).collect(Collectors.toList());
            volumeToAppIdMap.put((Integer)entry.getKey(), volumeAppIds);
        }
        for (Map.Entry entry : volumeToAppIdMap.entrySet()) {
            Integer oldVolume = (Integer)entry.getKey();
            List appIds = (List)entry.getValue();
            for (FileStatus appId : appIds) {
                Integer newVolume = Math.abs(appId.getPath().getName().hashCode() % volumeCount);
                if (newVolume.equals(oldVolume)) continue;
                fs.rename(appId.getPath(), new Path(appId.getPath().toString().replaceAll(rmDir + "/" + oldVolume, rmDir + "/" + newVolume)));
            }
        }
    }

    public static String getPathToVolumeCreateScript() {
        return MAPR_INSTALL_DIR + MAPR_RM_VOLUME_SCRIPT_PATH;
    }

    public static String getPathToVolumeLog() {
        return MAPR_INSTALL_DIR;
    }
}

