/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestViewFsTrash {
    FileSystem fsTarget;
    FileSystem fsView;
    Configuration conf;
    private FileSystemTestHelper fileSystemTestHelper;

    @Before
    public void setUp() throws Exception {
        Configuration targetFSConf = new Configuration();
        targetFSConf.setClass("fs.file.impl", TestTrash.TestLFS.class, FileSystem.class);
        this.fsTarget = FileSystem.getLocal((Configuration)targetFSConf);
        this.fileSystemTestHelper = new FileSystemTestHelper(this.fsTarget.getHomeDirectory().toUri().getPath());
        this.conf = ViewFileSystemTestSetup.createConfig();
        this.fsView = ViewFileSystemTestSetup.setupForViewFileSystem(this.conf, this.fileSystemTestHelper, this.fsTarget);
        this.conf.set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        this.conf.setClass("fs.file.impl", TestTrash.TestLFS.class, FileSystem.class);
    }

    @After
    public void tearDown() throws Exception {
        ViewFileSystemTestSetup.tearDown(this.fileSystemTestHelper, this.fsTarget);
        this.fsTarget.delete(new Path(this.fsTarget.getHomeDirectory(), ".Trash/Current"), true);
    }

    @Ignore
    public void testTrash() throws Exception {
        TestTrash.trashShell(this.conf, this.fileSystemTestHelper.getTestRootPath(this.fsView), this.fsView, new Path(this.fileSystemTestHelper.getTestRootPath(this.fsView), ".Trash/Current"));
    }

    @Test
    public void testLocalizedTrashInMoveToAppropriateTrash() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        Path testFile = new Path("/data/testfile.txt");
        conf2.setLong("fs.trash.interval", 1L);
        ConfigUtil.addLink((Configuration)conf2, (String)"/data", (URI)new Path(this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget), "data").toUri());
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", false);
        try (FileSystem fsView2 = FileSystem.get((Configuration)conf2);){
            FileSystemTestHelper.createFile(fsView2, testFile);
            Path resolvedFile = fsView2.resolvePath(testFile);
            Trash.moveToAppropriateTrash((FileSystem)fsView2, (Path)testFile, (Configuration)conf2);
            Trash trash = new Trash(this.fsTarget, conf2);
            Path movedPath = Path.mergePaths((Path)trash.getCurrentTrashDir(testFile), (Path)resolvedFile);
            ContractTestUtils.assertPathExists(this.fsTarget, "File not in trash", movedPath);
        }
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", true);
        fsView2 = FileSystem.get((Configuration)conf2);
        try {
            FileSystemTestHelper.createFile(fsView2, testFile);
            Trash.moveToAppropriateTrash((FileSystem)fsView2, (Path)testFile, (Configuration)conf2);
            Trash trash = new Trash(fsView2, conf2);
            Path movedPath = Path.mergePaths((Path)trash.getCurrentTrashDir(testFile), (Path)testFile);
            ContractTestUtils.assertPathExists(fsView2, "File not in localized trash", movedPath);
        }
        finally {
            if (fsView2 != null) {
                fsView2.close();
            }
        }
    }
}

