/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ftp.FTPFileSystem;
import org.apache.hadoop.fs.ftp.FtpTestServer;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Preconditions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestFTPFileSystem {
    private FtpTestServer server;
    private java.nio.file.Path testDir;
    @Rule
    public Timeout testTimeout = new Timeout(180000L, TimeUnit.MILLISECONDS);

    @Before
    public void setUp() throws Exception {
        this.testDir = Files.createTempDirectory(GenericTestUtils.getTestDir().toPath(), this.getClass().getName(), new FileAttribute[0]);
        this.server = new FtpTestServer(this.testDir).start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            Files.walk(this.testDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(java.nio.file.Path::toFile).forEach(File::delete);
        }
    }

    @Test
    public void testCreateWithWritePermissions() throws Exception {
        BaseUser user = this.server.addUser("test", "password", new Authority[]{new WritePermission()});
        Configuration configuration = new Configuration();
        configuration.set("fs.defaultFS", "ftp:///");
        configuration.set("fs.ftp.host", "localhost");
        configuration.setInt("fs.ftp.host.port", this.server.getPort());
        configuration.set("fs.ftp.user.localhost", user.getName());
        configuration.set("fs.ftp.password.localhost", user.getPassword());
        configuration.setBoolean("fs.ftp.impl.disable.cache", true);
        FileSystem fs = FileSystem.get((Configuration)configuration);
        byte[] bytesExpected = "hello world".getBytes(StandardCharsets.UTF_8);
        try (FSDataOutputStream outputStream = fs.create(new Path("test1.txt"));){
            outputStream.write(bytesExpected);
        }
        try (FSDataInputStream input = fs.open(new Path("test1.txt"));){
            MatcherAssert.assertThat((Object)bytesExpected, (Matcher)CoreMatchers.equalTo((Object)IOUtils.readFullyToByteArray((DataInput)input)));
        }
    }

    @Test
    public void testCreateWithoutWritePermissions() throws Exception {
        BaseUser user = this.server.addUser("test", "password", new Authority[0]);
        Configuration configuration = new Configuration();
        configuration.set("fs.defaultFS", "ftp:///");
        configuration.set("fs.ftp.host", "localhost");
        configuration.setInt("fs.ftp.host.port", this.server.getPort());
        configuration.set("fs.ftp.user.localhost", user.getName());
        configuration.set("fs.ftp.password.localhost", user.getPassword());
        configuration.setBoolean("fs.ftp.impl.disable.cache", true);
        FileSystem fs = FileSystem.get((Configuration)configuration);
        byte[] bytesExpected = "hello world".getBytes(StandardCharsets.UTF_8);
        LambdaTestUtils.intercept(IOException.class, "Unable to create file: test1.txt, Aborting", () -> {
            try (FSDataOutputStream out = fs.create(new Path("test1.txt"));){
                out.write(bytesExpected);
            }
        });
    }

    @Test
    public void testFTPDefaultPort() throws Exception {
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)21L, (long)ftp.getDefaultPort());
    }

    @Test
    public void testFTPTransferMode() throws Exception {
        Configuration conf = new Configuration();
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)11L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "STREAM_TRANSFER_MODE");
        Assert.assertEquals((long)10L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "COMPRESSED_TRANSFER_MODE");
        Assert.assertEquals((long)12L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "invalid");
        Assert.assertEquals((long)11L, (long)ftp.getTransferMode(conf));
    }

    @Test
    public void testFTPDataConnectionMode() throws Exception {
        Configuration conf = new Configuration();
        FTPClient client = new FTPClient();
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        conf.set("fs.ftp.data.connection.mode", "invalid");
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        conf.set("fs.ftp.data.connection.mode", "PASSIVE_LOCAL_DATA_CONNECTION_MODE");
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)2L, (long)client.getDataConnectionMode());
    }

    @Test
    public void testGetFsAction() {
        FTPFileSystem ftp = new FTPFileSystem();
        int[] accesses = new int[]{0, 1, 2};
        FsAction[] actions = FsAction.values();
        for (int i = 0; i < accesses.length; ++i) {
            for (int j = 0; j < actions.length; ++j) {
                this.enhancedAssertEquals(actions[j], ftp.getFsAction(accesses[i], this.getFTPFileOf(accesses[i], actions[j])));
            }
        }
    }

    private void enhancedAssertEquals(FsAction actionA, FsAction actionB) {
        String notNullErrorMessage = "FsAction cannot be null here.";
        Preconditions.checkNotNull((Object)actionA, (Object)notNullErrorMessage);
        Preconditions.checkNotNull((Object)actionB, (Object)notNullErrorMessage);
        String errorMessageFormat = "expect FsAction is %s, whereas it is %s now.";
        String notEqualErrorMessage = String.format(errorMessageFormat, actionA.name(), actionB.name());
        Assert.assertEquals((String)notEqualErrorMessage, (Object)actionA, (Object)actionB);
    }

    private FTPFile getFTPFileOf(int access, FsAction action) {
        boolean check = access == 0 || access == 1 || access == 2;
        String errorFormat = "access must be in [%d,%d,%d], but it is %d now.";
        String errorMessage = String.format(errorFormat, 0, 1, 2, access);
        Preconditions.checkArgument((boolean)check, (Object)errorMessage);
        Preconditions.checkNotNull((Object)action);
        FTPFile ftpFile = new FTPFile();
        if (action.implies(FsAction.READ)) {
            ftpFile.setPermission(access, 0, true);
        }
        if (action.implies(FsAction.WRITE)) {
            ftpFile.setPermission(access, 1, true);
        }
        if (action.implies(FsAction.EXECUTE)) {
            ftpFile.setPermission(access, 2, true);
        }
        return ftpFile;
    }

    @Test
    public void testFTPSetTimeout() {
        Configuration conf = new Configuration();
        FTPClient client = new FTPClient();
        FTPFileSystem ftp = new FTPFileSystem();
        ftp.setTimeout(client, conf);
        Assert.assertEquals((long)client.getControlKeepAliveTimeout(), (long)0L);
        long timeout = 600L;
        conf.setLong("fs.ftp.timeout", timeout);
        ftp.setTimeout(client, conf);
        Assert.assertEquals((long)client.getControlKeepAliveTimeout(), (long)timeout);
    }
}

