/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.http;

import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Hadoop error handler for Jetty server that disables all sensitive information for clients
 * */
public class HadoopHttpServerErrorHandler extends ErrorHandler {

  @Override
  public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response)
      throws IOException {
    response.setContentType("text/html;charset=utf-8");
    String errorMsg = "URI: %s HTTP ERROR: %d";
    if (baseRequest.getResponse().getReason() == null){
      response.getWriter().write(String.format(errorMsg, request.getRequestURI(), response.getStatus()));
    } else {
      response.getWriter().write(String.format(errorMsg + " MESSAGE: %s",
          request.getRequestURI(), response.getStatus(), baseRequest.getResponse().getReason()));
    }
    baseRequest.setHandled(true);
  }
}
