/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.MaprShellCommandExecutor;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

@Ignore
public class TestMaprShellCommandExecutor {
    private MaprShellCommandExecutor executor;

    @Before
    public void setUp() {
        this.executor = new MaprShellCommandExecutor();
    }

    @Test
    public void testCheckCommandCreation() {
        Object[] expected = new String[]{"maprcli", "node", "list", "-json"};
        Object[] args = this.executor.createArgs(new String[]{"node", "list"}, new HashMap(), false);
        Assert.assertArrayEquals((Object[])expected, (Object[])args);
    }

    @Test
    public void testCheckParams() {
        HashSet<String> expected = new HashSet<String>(Arrays.asList("maprcli", "node", "list", "-param1", "value1", "-param2", "value2", "-json"));
        String[] commands = new String[]{"node", "list"};
        HashMap<String, String> keyParamsWithoutMinus = new HashMap<String, String>();
        keyParamsWithoutMinus.put("param1", "value1");
        keyParamsWithoutMinus.put("param2", "value2");
        String[] args = this.executor.createArgs(commands, keyParamsWithoutMinus, false);
        Assert.assertEquals((long)expected.size(), (long)args.length);
        Assert.assertTrue((boolean)expected.containsAll(Arrays.asList(args)));
        HashMap<String, String> keyParamsWithMinus = new HashMap<String, String>();
        keyParamsWithMinus.put("-param1", "value1");
        keyParamsWithMinus.put("-param2", "value2");
        args = this.executor.createArgs(commands, keyParamsWithMinus, false);
        Assert.assertEquals((long)expected.size(), (long)args.length);
        Assert.assertTrue((boolean)expected.containsAll(Arrays.asList(args)));
    }

    @Test
    public void testCheckEmptyParameterMap() {
        Object[] expected = new String[]{"maprcli", "node", "list", "-json"};
        Object[] args = this.executor.createArgs(new String[]{"node", "list"}, null, false);
        Assert.assertArrayEquals((Object[])expected, (Object[])args);
        args = this.executor.createArgs(new String[]{"node", "list"}, new HashMap(), false);
        Assert.assertArrayEquals((Object[])expected, (Object[])args);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckEmptyCommand() {
        this.executor.createArgs(null, null, false);
    }

    @Test
    public void testCheckOutput() throws IOException {
        Shell.ShellCommandExecutor mock = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
        Mockito.when((Object)mock.getOutput()).thenReturn((Object)this.getFileFromClassPath("command.json"));
        this.executor.setCommandExecutor(mock);
        JsonArray responseArray = this.executor.execute(new String[]{"test"}, new HashMap(), false);
        for (JsonElement e : responseArray) {
            JsonPrimitive hostname = e.getAsJsonObject().getAsJsonPrimitive("hostname");
            Assert.assertTrue((boolean)hostname.getAsString().contains("node"));
        }
    }

    @Test
    public void testCheckEmptyJsonOutput() throws IOException {
        Shell.ShellCommandExecutor mock = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
        Mockito.when((Object)mock.getOutput()).thenReturn((Object)"{}");
        this.executor.setCommandExecutor(mock);
        this.executor.execute(new String[]{"test"}, new HashMap(), false);
    }

    @Test(expected=IOException.class)
    public void testCheckEmptyOutput() throws IOException {
        Shell.ShellCommandExecutor mock = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
        Mockito.when((Object)mock.getOutput()).thenReturn((Object)"");
        this.executor.setCommandExecutor(mock);
        this.executor.execute(new String[]{"test"}, new HashMap(), false);
    }

    private String getFileFromClassPath(String fileName) throws IOException {
        InputStream fileStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
        Assert.assertNotNull((String)("File " + fileName + " not exists"), (Object)fileStream);
        return IOUtils.toString((InputStream)fileStream);
    }
}

