/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Test;
import org.slf4j.event.Level;

public class TestUGIWithMiniKdc {
    private static MiniKdc kdc;

    @After
    public void teardown() {
        UserGroupInformation.reset();
        if (kdc != null) {
            kdc.stop();
        }
    }

    private void setupKdc() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("max.ticket.lifetime", "2");
        kdcConf.setProperty("min.ticket.lifetime", "2");
        File kdcDir = new File(System.getProperty("test.dir", "target"));
        kdc = new MiniKdc(kdcConf, kdcDir);
        kdc.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testAutoRenewalThreadRetryWithKdc() throws Exception {
        GenericTestUtils.setLogLevel(UserGroupInformation.LOG, Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.kerberos.kinit.command", "bogus-kinit-cmd");
        conf.setLong("hadoop.kerberos.min.seconds.before.relogin", 1L);
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        System.setProperty("hadoop.login", "kerberos");
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        LoginContext loginContext = null;
        try {
            String principal = "foo";
            File workDir = new File(System.getProperty("test.dir", "target"));
            File keytab = new File(workDir, "foo.keytab");
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal("foo"));
            this.setupKdc();
            kdc.createPrincipal(keytab, new String[]{"foo"});
            UserGroupInformation.loginUserFromKeytab((String)"foo", (String)keytab.getPath());
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.spawnAutoRenewalThreadForUserCreds(true);
            LambdaTestUtils.await(30000, 500, () -> {
                int count = UserGroupInformation.metrics.getRenewalFailures().value();
                UserGroupInformation.LOG.info("Renew failure count is {}", (Object)count);
                return count > 0;
            });
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }
}

