/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.CredentialShell;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCredShell {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private static final File tmpDir = GenericTestUtils.getTestDir("creds");
    private String jceksProvider;

    private void assertOutputContains(String expected) {
        Assertions.assertThat((String)this.outContent.toString()).contains(new CharSequence[]{expected});
    }

    @Before
    public void setup() throws Exception {
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
        Path jksPath = new Path(tmpDir.toString(), "keystore.jceks");
        new File(jksPath.toString()).delete();
        this.jceksProvider = "jceks://file" + jksPath.toUri();
    }

    @Test
    public void testCredentialSuccessfulLifecycle() throws Exception {
        this.outContent.reset();
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", this.jceksProvider};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully created."));
        Assert.assertTrue((boolean)this.outContent.toString().contains("WARNING: You have accepted the use of the default provider password\nby not configuring a password in one of the two following locations:\n"));
        Assert.assertTrue((boolean)this.outContent.toString().contains("Please review the documentation regarding provider passwords in\nthe keystore passwords section of the Credential Provider API\n"));
        Assert.assertTrue((boolean)this.outContent.toString().contains("Continuing with the default provider password.\n"));
        this.outContent.reset();
        String[] args2 = new String[]{"list", "-provider", this.jceksProvider};
        rc = cs.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1"));
        this.outContent.reset();
        String[] args4 = new String[]{"delete", "credential1", "-f", "-provider", this.jceksProvider};
        rc = cs.run(args4);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully deleted."));
        this.outContent.reset();
        String[] args5 = new String[]{"list", "-provider", this.jceksProvider};
        rc = cs.run(args5);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertFalse((String)this.outContent.toString(), (boolean)this.outContent.toString().contains("credential1"));
    }

    @Test
    public void testInvalidProvider() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", "sdff://file/tmp/credstore.jceks"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("There are no valid (non-transient) providers configured.\nNo action has been taken. Use the -provider option to specify\na provider. If you want to use a transient provider then you\nMUST use the -provider argument."));
    }

    @Test
    public void testTransientProviderWarning() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", "user:///"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("WARNING: you are modifying a transient provider."));
        String[] args2 = new String[]{"delete", "credential1", "-f", "-provider", "user:///"};
        rc = cs.run(args2);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully deleted."));
    }

    @Test
    public void testTransientProviderOnlyConfig() throws Exception {
        String[] args1 = new String[]{"create", "credential1"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        Configuration config = new Configuration();
        config.set("hadoop.security.credential.provider.path", "user:///");
        cs.setConf(config);
        rc = cs.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("There are no valid (non-transient) providers configured.\nNo action has been taken. Use the -provider option to specify\na provider. If you want to use a transient provider then you\nMUST use the -provider argument."));
    }

    @Test
    public void testPromptForCredentialWithEmptyPasswd() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-provider", this.jceksProvider};
        ArrayList<String> passwords = new ArrayList<String>();
        passwords.add(null);
        passwords.add("p@ssw0rd");
        int rc = 0;
        CredentialShell shell = new CredentialShell();
        shell.setConf(new Configuration());
        shell.setPasswordReader((CredentialShell.PasswordReader)new MockPasswordReader(passwords));
        rc = shell.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("Passwords don't match"));
    }

    @Test
    public void testPromptForCredential() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-provider", this.jceksProvider};
        ArrayList<String> passwords = new ArrayList<String>();
        passwords.add("p@ssw0rd");
        passwords.add("p@ssw0rd");
        int rc = 0;
        CredentialShell shell = new CredentialShell();
        shell.setConf(new Configuration());
        shell.setPasswordReader((CredentialShell.PasswordReader)new MockPasswordReader(passwords));
        rc = shell.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        this.assertOutputContains("credential1 has been successfully created.");
        String[] args2 = new String[]{"check", "credential1", "-provider", this.jceksProvider};
        ArrayList<String> password = new ArrayList<String>();
        password.add("p@ssw0rd");
        shell.setPasswordReader((CredentialShell.PasswordReader)new MockPasswordReader(password));
        rc = shell.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        this.assertOutputContains("Password match success for credential1.");
        ArrayList<String> passwordError = new ArrayList<String>();
        passwordError.add("p@ssw0rderr");
        shell.setPasswordReader((CredentialShell.PasswordReader)new MockPasswordReader(password));
        rc = shell.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        this.assertOutputContains("Password match failed for credential1.");
        String[] args3 = new String[]{"delete", "credential1", "-f", "-provider", this.jceksProvider};
        rc = shell.run(args3);
        Assert.assertEquals((long)0L, (long)rc);
        this.assertOutputContains("credential1 has been successfully deleted.");
    }

    @Test
    public void testEmptyArgList() throws Exception {
        CredentialShell shell = new CredentialShell();
        shell.setConf(new Configuration());
        Assert.assertEquals((long)1L, (long)shell.init(new String[0]));
    }

    @Test
    public void testCommandHelpExitsNormally() throws Exception {
        for (String cmd : Arrays.asList("create", "list", "delete")) {
            CredentialShell shell = new CredentialShell();
            shell.setConf(new Configuration());
            Assert.assertEquals((String)("Expected help argument on " + cmd + " to return 0"), (long)0L, (long)shell.init(new String[]{cmd, "-help"}));
        }
    }

    @Test
    public void testEmptyArgForCommands() throws Exception {
        CredentialShell shell = new CredentialShell();
        String[] command = new String[]{"list", "-provider"};
        Assert.assertEquals((String)("Expected empty argument on " + command + " to return 1"), (long)1L, (long)shell.init(command));
        for (String cmd : Arrays.asList("create", "delete")) {
            shell.setConf(new Configuration());
            Assert.assertEquals((String)("Expected empty argument on " + cmd + " to return 1"), (long)1L, (long)shell.init(new String[]{cmd}));
        }
    }

    @Test
    public void testStrict() throws Exception {
        this.outContent.reset();
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", this.jceksProvider, "-strict"};
        int rc = 1;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)1L, (long)rc);
        Assert.assertFalse((boolean)this.outContent.toString().contains("credential1 has been successfully created."));
        Assert.assertTrue((boolean)this.outContent.toString().contains("ERROR: The provider cannot find a password in the expected locations.\nPlease supply a password using one of the following two mechanisms:\n"));
        Assert.assertTrue((boolean)this.outContent.toString().contains("Please review the documentation regarding provider passwords in\nthe keystore passwords section of the Credential Provider API\n"));
    }

    @Test
    public void testHelp() throws Exception {
        this.outContent.reset();
        String[] args1 = new String[]{"-help"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("Usage"));
    }

    @Test
    public void testHelpCreate() throws Exception {
        this.outContent.reset();
        String[] args1 = new String[]{"create", "-help"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("Usage"));
    }

    public class MockPasswordReader
    extends CredentialShell.PasswordReader {
        List<String> passwords = null;

        public MockPasswordReader(List<String> passwds) {
            this.passwords = passwds;
        }

        public char[] readPassword(String prompt) {
            if (this.passwords.size() == 0) {
                return null;
            }
            String pass = this.passwords.remove(0);
            return pass == null ? null : pass.toCharArray();
        }

        public void format(String message) {
            System.out.println(message);
        }
    }
}

