/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.StringUtils;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FileBasedKeyStoresFactory
implements KeyStoresFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedKeyStoresFactory.class);
    public static final String SSL_KEYSTORE_LOCATION_TPL_KEY = "ssl.{0}.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD_TPL_KEY = "ssl.{0}.keystore.password";
    public static final String SSL_KEYSTORE_KEYPASSWORD_TPL_KEY = "ssl.{0}.keystore.keypassword";
    public static final String SSL_KEYSTORE_TYPE_TPL_KEY = "ssl.{0}.keystore.type";
    public static final String SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.truststore.reload.interval";
    public static final String SSL_TRUSTSTORE_LOCATION_TPL_KEY = "ssl.{0}.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "ssl.{0}.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_TPL_KEY = "ssl.{0}.truststore.type";
    public static final String SSL_EXCLUDE_CIPHER_LIST = "ssl.{0}.exclude.cipher.list";
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    public static final int DEFAULT_SSL_TRUSTSTORE_RELOAD_INTERVAL = 10000;
    private Configuration conf;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private ReloadingX509TrustManager trustManager;

    @VisibleForTesting
    public static String resolvePropertyName(SSLFactory.Mode mode, String template) {
        return MessageFormat.format(template, StringUtils.toLowerCase(mode.toString()));
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.conf.getBoolean("hadoop.ssl.require.client.cert", false);
        String keystoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        String keystoreKeyPassword = null;
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_LOCATION_TPL_KEY);
            String keystoreLocation = this.conf.get(locationProperty, "");
            if (keystoreLocation.isEmpty()) {
                throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
            }
            String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_PASSWORD_TPL_KEY);
            String keystorePassword = this.getPassword(this.conf, passwordProperty, "");
            if (keystorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            String keyPasswordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_KEYPASSWORD_TPL_KEY);
            keystoreKeyPassword = this.getPassword(this.conf, keyPasswordProperty, keystorePassword);
            LOG.debug(mode.toString() + " KeyStore: " + keystoreLocation);
            try (FileInputStream is = new FileInputStream(keystoreLocation);){
                keystore.load(is, keystorePassword.toCharArray());
            }
            LOG.debug(mode.toString() + " Loaded KeyStore: " + keystoreLocation);
        } else {
            keystore.load(null, null);
        }
        if (keystoreType.equalsIgnoreCase("bcfks")) {
            Security.addProvider((Provider)new BouncyCastleFipsProvider());
            Security.addProvider((Provider)new BouncyCastleJsseProvider());
        }
        KeyManagerFactory keyMgrFactory = keystoreType.equalsIgnoreCase("bcfks") ? KeyManagerFactory.getInstance(SSLFactory.KEY_MANAGER_SSLCERTIFICATE, Security.getProvider("BCJSSE")) : KeyManagerFactory.getInstance(SSLFactory.KEY_MANAGER_SSLCERTIFICATE);
        keyMgrFactory.init(keystore, keystoreKeyPassword != null ? keystoreKeyPassword.toCharArray() : null);
        this.keyManagers = keyMgrFactory.getKeyManagers();
        String truststoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_LOCATION_TPL_KEY);
        String truststoreLocation = this.conf.get(locationProperty, "");
        if (!truststoreLocation.isEmpty()) {
            String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_PASSWORD_TPL_KEY);
            String truststorePassword = this.getPassword(this.conf, passwordProperty, "");
            if (truststorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            long truststoreReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY), 10000L);
            LOG.debug(mode.toString() + " TrustStore: " + truststoreLocation);
            this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword, truststoreReloadInterval);
            this.trustManager.init();
            LOG.debug(mode.toString() + " Loaded TrustStore: " + truststoreLocation);
            this.trustManagers = new TrustManager[]{this.trustManager};
        } else {
            LOG.debug("The property '" + locationProperty + "' has not been set, no TrustStore will be loaded");
            this.trustManagers = null;
        }
    }

    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars;
            if (conf.get("hadoop.security.credential.provider.path") == null) {
                conf.addResource("core-site.xml");
            }
            if ((passchars = conf.getPassword(alias)) != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias " + alias + ": " + ioe.getMessage());
        }
        return password;
    }

    @Override
    public synchronized void destroy() {
        if (this.trustManager != null) {
            this.trustManager.destroy();
            this.trustManager = null;
            this.keyManagers = null;
            this.trustManagers = null;
        }
    }

    @Override
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }
}

