/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

public final class Serial {
    private static final String ERROR_MESSAGE_SUFFIX = " out of range";
    private static final long MAX32 = 0xFFFFFFFFL;

    private Serial() {
    }

    public static int compare(long serial1, long serial2) {
        if (serial1 < 0L || serial1 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(serial1 + ERROR_MESSAGE_SUFFIX);
        }
        if (serial2 < 0L || serial2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(serial2 + ERROR_MESSAGE_SUFFIX);
        }
        long diff = serial1 - serial2;
        if (diff >= 0xFFFFFFFFL) {
            diff -= 0x100000000L;
        }
        return (int)diff;
    }

    public static long increment(long serial) {
        if (serial < 0L || serial > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(serial + ERROR_MESSAGE_SUFFIX);
        }
        if (serial == 0xFFFFFFFFL) {
            return 1L;
        }
        return serial + 1L;
    }
}

