/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.jwk.source;

import java.util.Objects;
import org.apache.hadoop.shaded.com.nimbusds.jose.KeySourceException;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.JWKSet;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.source.JWKSetSource;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.source.JWKSetSourceWrapper;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.source.JWKSetUnavailableException;
import org.apache.hadoop.shaded.com.nimbusds.jose.proc.SecurityContext;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class RetryingJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final EventListener<RetryingJWKSetSource<C>, C> eventListener;

    public RetryingJWKSetSource(JWKSetSource<C> source, EventListener<RetryingJWKSetSource<C>, C> eventListener) {
        super(source);
        this.eventListener = eventListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator refreshEvaluator, long currentTime, C context) throws KeySourceException {
        try {
            return this.getSource().getJWKSet(refreshEvaluator, currentTime, context);
        }
        catch (JWKSetUnavailableException e) {
            if (this.eventListener != null) {
                this.eventListener.notify(new RetrialEvent(this, e, (SecurityContext)context, null));
            }
            return this.getSource().getJWKSet(refreshEvaluator, currentTime, context);
        }
    }

    public static class RetrialEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<RetryingJWKSetSource<C>, C> {
        private final Exception exception;

        private RetrialEvent(RetryingJWKSetSource<C> source, Exception exception, C securityContext) {
            super(source, securityContext);
            Objects.requireNonNull(exception);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        /* synthetic */ RetrialEvent(RetryingJWKSetSource x0, Exception x1, SecurityContext x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

