/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class ResourceVector
implements Iterable<Map.Entry<String, Double>> {
    private final Map<String, Double> resourcesByName = new HashMap<String, Double>();

    public static ResourceVector newInstance() {
        ResourceVector zeroResourceVector = new ResourceVector();
        for (ResourceInformation resource : ResourceUtils.getResourceTypesArray()) {
            zeroResourceVector.setValue(resource.getName(), 0.0);
        }
        return zeroResourceVector;
    }

    public static ResourceVector of(double value) {
        ResourceVector emptyResourceVector = new ResourceVector();
        for (ResourceInformation resource : ResourceUtils.getResourceTypesArray()) {
            emptyResourceVector.setValue(resource.getName(), value);
        }
        return emptyResourceVector;
    }

    public static ResourceVector of(Resource resource) {
        ResourceVector resourceVector = new ResourceVector();
        for (ResourceInformation resourceInformation : resource.getResources()) {
            resourceVector.setValue(resourceInformation.getName(), resourceInformation.getValue());
        }
        return resourceVector;
    }

    public void decrement(ResourceVector otherResourceVector) {
        for (Map.Entry<String, Double> resource : otherResourceVector) {
            this.setValue(resource.getKey(), this.getValue(resource.getKey()) - resource.getValue());
        }
    }

    public void decrement(String resourceName, double value) {
        this.setValue(resourceName, this.getValue(resourceName) - value);
    }

    public void increment(String resourceName, double value) {
        this.setValue(resourceName, this.getValue(resourceName) + value);
    }

    public double getValue(String resourceName) {
        return this.resourcesByName.get(resourceName);
    }

    public void setValue(String resourceName, double value) {
        this.resourcesByName.put(resourceName, value);
    }

    public boolean isEmpty() {
        return this.resourcesByName.isEmpty();
    }

    public Set<String> getResourceNames() {
        return this.resourcesByName.keySet();
    }

    @Override
    public Iterator<Map.Entry<String, Double>> iterator() {
        return this.resourcesByName.entrySet().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.resourcesByName.equals(((ResourceVector)o).resourcesByName);
    }

    public int hashCode() {
        return this.resourcesByName.hashCode();
    }
}

