/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnDefaultProperties;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.NodeAttributeStore;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.nodelabels.store.AbstractFSNodeStore;
import org.apache.hadoop.yarn.nodelabels.store.FSStoreOpHandler;
import org.apache.hadoop.yarn.nodelabels.store.op.AddNodeToAttributeLogOp;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.apache.hadoop.yarn.nodelabels.store.op.RemoveNodeToAttributeLogOp;
import org.apache.hadoop.yarn.nodelabels.store.op.ReplaceNodeToAttributeLogOp;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeToAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemNodeAttributeStore
extends AbstractFSNodeStore<NodeAttributesManager>
implements NodeAttributeStore {
    protected static final Logger LOG = LoggerFactory.getLogger(FileSystemNodeAttributeStore.class);
    protected static final String DEFAULT_DIR_NAME = "node-attribute";
    protected static final String MIRROR_FILENAME = "nodeattribute.mirror";
    protected static final String EDITLOG_FILENAME = "nodeattribute.editlog";

    public FileSystemNodeAttributeStore() {
        super(FSStoreOpHandler.StoreType.NODE_ATTRIBUTE);
    }

    private String getDefaultFSNodeAttributeRootDir() throws IOException {
        String defaultRootDir = "file:///tmp/hadoop-yarn-" + UserGroupInformation.getCurrentUser().getShortUserName() + "/" + DEFAULT_DIR_NAME;
        if (System.getenv("SKIP_MAPR_SPECIFIC_PROPERTIES") == null || System.getenv("SKIP_MAPR_SPECIFIC_PROPERTIES").equals("false")) {
            defaultRootDir = "maprfs://" + YarnDefaultProperties.DEFAULT_YARN_DIR + "/" + DEFAULT_DIR_NAME;
        }
        return defaultRootDir;
    }

    public void init(Configuration conf, NodeAttributesManager mgr) throws Exception {
        AbstractFSNodeStore.StoreSchema schema = new AbstractFSNodeStore.StoreSchema(EDITLOG_FILENAME, MIRROR_FILENAME);
        this.initStore(conf, new Path(conf.get("yarn.node-attribute.fs-store.root-dir", this.getDefaultFSNodeAttributeRootDir())), schema, mgr);
    }

    public void replaceNodeAttributes(List<NodeToAttributes> nodeToAttribute) throws IOException {
        ReplaceNodeToAttributeLogOp op = new ReplaceNodeToAttributeLogOp();
        this.writeToLog((FSNodeStoreLogOp)op.setAttributes(nodeToAttribute));
    }

    public void addNodeAttributes(List<NodeToAttributes> nodeAttributeMapping) throws IOException {
        AddNodeToAttributeLogOp op = new AddNodeToAttributeLogOp();
        this.writeToLog((FSNodeStoreLogOp)op.setAttributes(nodeAttributeMapping));
    }

    public void removeNodeAttributes(List<NodeToAttributes> nodeAttributeMapping) throws IOException {
        RemoveNodeToAttributeLogOp op = new RemoveNodeToAttributeLogOp();
        this.writeToLog((FSNodeStoreLogOp)op.setAttributes(nodeAttributeMapping));
    }

    public void recover() throws IOException, YarnException {
        super.recoverFromStore();
    }

    public void close() throws IOException {
        super.closeFSStore();
    }
}

