/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import org.apache.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.shaded.com.google.inject.AbstractModule;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.Binding;
import org.apache.hadoop.shaded.com.google.inject.Injector;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.MembersInjector;
import org.apache.hadoop.shaded.com.google.inject.Module;
import org.apache.hadoop.shaded.com.google.inject.Provider;
import org.apache.hadoop.shaded.com.google.inject.Scope;
import org.apache.hadoop.shaded.com.google.inject.Stage;
import org.apache.hadoop.shaded.com.google.inject.TypeLiteral;
import org.apache.hadoop.shaded.com.google.inject.internal.AbstractProcessor;
import org.apache.hadoop.shaded.com.google.inject.internal.Annotations;
import org.apache.hadoop.shaded.com.google.inject.internal.BindingImpl;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.internal.ErrorsException;
import org.apache.hadoop.shaded.com.google.inject.internal.ExposedBindingImpl;
import org.apache.hadoop.shaded.com.google.inject.internal.InjectorBindingData;
import org.apache.hadoop.shaded.com.google.inject.internal.InjectorImpl;
import org.apache.hadoop.shaded.com.google.inject.internal.ProcessedBindingData;
import org.apache.hadoop.shaded.com.google.inject.internal.Scoping;
import org.apache.hadoop.shaded.com.google.inject.internal.UntargettedBindingImpl;
import org.apache.hadoop.shaded.com.google.inject.spi.DefaultBindingTargetVisitor;

abstract class AbstractBindingProcessor
extends AbstractProcessor {
    private static final ImmutableSet<Class<?>> FORBIDDEN_TYPES = ImmutableSet.of(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, (Object[])new Class[]{Module.class, Provider.class, Scope.class, Stage.class, TypeLiteral.class});
    protected final ProcessedBindingData processedBindingData;

    AbstractBindingProcessor(Errors errors, ProcessedBindingData processedBindingData) {
        super(errors);
        this.processedBindingData = processedBindingData;
    }

    protected <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key, Object source) {
        return new UntargettedBindingImpl<T>(injector, key, source);
    }

    protected void putBinding(BindingImpl<?> binding) {
        Key<?> key;
        block6: {
            key = binding.getKey();
            Class<?> rawType = key.getTypeLiteral().getRawType();
            if (FORBIDDEN_TYPES.contains(rawType)) {
                this.errors.cannotBindToGuiceType(rawType.getSimpleName());
                return;
            }
            Binding original = this.injector.getExistingBinding((Key)key);
            if (original != null) {
                if (this.injector.getBindingData().getExplicitBinding(key) != null) {
                    try {
                        if (!AbstractBindingProcessor.isOkayDuplicate(original, binding, this.injector.getBindingData())) {
                            this.errors.bindingAlreadySet(binding, original);
                            return;
                        }
                        break block6;
                    }
                    catch (Throwable t) {
                        this.errors.errorCheckingDuplicateBinding(key, ((BindingImpl)original).getSource(), t);
                        return;
                    }
                }
                this.errors.jitBindingAlreadySet(key);
                return;
            }
        }
        this.injector.getJitBindingData().banKeyInParent(key, this.injector.getBindingData(), binding.getSource());
        this.injector.getBindingData().putBinding(key, binding);
    }

    private static boolean isOkayDuplicate(BindingImpl<?> original, BindingImpl<?> binding, InjectorBindingData bindingData) {
        if (original instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposed = (ExposedBindingImpl)original;
            InjectorImpl exposedFrom = (InjectorImpl)exposed.getPrivateElements().getInjector();
            return exposedFrom == binding.getInjector();
        }
        original = (BindingImpl)bindingData.getExplicitBindingsThisLevel().get(binding.getKey());
        if (original == null) {
            return false;
        }
        return original.equals(binding);
    }

    private <T> void validateKey(Object source, Key<T> key) {
        Annotations.checkForMisplacedScopeAnnotations(key.getTypeLiteral().getRawType(), source, this.errors);
    }

    abstract class Processor<T, V>
    extends DefaultBindingTargetVisitor<T, V> {
        final Object source;
        final Key<T> key;
        final Class<? super T> rawType;
        Scoping scoping;

        Processor(BindingImpl<T> binding) {
            this.source = binding.getSource();
            this.key = binding.getKey();
            this.rawType = this.key.getTypeLiteral().getRawType();
            this.scoping = binding.getScoping();
        }

        protected void prepareBinding() {
            AbstractBindingProcessor.this.validateKey(this.source, this.key);
            this.scoping = Scoping.makeInjectable(this.scoping, AbstractBindingProcessor.this.injector, AbstractBindingProcessor.this.errors);
        }

        protected void scheduleInitialization(BindingImpl<?> binding) {
            AbstractBindingProcessor.this.processedBindingData.addUninitializedBinding(() -> this.initializeBinding(binding));
        }

        protected void scheduleDelayedInitialization(BindingImpl<?> binding) {
            AbstractBindingProcessor.this.processedBindingData.addDelayedUninitializedBinding(() -> this.initializeBinding(binding));
        }

        private void initializeBinding(BindingImpl<?> binding) {
            try {
                binding.getInjector().initializeBinding(binding, AbstractBindingProcessor.this.errors.withSource(this.source));
            }
            catch (ErrorsException e) {
                AbstractBindingProcessor.this.errors.merge(e.getErrors());
            }
        }
    }
}

