/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DBException;
import org.apache.hadoop.shaded.org.iq80.leveldb.Options;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(DBManager.class);
    private DB db;
    private Timer compactionTimer;

    public DB initDatabase(File configurationFile, Options options, Consumer<DB> initMethod) throws Exception {
        try {
            this.db = JniDBFactory.factory.open(configurationFile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info("Creating configuration version/database at {}", (Object)configurationFile);
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(configurationFile, options);
                    initMethod.accept(this.db);
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
        return this.db;
    }

    @Override
    public void close() throws IOException {
        if (this.compactionTimer != null) {
            this.compactionTimer.cancel();
            this.compactionTimer = null;
        }
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    public void storeVersion(String versionKey, Version versionValue) {
        byte[] data = ((VersionPBImpl)versionValue).getProto().toByteArray();
        this.db.put(JniDBFactory.bytes((String)versionKey), data);
    }

    public Version loadVersion(String versionKey) throws Exception {
        VersionPBImpl version = null;
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)versionKey));
            if (data != null) {
                version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return version;
    }

    @VisibleForTesting
    public void setDb(DB db) {
        this.db = db;
    }

    public void startCompactionTimer(long compactionIntervalMsec, String className) {
        if (compactionIntervalMsec > 0L) {
            this.compactionTimer = new Timer(className + " compaction timer", true);
            this.compactionTimer.schedule((TimerTask)new CompactionTimerTask(), compactionIntervalMsec, compactionIntervalMsec);
        }
    }

    private class CompactionTimerTask
    extends TimerTask {
        private CompactionTimerTask() {
        }

        @Override
        public void run() {
            long start = Time.monotonicNow();
            LOG.info("Starting full compaction cycle");
            try {
                DBManager.this.db.compactRange(null, null);
            }
            catch (DBException e) {
                LOG.error("Error compacting database", (Throwable)e);
            }
            long duration = Time.monotonicNow() - start;
            LOG.info("Full compaction cycle completed in " + duration + " msec");
        }
    }
}

