/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MapRNode;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NodeState;
import org.apache.hadoop.hdfs.RunCommand;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniMapRFSCluster
extends MiniDFSCluster {
    public static final Logger LOG = LoggerFactory.getLogger(MiniMapRFSCluster.class);
    public static final String MAPRFS_SCHEME = "maprfs:///";
    static String installDir = "/opt/mapr";
    static String tmpPath = "/tmp/mapr-scratch/";
    static String mfsExe = installDir + "/server/mfs";
    static String hadoopExe = installDir + "/hadoop/hadoop-common-2.3.0/bin/hadoop";
    static String testConfigPy = installDir + "/server/testconfig.py";
    static String cldbInitScript = "/opt/mapr/cldb/cldb ";
    static String mruuidgen = installDir + "/server/mruuidgen";
    static String maprClustersFile = installDir + "/conf/mapr-clusters.conf";
    static String mfsdbFile = installDir + "/server/tools/mfsdb";
    static String maprCli = installDir + "/bin/maprcli";
    static int cldbPort = 7222;
    static int defaultMfsPort = 5660;
    static int blockSize = 8192;
    static int clusterSize = 8 * blockSize;
    static int chunkSize = 0x4000000;
    public static final String PROP_TEST_BUILD_DATA = "test.build.data";
    private String volName;
    private int numReplicas;
    private int numNodes;
    private MapRNode[] nodes;
    private boolean isClusterUp;
    private Configuration conf;
    private static final String SIGTERM_CMD = "$JAVA_HOME/bin/jps | grep %s | grep -v grep | awk '{print $1}' | xargs --no-run-if-empty kill";
    private static final String SIGKILL_CMD = "$JAVA_HOME/bin/jps | grep %s | grep -v grep | awk '{print $1}' | xargs --no-run-if-empty kill -9";
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final String UNSUPPORTED_MESSAGE = "MiniMapRFSCluster does not support this method";

    protected MiniMapRFSCluster(MiniDFSCluster.Builder builder) throws IOException {
        this.teardownServices();
        this.conf = builder.conf;
        this.conf.set("fs.default.name", MAPRFS_SCHEME);
        int replication = this.conf.getInt("dfs.replication", 3);
        this.conf.setInt("dfs.replication", Math.min(replication, builder.numDataNodes));
        this.conf.set("fs.maprfs.impl", "org.apache.hadoop.hdfs.MapRDistributedFileSystem");
        this.conf.set("fs.AbstractFileSystem.maprfs.impl", "org.apache.hadoop.shaded.com.mapr.fs.MFS");
        this.conf.set("io.file.buffer.size", "65536");
        this.conf.set("dfs.http.address", "127.0.0.1:0");
        if (builder.numDataNodes == 0) {
            builder.numDataNodes = 1;
        }
        this.initNodes("TestVolume", builder.numDataNodes);
        this.startDataNodes(this.conf, builder.numDataNodes, builder.manageDataDfsDirs, builder.option, builder.racks, builder.hosts, builder.simulatedCapacities);
        this.waitClusterUp();
        if (!this.isClusterUp) {
            throw new IOException("Failed to create mapr cluster");
        }
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
    }

    private void teardownServices() {
        String[] javaProcs;
        String[] commands = new String[]{"/opt/mapr/cldb/cldb stop", "/opt/mapr/zookeeper/zookeeper-3.4.5/bin/zkServer.sh stop", "pkill -9 mfs"};
        RunCommand rc = new RunCommand();
        for (int i = 0; i < commands.length; ++i) {
            rc.init(commands[i], "", false, false);
            rc.Run();
        }
        for (String javaProc : javaProcs = new String[]{"QuorumPeerMain", "FsShell"}) {
            this.killJavaProcess(javaProc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killJavaProcess(String javaProcName) {
        File script = null;
        try {
            script = File.createTempFile("kill_" + javaProcName, ".sh", TEMP_DIR);
            PrintWriter pw = new PrintWriter(new FileWriter(script));
            pw.println(String.format(SIGTERM_CMD, javaProcName));
            pw.println("sleep 2");
            pw.println(String.format(SIGKILL_CMD, javaProcName));
            pw.close();
            Runtime.getRuntime().exec("chmod +x " + script.getAbsolutePath()).waitFor();
            LOG.info("Terminating Java process: " + javaProcName);
            Runtime.getRuntime().exec(script.getAbsolutePath()).waitFor();
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            if (script != null) {
                script.delete();
            }
        }
    }

    void initNodes(String volName, int numNodes) {
        this.volName = volName;
        this.numNodes = numNodes;
        this.nodes = new MapRNode[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            this.nodes[i] = new MapRNode();
            if (i == 0) {
                this.nodes[i].init(true, true, true, i);
                continue;
            }
            this.nodes[i].init(false, false, true, i);
        }
    }

    @Override
    public void waitClusterUp() {
        for (int i = 1; i <= 10; ++i) {
            try {
                LOG.info("Waiting for cluster to come up");
                Thread.sleep(i * 1000);
            }
            catch (InterruptedException e) {
                LOG.info("Got interrupted while wating for cluster to come up");
                return;
            }
            try {
                FileSystem fs = FileSystem.get((Configuration)this.conf);
                fs.listStatus(new Path(MAPRFS_SCHEME));
                this.isClusterUp = true;
                return;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                continue;
            }
        }
    }

    public void Start() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i].Start();
        }
    }

    public void Stop() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
        }
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.Start();
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, null);
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.Start();
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, StorageType storageType, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig, Configuration[] dnConfOverlays) throws IOException {
        this.Start();
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        this.Start();
    }

    @Override
    public void shutdown(boolean deleteDfsDir) {
        int i;
        for (i = 0; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
        }
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].CleanUp();
        }
    }

    @Override
    public void shutdownDataNodes() {
        for (int i = 1; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
        }
    }

    public boolean corruptBlock(String file, long offset) {
        boolean retVal = false;
        RunCommand rc = new RunCommand();
        String[] cmd = new String[]{"/bin/sh", "-c", hadoopExe + " mfs -ls " + file + "| (offset=" + offset + "; chunkSize=" + chunkSize + "; read line; read line; read line; if [ $offset -lt " + clusterSize + " ]; then echo $line; exit; fi;reqIdx=$[offset/chunkSize];i=0;while read line; do if [ $i -eq $reqIdx ]; then echo $line; break; fi; i=$[i+1]; done)"};
        rc.init(cmd, "", false, true);
        rc.Run();
        if (rc.OutPutStr() == null) {
            return false;
        }
        try {
            String[] tokens = rc.OutPutStr().split(" ");
            String fid = tokens[1];
            for (int i = 2; i < tokens.length; ++i) {
                String port = tokens[i].split(":")[1];
                int nodeId = Integer.parseInt(port) - defaultMfsPort;
                if (nodeId == 0) continue;
                Long block = this.nodes[nodeId].getBlockNumber(fid, offset % (long)chunkSize);
                retVal = this.nodes[nodeId].corruptBlock(block);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public synchronized MiniDFSCluster.DataNodeProperties stopDataNode(int i) {
        if (i < 1 || i >= this.nodes.length) {
            return null;
        }
        this.nodes[i].Stop();
        return null;
    }

    @Override
    public synchronized MiniDFSCluster.DataNodeProperties stopDataNode(String name) {
        int i;
        for (i = 0; i < this.nodes.length && !this.nodes[i].GetName().equals(name); ++i) {
        }
        return this.stopDataNode(i);
    }

    @Override
    public synchronized boolean restartDataNode(int i, boolean keepPort) throws IOException {
        this.nodes[i].Stop();
        this.nodes[i].Start();
        return true;
    }

    @Override
    public synchronized boolean restartDataNodes(boolean keepPort) throws IOException {
        for (int i = 1; i < this.numNodes; ++i) {
            this.nodes[i].Stop();
            this.nodes[i].Start();
        }
        return true;
    }

    @Override
    public boolean isClusterUp() {
        return this.isClusterUp;
    }

    @Override
    public boolean isDataNodeUp() {
        return this.nodes[0].State() == NodeState.RUNNING;
    }

    @Override
    public DistributedFileSystem getFileSystem() throws IOException {
        return (DistributedFileSystem)FileSystem.get((Configuration)this.conf);
    }

    @Override
    public DistributedFileSystem getFileSystem(int i) throws IOException {
        return this.getFileSystem();
    }

    @Override
    public void waitActive() throws IOException {
        this.waitActive(true);
    }

    public void waitActive(boolean waitHeartbeats) throws IOException {
        this.waitClusterUp();
        if (!this.isClusterUp) {
            throw new IOException("Failed to create mapr cluster");
        }
    }

    @Override
    public Configuration getConfiguration(int nnIndex) {
        return this.conf;
    }

    @Override
    public void formatDataNodeDirs() throws IOException {
    }

    @Override
    public URI getURI() {
        URI uri = null;
        try {
            uri = new URI(MAPRFS_SCHEME + this.nodes[0].localhost + ":" + this.nodes[0].port);
        }
        catch (URISyntaxException e) {
            LOG.warn("Unexpected URISyntaxException: ", (Throwable)e);
        }
        return uri;
    }

    @Override
    public URI getURI(int nnIndex) {
        return this.getURI();
    }

    @Override
    public int getNameNodePort() {
        return cldbPort;
    }

    @Override
    public void setLeasePeriod(long soft, long hard) {
    }

    @Override
    public void setLeasePeriod(long soft, long hard, int nnIndex) {
    }

    @Override
    public URI getSharedEditsDir(int minNN, int maxNN) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public MiniDFSCluster.NameNodeInfo[] getNameNodeInfos() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public int getInstanceId() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void waitNameNodeUp(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void finalizeCluster(int nnIndex, Configuration conf) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void finalizeCluster(Configuration conf) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public int getNumNameNodes() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public NameNode getNameNode() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public NamenodeProtocols getNameNodeRpc() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public NamenodeProtocols getNameNodeRpc(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public NameNode getNameNode(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public FSNamesystem getNamesystem() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public FSNamesystem getNamesystem(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public ArrayList<DataNode> getDataNodes() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public DataNode getDataNode(int ipcPort) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public int getNameNodePort(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public int getNameNodeServicePort(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void shutdownNameNodes() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void shutdownNameNode(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void restartNameNodes() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void restartNameNode(String ... args) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void restartNameNode(boolean waitActive) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void restartNameNode(int nnIndex) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized void restartNameNode(int nnIndex, boolean waitActive, String ... args) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public int corruptBlockOnDataNodes(ExtendedBlock block) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public String readBlockOnDataNode(int i, ExtendedBlock block) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public boolean restartDataNode(MiniDFSCluster.DataNodeProperties dnprop) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public synchronized boolean restartDataNode(MiniDFSCluster.DataNodeProperties dnprop, boolean keepPort) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public boolean restartDataNode(int i) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public boolean restartDataNodes() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public boolean isNameNodeUp(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public FileSystem getNewFileSystemInstance(int nnIndex) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public String getHttpUri(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public Collection<URI> getNameDirs(int nnIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public Collection<URI> getNameEditsDirs(int nnIndex) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void transitionToActive(int nnIndex) throws IOException, ServiceFailedException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void transitionToStandby(int nnIndex) throws IOException, ServiceFailedException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void triggerBlockReports() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void triggerDeletionReports() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void triggerHeartbeats() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void waitActive(int nnIndex) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public Map<DatanodeStorage, BlockListAsLongs> getBlockReport(String bpid, int dataNodeIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public List<Map<DatanodeStorage, BlockListAsLongs>> getAllBlockReports(String bpid) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void injectBlocks(int dataNodeIndex, Iterable<Block> blocksToInject, String bpid) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void injectBlocks(int nameNodeIndex, int dataNodeIndex, Iterable<Block> blocksToInject) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void setWaitSafeMode(boolean wait) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    DataNode[] listDataNodes() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public String getDataDirectory() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    protected String determineDfsBaseDir() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public File getInstanceStorageDir(int dnIndex, int dirIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public File[] getAllBlockFiles(ExtendedBlock block) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void addNameNode(Configuration conf, int namenodePort) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }
}

