/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.shaded.com.google.gson.Gson;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@XmlRootElement(name="appAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAttemptInfo {
    protected int id;
    protected long startTime;
    protected long finishedTime;
    protected String containerId;
    protected String nodeHttpAddress;
    protected String nodeId;
    protected String logsLink;
    protected String blacklistedNodes;
    private String nodesBlacklistedBySystem;
    protected String appAttemptId;
    private String exportPorts;

    public AppAttemptInfo() {
    }

    public AppAttemptInfo(ResourceManager rm, RMAppAttempt attempt, Boolean hasAccess, String user, String schemePrefix) {
        this.startTime = 0L;
        this.containerId = "";
        this.nodeHttpAddress = "";
        this.nodeId = "";
        this.logsLink = "";
        this.blacklistedNodes = "";
        this.exportPorts = "";
        if (attempt != null) {
            this.id = attempt.getAppAttemptId().getAttemptId();
            this.startTime = attempt.getStartTime();
            this.finishedTime = attempt.getFinishTime();
            Container masterContainer = attempt.getMasterContainer();
            if (masterContainer != null && hasAccess.booleanValue()) {
                AbstractYarnScheduler ayScheduler;
                Object sattempt;
                this.containerId = masterContainer.getId().toString();
                this.nodeHttpAddress = masterContainer.getNodeHttpAddress();
                this.nodeId = masterContainer.getNodeId().toString();
                this.logsLink = WebAppUtils.getRunningLogURL((String)(schemePrefix + masterContainer.getNodeHttpAddress()), (String)masterContainer.getId().toString(), (String)user);
                Gson gson = new Gson();
                this.exportPorts = gson.toJson((Object)masterContainer.getExposedPorts());
                this.nodesBlacklistedBySystem = StringUtils.join((Iterable)attempt.getAMBlacklistManager().getBlacklistUpdates().getBlacklistAdditions(), (String)", ");
                if (rm.getResourceScheduler() instanceof AbstractYarnScheduler && (sattempt = (ayScheduler = (AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(attempt.getAppAttemptId())) != null) {
                    this.blacklistedNodes = StringUtils.join(((SchedulerApplicationAttempt)sattempt).getBlacklistedNodes(), (String)", ");
                }
            }
            this.appAttemptId = attempt.getAppAttemptId().toString();
        }
    }

    public int getAttemptId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }

    public String getLogsLink() {
        return this.logsLink;
    }

    public String getAppAttemptId() {
        return this.appAttemptId;
    }
}

