/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization.serializers;

import java.io.IOException;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.apache.hadoop.shaded.org.nustaq.offheap.structs.FSTStruct;
import org.apache.hadoop.shaded.org.nustaq.offheap.structs.unsafeimpl.FSTStructFactory;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTBasicObjectSerializer;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTClazzInfo;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;

public class FSTStructSerializer
extends FSTBasicObjectSerializer {
    public static boolean COMPRESS = true;

    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        FSTStruct str = (FSTStruct)toWrite;
        if (!str.isOffHeap()) {
            str = str.toOffHeap();
        }
        int byteSize = str.getByteSize();
        out.writeInt(byteSize);
        if (COMPRESS) {
            long base = str.___offset;
            int intsiz = byteSize / 4;
            for (int i = 0; i < intsiz; ++i) {
                int value = str.getInt();
                value = value << 1 ^ value >> 31;
                str.___offset += 4L;
                while ((long)(value & 0xFFFFFF80) != 0L) {
                    out.writeByte(value & 0x7F | 0x80);
                    value >>>= 7;
                }
                out.writeByte(value & 0x7F);
            }
            int remainder = byteSize & 3;
            for (int i = 0; i < remainder; ++i) {
                byte aByte = str.getByte();
                out.writeByte(aByte);
                ++str.___offset;
            }
            str.___offset = base;
        } else {
            byte[] b = new byte[byteSize];
            str.getBase().getArr(str.getOffset(), b, 0, byteSize);
            out.write(b, 0, byteSize);
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        int len = in.readFInt();
        byte[] bytes = new byte[len];
        if (COMPRESS) {
            int intsiz = len / 4;
            int count = 0;
            for (int n = 0; n < intsiz; ++n) {
                byte b;
                int value = 0;
                int i = 0;
                while (((b = in.readByte()) & 0x80) != 0) {
                    value |= (b & 0x7F) << i;
                    i += 7;
                }
                int temp = ((value |= b << i) << 31 >> 31 ^ value) >> 1;
                value = temp ^ value & Integer.MIN_VALUE;
                bytes[count++] = (byte)(value >>> 0 & 0xFF);
                bytes[count++] = (byte)(value >>> 8 & 0xFF);
                bytes[count++] = (byte)(value >>> 16 & 0xFF);
                bytes[count++] = (byte)(value >>> 24 & 0xFF);
            }
            int remainder = len & 3;
            for (int i = 0; i < remainder; ++i) {
                bytes[count++] = in.readByte();
            }
        } else {
            in.read(bytes);
        }
        HeapBytez hb = new HeapBytez(bytes);
        return FSTStructFactory.getInstance().createStructWrapper(hb, 0L);
    }
}

