/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.EntryStatus;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.OperationDuration;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOutputDirectoriesStage
extends AbstractJobOrTaskStage<Collection<DirEntry>, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOutputDirectoriesStage.class);
    private final Map<Path, DirMapState> dirMap = new ConcurrentHashMap<Path, DirMapState>();
    private final List<Path> createdDirectories = new ArrayList<Path>();
    private final AtomicInteger failureCount = new AtomicInteger();

    public CreateOutputDirectoriesStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_create_target_dirs", true);
        this.dirMap.put(this.getDestinationDir(), DirMapState.dirWasCreated);
    }

    @Override
    protected Result executeStage(Collection<DirEntry> manifestDirs) throws IOException {
        List<Path> directories = this.createAllDirectories(manifestDirs);
        LOG.info("{}: Created {} directories", (Object)this.getName(), (Object)directories.size());
        return new Result(new HashSet<Path>(directories), this.dirMap);
    }

    private List<Path> createAllDirectories(Collection<DirEntry> manifestDirs) throws IOException {
        HashMap<Path, DirEntry> leaves = new HashMap<Path, DirEntry>();
        HashMap<Path, DirEntry> parents = new HashMap<Path, DirEntry>();
        HashSet<Path> filesToDelete = new HashSet<Path>();
        ArrayList<DirEntry> destDirectories = new ArrayList<DirEntry>(manifestDirs);
        Collections.sort(destDirectories, Comparator.comparingInt(DirEntry::getLevel));
        for (DirEntry entry : destDirectories) {
            Path parent;
            Path path = entry.getDestPath();
            if (leaves.containsKey(path)) continue;
            leaves.put(path, entry);
            if (entry.getStatus() == EntryStatus.file) {
                filesToDelete.add(path);
            }
            if ((parent = path.getParent()) == null || !leaves.containsKey(parent)) continue;
            parents.put(parent, (DirEntry)leaves.remove(parent));
        }
        this.deleteFiles(filesToDelete);
        int createCount = leaves.size();
        LOG.info("Preparing {} directory/directories; {} parent dirs implicitly created. Files deleted: {}", new Object[]{createCount, parents.size(), filesToDelete.size()});
        Duration d = IOStatisticsBinding.measureDurationOfInvocation(this.getIOStatistics(), "op_create_directories", () -> TaskPool.foreach(leaves.values()).executeWith(this.getIOProcessors(createCount)).onFailure(this::reportMkDirFailure).stopOnFailure().run(this::createOneDirectory));
        LOG.info("Time to prepare directories {}", (Object)OperationDuration.humanTime(d.toMillis()));
        return this.createdDirectories;
    }

    private void reportMkDirFailure(DirEntry dirEntry, Exception e) {
        Path path = dirEntry.getDestPath();
        int count = this.failureCount.incrementAndGet();
        LOG.warn("{}: mkdir failure #{} Failed to create directory \"{}\": {}", new Object[]{this.getName(), count, path, e.toString()});
        LOG.debug("{}: Full exception details", (Object)this.getName(), (Object)e);
    }

    private void deleteFiles(Set<Path> filesToDelete) throws IOException {
        int size = filesToDelete.size();
        if (size == 0) {
            return;
        }
        LOG.info("{}: Directory entries containing files to delete: {}", (Object)this.getName(), (Object)size);
        Duration d = IOStatisticsBinding.measureDurationOfInvocation(this.getIOStatistics(), "op_prepare_dir_ancestors", () -> TaskPool.foreach(filesToDelete).executeWith(this.getIOProcessors(size)).stopOnFailure().run(dir -> {
            this.updateAuditContext("op_prepare_dir_ancestors");
            this.deleteDirWithFile((Path)dir);
        }));
        LOG.info("Time to delete files {}", (Object)OperationDuration.humanTime(d.toMillis()));
    }

    private void deleteDirWithFile(Path dir) throws IOException {
        this.progress();
        LOG.info("{}: Deleting file {}", (Object)this.getName(), (Object)dir);
        this.deleteFile(dir, "op_delete");
        this.addToDirectoryMap(dir, DirMapState.fileNowDeleted);
    }

    private void createOneDirectory(DirEntry dirEntry) throws IOException {
        this.progress();
        Path dir = dirEntry.getDestPath();
        this.updateAuditContext("job_stage_create_target_dirs");
        DirMapState state = this.maybeCreateOneDirectory(dirEntry);
        switch (state) {
            case dirFoundInStore: {
                this.addToDirectoryMap(dir, state);
                break;
            }
            case dirWasCreated: 
            case dirCreatedOnSecondAttempt: {
                this.addCreatedDirectory(dir);
                this.addToDirectoryMap(dir, state);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DirMapState maybeCreateOneDirectory(DirEntry dirEntry) throws IOException {
        EntryStatus status = dirEntry.getStatus();
        if (status == EntryStatus.dir) {
            return DirMapState.dirFoundInStore;
        }
        if (status == EntryStatus.created_dir) {
            return DirMapState.dirWasCreated;
        }
        Path path = dirEntry.getDestPath();
        LOG.info("Creating directory {}", (Object)path);
        try {
            if (this.mkdirs(path, false)) {
                return DirMapState.dirWasCreated;
            }
            this.getIOStatistics().incrementCounter("op_mkdir_returned_false");
            LOG.info("{}: mkdirs({}) returned false, attempting to recover", (Object)this.getName(), (Object)path);
        }
        catch (IOException e) {
            LOG.info("{}: mkdir({}) raised exception {}", new Object[]{this.getName(), path, e.toString()});
            LOG.debug("{}: Mkdir stack", (Object)this.getName(), (Object)e);
        }
        FileStatus st = this.getFileStatusOrNull(path);
        if (st != null) {
            if (st.isDirectory()) {
                LOG.warn("{}: Even though mkdirs({}) failed, there is now a directory there", (Object)this.getName(), (Object)path);
                return DirMapState.dirFoundInStore;
            }
            LOG.info("{}: Deleting file where a directory should go: {}", (Object)this.getName(), (Object)st);
            this.deleteFile(path, "op_delete_file_under_destination");
        } else {
            LOG.warn("{}: Although mkdirs({}) returned false, there's nothing at that path to prevent it", (Object)this.getName(), (Object)path);
        }
        if (!this.mkdirs(path, false)) {
            this.getIOStatistics().incrementCounter("op_mkdir_returned_false");
            this.directoryMustExist("Creating directory ", path);
        }
        return DirMapState.dirCreatedOnSecondAttempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCreatedDirectory(Path dir) {
        List<Path> list = this.createdDirectories;
        synchronized (list) {
            this.createdDirectories.add(dir);
        }
    }

    private void addToDirectoryMap(Path dir, DirMapState state) {
        if (!this.dirMap.containsKey(dir)) {
            this.dirMap.put(dir, state);
        }
    }

    public static enum DirMapState {
        dirFoundInStore,
        dirFoundInMap,
        dirWasCreated,
        dirCreatedOnSecondAttempt,
        fileNowDeleted,
        ancestorWasDirOrMissing,
        parentWasNotFile,
        parentOfCreatedDir;

    }

    public static final class Result {
        private final Set<Path> createdDirectories;
        private final Map<Path, DirMapState> dirMap;

        public Result(Set<Path> createdDirectories, Map<Path, DirMapState> dirMap) {
            this.createdDirectories = Objects.requireNonNull(createdDirectories);
            this.dirMap = Objects.requireNonNull(dirMap);
        }

        public Set<Path> getCreatedDirectories() {
            return this.createdDirectories;
        }

        public Map<Path, DirMapState> getDirMap() {
            return this.dirMap;
        }

        public String toString() {
            return "Result{directory count=" + this.createdDirectories.size() + '}';
        }
    }
}

