/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthHandler
extends MultiMechsAuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(BasicAuthHandler.class);
    private static final String BASIC_AUTH = "Basic";
    private final String passwordAuthenticationClass = "org.apache.hadoop.shaded.com.mapr.login.PasswordAuthentication";

    @Override
    public void init(Properties config) throws ServletException {
    }

    @Override
    public AuthenticationToken postauthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken authToken = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith(BASIC_AUTH)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: " + authorization);
                }
                authorization = authorization.substring(authorization.indexOf(32) + 1);
                authorization = new String(Base64.decodeBase64((String)authorization));
                int i = authorization.indexOf(58);
                String username = authorization.substring(0, i);
                String password = authorization.substring(i + 1);
                Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass("org.apache.hadoop.shaded.com.mapr.login.PasswordAuthentication");
                Method passAuth = klass.getDeclaredMethod("authenticate", String.class, String.class);
                if (((Boolean)passAuth.invoke(null, username, password)).booleanValue()) {
                    authToken = new AuthenticationToken(username, username, this.getType());
                    response.setStatus(200);
                } else {
                    response.setStatus(401);
                    LOG.error("User Principal is null while trying to authenticate with Basic Auth");
                }
            }
            catch (Exception e) {
                LOG.warn("AUTH FAILURE: " + e.toString());
            }
        }
        return authToken;
    }

    @Override
    public void addHeader(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "Basic realm=\"WebLogin\"");
    }

    @Override
    public MultiMechsAuthenticationHandler getAuthBasedEntity(String authorization) {
        if (authorization != null && authorization.startsWith(BASIC_AUTH)) {
            return this;
        }
        return null;
    }

    @Override
    public String getAuthorizationHeaderName() {
        return BASIC_AUTH;
    }
}

