/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskCompletionEvent
implements Writable {
    private int eventId;
    private String taskTrackerHttp;
    private int taskRunTime;
    private TaskAttemptID taskId;
    Status status;
    boolean isMap = false;
    private int idWithinJob;
    public static final TaskCompletionEvent[] EMPTY_ARRAY = new TaskCompletionEvent[0];
    private Map<String, ByteBuffer> serviceMetaData = new HashMap<String, ByteBuffer>();

    public TaskCompletionEvent() {
        this.taskId = new TaskAttemptID();
    }

    public TaskCompletionEvent(int eventId, TaskAttemptID taskId, int idWithinJob, boolean isMap, Status status, String taskTrackerHttp) {
        this.taskId = taskId;
        this.idWithinJob = idWithinJob;
        this.isMap = isMap;
        this.eventId = eventId;
        this.status = status;
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public TaskCompletionEvent(int eventId, TaskAttemptID taskId, int idWithinJob, boolean isMap, Status status, String taskTrackerHttp, Map<String, ByteBuffer> servicesMetaData) {
        this.taskId = taskId;
        this.idWithinJob = idWithinJob;
        this.isMap = isMap;
        this.eventId = eventId;
        this.status = status;
        this.taskTrackerHttp = taskTrackerHttp;
        this.serviceMetaData = servicesMetaData;
    }

    public int getEventId() {
        return this.eventId;
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.taskId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getTaskTrackerHttp() {
        return this.taskTrackerHttp;
    }

    public int getTaskRunTime() {
        return this.taskRunTime;
    }

    public Map<String, ByteBuffer> getServiceMetaData() {
        return this.serviceMetaData;
    }

    protected void setTaskRunTime(int taskCompletionTime) {
        this.taskRunTime = taskCompletionTime;
    }

    protected void setEventId(int eventId) {
        this.eventId = eventId;
    }

    protected void setTaskAttemptId(TaskAttemptID taskId) {
        this.taskId = taskId;
    }

    protected void setTaskStatus(Status status) {
        this.status = status;
    }

    protected void setTaskTrackerHttp(String taskTrackerHttp) {
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public void setServiceMetaData(Map<String, ByteBuffer> serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Task Id : ");
        buf.append(this.taskId);
        buf.append(", Status : ");
        buf.append(this.status.name());
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(this.getClass())) {
            TaskCompletionEvent event = (TaskCompletionEvent)o;
            return this.isMap == event.isMapTask() && this.eventId == event.getEventId() && this.idWithinJob == event.idWithinJob() && this.status.equals((Object)event.getStatus()) && this.taskId.equals(event.getTaskAttemptId()) && this.taskRunTime == event.getTaskRunTime() && this.taskTrackerHttp.equals(event.getTaskTrackerHttp());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isMapTask() {
        return this.isMap;
    }

    public int idWithinJob() {
        return this.idWithinJob;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.taskId.write(out);
        WritableUtils.writeVInt(out, this.idWithinJob);
        out.writeBoolean(this.isMap);
        WritableUtils.writeEnum(out, this.status);
        WritableUtils.writeString(out, this.taskTrackerHttp);
        WritableUtils.writeVInt(out, this.taskRunTime);
        WritableUtils.writeVInt(out, this.eventId);
        WritableUtils.writeVInt(out, this.serviceMetaData.size());
        for (Map.Entry<String, ByteBuffer> entry : this.serviceMetaData.entrySet()) {
            WritableUtils.writeString(out, entry.getKey());
            ByteBuffer value = entry.getValue();
            ByteBuffer dup = value.duplicate();
            ((Buffer)dup).rewind();
            int count = dup.remaining();
            byte[] copy = new byte[count];
            dup.get(copy);
            WritableUtils.writeVInt(out, count);
            out.write(copy, 0, count);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.taskId.readFields(in);
        this.idWithinJob = WritableUtils.readVInt(in);
        this.isMap = in.readBoolean();
        this.status = WritableUtils.readEnum(in, Status.class);
        this.taskTrackerHttp = WritableUtils.readString(in);
        this.taskRunTime = WritableUtils.readVInt(in);
        this.eventId = WritableUtils.readVInt(in);
        int mapSize = WritableUtils.readVInt(in);
        for (int i = 0; i < mapSize; ++i) {
            String sName = WritableUtils.readString(in);
            int count = WritableUtils.readVInt(in);
            byte[] array = new byte[count];
            in.readFully(array);
            ByteBuffer bb = ByteBuffer.wrap(array);
            this.serviceMetaData.put(sName, bb);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum Status {
        FAILED,
        KILLED,
        SUCCEEDED,
        OBSOLETE,
        TIPFAILED;

    }
}

