/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OfferedPsks;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        TlsClientContextImpl clientContext = new TlsClientContextImpl(client.getCrypto());
        ClientHandshakeState state = new ClientHandshakeState();
        state.client = client;
        state.clientContext = clientContext;
        client.init(clientContext);
        clientContext.handshakeBeginning(client);
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        securityParameters.extendedPadding = client.shouldUseExtendedPadding();
        DTLSRecordLayer recordLayer = new DTLSRecordLayer(clientContext, client, transport);
        client.notifyCloseHandle(recordLayer);
        try {
            DTLSTransport dTLSTransport = this.clientHandshake(state, recordLayer);
            return dTLSTransport;
        }
        catch (TlsFatalAlert fatalAlert) {
            this.abortClientHandshake(state, recordLayer, fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.abortClientHandshake(state, recordLayer, (short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.abortClientHandshake(state, recordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState state, DTLSRecordLayer recordLayer, short alertDescription) {
        recordLayer.fail(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, DTLSRecordLayer recordLayer) throws IOException {
        TlsClient client = state.client;
        TlsClientContextImpl clientContext = state.clientContext;
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        DTLSReliableHandshake handshake = new DTLSReliableHandshake(clientContext, recordLayer, client.getHandshakeTimeoutMillis(), client.getHandshakeResendTimeMillis(), null);
        byte[] clientHelloBody = this.generateClientHello(state);
        recordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        handshake.sendMessage((short)1, clientHelloBody);
        DTLSReliableHandshake.Message serverMessage = handshake.receiveMessage();
        while (serverMessage.getType() == 3) {
            byte[] cookie = this.processHelloVerifyRequest(state, serverMessage.getBody());
            byte[] patched = DTLSClientProtocol.patchClientHelloWithCookie(clientHelloBody, cookie);
            handshake.resetAfterHelloVerifyRequestClient();
            handshake.sendMessage((short)1, patched);
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        ProtocolVersion recordLayerVersion = recordLayer.getReadVersion();
        this.reportServerVersion(state, recordLayerVersion);
        recordLayer.setWriteVersion(recordLayerVersion);
        this.processServerHello(state, serverMessage.getBody());
        DTLSClientProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        handshake.getHandshakeHash().notifyPRFDetermined();
        if (securityParameters.isResumedSession()) {
            securityParameters.masterSecret = state.sessionMasterSecret;
            recordLayer.initPendingEpoch(TlsUtils.initCipher(clientContext));
            securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(clientContext, handshake.getHandshakeHash(), true);
            this.processFinished(handshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
            securityParameters.localVerifyData = TlsUtils.calculateVerifyData(clientContext, handshake.getHandshakeHash(), false);
            handshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
            handshake.finish();
            if (securityParameters.isExtendedMasterSecret()) {
                securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
            }
            securityParameters.localCertificate = state.sessionParameters.getLocalCertificate();
            securityParameters.peerCertificate = state.sessionParameters.getPeerCertificate();
            securityParameters.pskIdentity = state.sessionParameters.getPSKIdentity();
            securityParameters.srpIdentity = state.sessionParameters.getSRPIdentity();
            clientContext.handshakeComplete(client, state.tlsSession);
            recordLayer.initHeartbeat(state.heartbeat, 1 == state.heartbeatPolicy);
            return new DTLSTransport(recordLayer);
        }
        this.invalidateSession(state);
        state.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        serverMessage = handshake.receiveMessage();
        if (serverMessage.getType() == 23) {
            this.processServerSupplementalData(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            client.processServerSupplementalData(null);
        }
        state.keyExchange = TlsUtils.initKeyExchangeClient(clientContext, client);
        if (serverMessage.getType() == 11) {
            this.processServerCertificate(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.authentication = null;
        }
        if (serverMessage.getType() == 22) {
            if (securityParameters.getStatusRequestVersion() < 1) {
                throw new TlsFatalAlert(10);
            }
            this.processCertificateStatus(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        }
        TlsUtils.processServerCertificate(clientContext, state.certificateStatus, state.keyExchange, state.authentication, state.clientExtensions, state.serverExtensions);
        if (serverMessage.getType() == 12) {
            this.processServerKeyExchange(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.keyExchange.skipServerKeyExchange();
        }
        if (serverMessage.getType() == 13) {
            this.processCertificateRequest(state, serverMessage.getBody());
            TlsUtils.establishServerSigAlgs(securityParameters, state.certificateRequest);
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() == 14) {
            if (serverMessage.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        TlsCredentials clientAuthCredentials = null;
        TlsCredentialedSigner clientAuthSigner = null;
        Certificate clientAuthCertificate = null;
        SignatureAndHashAlgorithm clientAuthAlgorithm = null;
        TlsStreamSigner clientAuthStreamSigner = null;
        if (state.certificateRequest != null && (clientAuthCredentials = TlsUtils.establishClientCredentials(state.authentication, state.certificateRequest)) != null) {
            clientAuthCertificate = clientAuthCredentials.getCertificate();
            if (clientAuthCredentials instanceof TlsCredentialedSigner) {
                clientAuthSigner = (TlsCredentialedSigner)clientAuthCredentials;
                clientAuthAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(securityParameters.getNegotiatedVersion(), clientAuthSigner);
                clientAuthStreamSigner = clientAuthSigner.getStreamSigner();
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), clientAuthAlgorithm, (short)80);
                    if (clientAuthStreamSigner == null) {
                        TlsUtils.trackHashAlgorithmClient(handshake.getHandshakeHash(), clientAuthAlgorithm);
                    }
                }
                if (clientAuthStreamSigner != null) {
                    handshake.getHandshakeHash().forceBuffering();
                }
            }
        }
        handshake.getHandshakeHash().sealHashAlgorithms();
        if (clientAuthCredentials == null) {
            state.keyExchange.skipClientCredentials();
        } else {
            state.keyExchange.processClientCredentials(clientAuthCredentials);
        }
        Vector clientSupplementalData = client.getClientSupplementalData();
        if (clientSupplementalData != null) {
            byte[] supplementalDataBody = DTLSClientProtocol.generateSupplementalData(clientSupplementalData);
            handshake.sendMessage((short)23, supplementalDataBody);
        }
        if (null != state.certificateRequest) {
            DTLSClientProtocol.sendCertificateMessage(clientContext, handshake, clientAuthCertificate, null);
        }
        byte[] clientKeyExchangeBody = this.generateClientKeyExchange(state);
        handshake.sendMessage((short)16, clientKeyExchangeBody);
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(handshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(clientContext, state.keyExchange);
        recordLayer.initPendingEpoch(TlsUtils.initCipher(clientContext));
        if (clientAuthSigner != null) {
            DigitallySigned certificateVerify = TlsUtils.generateCertificateVerifyClient(clientContext, clientAuthSigner, clientAuthAlgorithm, clientAuthStreamSigner, handshake.getHandshakeHash());
            byte[] certificateVerifyBody = this.generateCertificateVerify(state, certificateVerify);
            handshake.sendMessage((short)15, certificateVerifyBody);
        }
        handshake.prepareToFinish();
        securityParameters.localVerifyData = TlsUtils.calculateVerifyData(clientContext, handshake.getHandshakeHash(), false);
        handshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        if (state.expectSessionTicket) {
            serverMessage = handshake.receiveMessage();
            if (serverMessage.getType() == 4) {
                securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
                this.invalidateSession(state);
                state.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                this.processNewSessionTicket(state, serverMessage.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(clientContext, handshake.getHandshakeHash(), true);
        this.processFinished(handshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        handshake.finish();
        state.sessionMasterSecret = securityParameters.getMasterSecret();
        state.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(clientContext.getCrypto().adoptSecret(state.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.serverExtensions).build();
        state.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), state.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getLocalVerifyData();
        clientContext.handshakeComplete(client, state.tlsSession);
        recordLayer.initHeartbeat(state.heartbeat, 1 == state.heartbeatPolicy);
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateVerify.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state) throws IOException {
        boolean noRenegSCSV;
        TlsClient client = state.client;
        TlsClientContextImpl clientContext = state.clientContext;
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        ProtocolVersion[] supportedVersions = client.getProtocolVersions();
        ProtocolVersion earliestVersion = ProtocolVersion.getEarliestDTLS(supportedVersions);
        ProtocolVersion latestVersion = ProtocolVersion.getLatestDTLS(supportedVersions);
        if (!ProtocolVersion.isSupportedDTLSVersionClient(latestVersion)) {
            throw new TlsFatalAlert(80);
        }
        clientContext.setClientVersion(latestVersion);
        clientContext.setClientSupportedVersions(supportedVersions);
        boolean offeringDTLSv12Minus = ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(earliestVersion);
        boolean offeringDTLSv13Plus = ProtocolVersion.DTLSv13.isEqualOrEarlierVersionOf(latestVersion);
        boolean useGMTUnixTime = !offeringDTLSv13Plus && client.shouldUseGMTUnixTime();
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(useGMTUnixTime, clientContext);
        TlsSession sessionToResume = offeringDTLSv12Minus ? client.getSessionToResume() : null;
        boolean fallback = client.isFallback();
        state.offeredCipherSuites = client.getCipherSuites();
        state.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(client.getClientExtensions());
        boolean shouldUseEMS = client.shouldUseExtendedMasterSecret();
        this.establishSession(state, sessionToResume);
        byte[] legacy_session_id = TlsUtils.getSessionID(state.tlsSession);
        if (legacy_session_id.length > 0 && !Arrays.contains(state.offeredCipherSuites, state.sessionParameters.getCipherSuite())) {
            legacy_session_id = TlsUtils.EMPTY_BYTES;
        }
        ProtocolVersion sessionVersion = null;
        if (legacy_session_id.length > 0 && !ProtocolVersion.contains(supportedVersions, sessionVersion = state.sessionParameters.getNegotiatedVersion())) {
            legacy_session_id = TlsUtils.EMPTY_BYTES;
        }
        if (legacy_session_id.length > 0 && TlsUtils.isExtendedMasterSecretOptional(sessionVersion)) {
            if (shouldUseEMS) {
                if (!state.sessionParameters.isExtendedMasterSecret() && !client.allowLegacyResumption()) {
                    legacy_session_id = TlsUtils.EMPTY_BYTES;
                }
            } else if (state.sessionParameters.isExtendedMasterSecret()) {
                legacy_session_id = TlsUtils.EMPTY_BYTES;
            }
        }
        if (legacy_session_id.length < 1) {
            this.cancelSession(state);
        }
        client.notifySessionToResume(state.tlsSession);
        ProtocolVersion legacy_version = latestVersion;
        if (offeringDTLSv13Plus) {
            legacy_version = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(state.clientExtensions, supportedVersions);
        }
        clientContext.setRSAPreMasterSecretVersion(legacy_version);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(state.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(latestVersion)) {
            TlsUtils.establishClientSigAlgs(securityParameters, state.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(state.clientExtensions);
        state.clientBinders = null;
        state.clientAgreements = TlsUtils.addKeyShareToClientHello(clientContext, client, state.clientExtensions);
        if (shouldUseEMS && TlsUtils.isExtendedMasterSecretOptional(supportedVersions)) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(state.clientExtensions);
        } else {
            state.clientExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        boolean noRenegExt = null == TlsUtils.getExtensionData(state.clientExtensions, TlsProtocol.EXT_RenegotiationInfo);
        boolean bl = noRenegSCSV = !Arrays.contains(state.offeredCipherSuites, 255);
        if (noRenegExt && noRenegSCSV) {
            state.offeredCipherSuites = Arrays.append(state.offeredCipherSuites, 255);
        }
        if (fallback && !Arrays.contains(state.offeredCipherSuites, 22016)) {
            state.offeredCipherSuites = Arrays.append(state.offeredCipherSuites, 22016);
        }
        state.heartbeat = client.getHeartbeat();
        state.heartbeatPolicy = client.getHeartbeatPolicy();
        if (null != state.heartbeat || 1 == state.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(state.clientExtensions, new HeartbeatExtension(state.heartbeatPolicy));
        }
        int bindersSize = null == state.clientBinders ? 0 : state.clientBinders.bindersSize;
        ClientHello clientHello = new ClientHello(legacy_version, securityParameters.getClientRandom(), legacy_session_id, TlsUtils.EMPTY_BYTES, state.offeredCipherSuites, state.clientExtensions, bindersSize);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        clientHello.encode(clientContext, buf);
        return buf.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        state.keyExchange.generateClientKeyExchange(buf);
        return buf.toByteArray();
    }

    protected void cancelSession(ClientHandshakeState state) {
        if (state.sessionMasterSecret != null) {
            state.sessionMasterSecret.destroy();
            state.sessionMasterSecret = null;
        }
        if (state.sessionParameters != null) {
            state.sessionParameters.clear();
            state.sessionParameters = null;
        }
        state.tlsSession = null;
    }

    protected boolean establishSession(ClientHandshakeState state, TlsSession sessionToResume) {
        state.tlsSession = null;
        state.sessionParameters = null;
        state.sessionMasterSecret = null;
        if (null == sessionToResume || !sessionToResume.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = sessionToResume.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion sessionVersion = sessionParameters.getNegotiatedVersion();
        if (null == sessionVersion || !sessionVersion.isDTLS()) {
            return false;
        }
        boolean isEMS = sessionParameters.isExtendedMasterSecret();
        if (!TlsUtils.isExtendedMasterSecretOptional(sessionVersion) && !isEMS) {
            return false;
        }
        TlsCrypto crypto = state.clientContext.getCrypto();
        TlsSecret sessionMasterSecret = TlsUtils.getSessionMasterSecret(crypto, sessionParameters.getMasterSecret());
        if (null == sessionMasterSecret) {
            return false;
        }
        state.tlsSession = sessionToResume;
        state.sessionParameters = sessionParameters;
        state.sessionMasterSecret = sessionMasterSecret;
        return true;
    }

    protected void invalidateSession(ClientHandshakeState state) {
        if (state.tlsSession != null) {
            state.tlsSession.invalidate();
        }
        this.cancelSession(state);
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (null == state.authentication) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        CertificateRequest certificateRequest = CertificateRequest.parse(state.clientContext, buf);
        TlsProtocol.assertEmpty(buf);
        state.certificateRequest = TlsUtils.validateCertificateRequest(certificateRequest, state.keyExchange);
    }

    protected void processCertificateStatus(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.certificateStatus = CertificateStatus.parse(state.clientContext, buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        int maxCookieLength = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(server_version) ? 255 : 32;
        byte[] cookie = TlsUtils.readOpaque8(buf, 0, maxCookieLength);
        TlsProtocol.assertEmpty(buf);
        if (!server_version.isEqualOrEarlierVersionOf(state.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        return cookie;
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected void processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        state.authentication = TlsUtils.receiveServerCertificate(state.clientContext, state.client, new ByteArrayInputStream(body), state.serverExtensions);
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        HeartbeatExtension heartbeatExtension;
        byte[] serverConnectionID;
        byte[] renegExtData;
        ProtocolVersion server_version;
        TlsClient client = state.client;
        TlsClientContextImpl clientContext = state.clientContext;
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ServerHello serverHello = ServerHello.parse(buf);
        Hashtable serverHelloExtensions = serverHello.getExtensions();
        ProtocolVersion legacy_version = serverHello.getVersion();
        ProtocolVersion supported_version = TlsExtensionsUtils.getSupportedVersionsExtensionServer(serverHelloExtensions);
        if (null == supported_version) {
            server_version = legacy_version;
        } else {
            if (!ProtocolVersion.DTLSv12.equals(legacy_version) || !ProtocolVersion.DTLSv13.isEqualOrEarlierVersionOf(supported_version)) {
                throw new TlsFatalAlert(47);
            }
            server_version = supported_version;
        }
        this.reportServerVersion(state, server_version);
        int[] offeredCipherSuites = state.offeredCipherSuites;
        securityParameters.serverRandom = serverHello.getRandom();
        if (!clientContext.getClientVersion().equals(server_version)) {
            TlsUtils.checkDowngradeMarker(server_version, securityParameters.getServerRandom());
        }
        byte[] selectedSessionID = serverHello.getSessionID();
        securityParameters.sessionID = selectedSessionID;
        client.notifySessionID(selectedSessionID);
        boolean bl = securityParameters.resumedSession = selectedSessionID.length > 0 && state.tlsSession != null && Arrays.areEqual(selectedSessionID, state.tlsSession.getSessionID());
        if (securityParameters.isResumedSession() && (serverHello.getCipherSuite() != state.sessionParameters.getCipherSuite() || !securityParameters.getNegotiatedVersion().equals(state.sessionParameters.getNegotiatedVersion()))) {
            throw new TlsFatalAlert(47, "ServerHello parameters do not match resumed session");
        }
        int cipherSuite = DTLSClientProtocol.validateSelectedCipherSuite(serverHello.getCipherSuite(), (short)47);
        if (!TlsUtils.isValidCipherSuiteSelection(offeredCipherSuites, cipherSuite) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47, "ServerHello selected invalid cipher suite");
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        client.notifySelectedCipherSuite(cipherSuite);
        state.serverExtensions = serverHelloExtensions;
        if (serverHelloExtensions != null) {
            Enumeration e = serverHelloExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(state.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110);
                }
                if (!securityParameters.isResumedSession()) continue;
            }
        }
        if ((renegExtData = TlsUtils.getExtensionData(serverHelloExtensions, TlsProtocol.EXT_RenegotiationInfo)) == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual(renegExtData, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        client.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean negotiatedEMS = false;
        if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(state.clientExtensions)) {
            negotiatedEMS = TlsExtensionsUtils.hasExtendedMasterSecretExtension(serverHelloExtensions);
            if (TlsUtils.isExtendedMasterSecretOptional(server_version)) {
                if (!negotiatedEMS && client.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
            } else if (negotiatedEMS) {
                throw new TlsFatalAlert(47, "Server sent an unexpected extended_master_secret extension negotiating " + server_version);
            }
        }
        securityParameters.extendedMasterSecret = negotiatedEMS;
        if (securityParameters.isResumedSession() && securityParameters.isExtendedMasterSecret() != state.sessionParameters.isExtendedMasterSecret()) {
            throw new TlsFatalAlert(40, "Server resumed session with mismatched extended_master_secret negotiation");
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(serverHelloExtensions);
        securityParameters.applicationProtocolSet = true;
        if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion()) && (serverConnectionID = TlsExtensionsUtils.getConnectionIDExtension(serverHelloExtensions)) != null) {
            byte[] clientConnectionID = TlsExtensionsUtils.getConnectionIDExtension(state.clientExtensions);
            if (clientConnectionID == null) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.connectionIDLocal = serverConnectionID;
            securityParameters.connectionIDPeer = clientConnectionID;
        }
        if (null == (heartbeatExtension = TlsExtensionsUtils.getHeartbeatExtension(serverHelloExtensions))) {
            state.heartbeat = null;
            state.heartbeatPolicy = (short)2;
        } else if (1 != heartbeatExtension.getMode()) {
            state.heartbeat = null;
        }
        Hashtable sessionClientExtensions = state.clientExtensions;
        Hashtable sessionServerExtensions = serverHelloExtensions;
        if (securityParameters.isResumedSession()) {
            sessionClientExtensions = null;
            sessionServerExtensions = state.sessionParameters.readServerExtensions();
        }
        if (sessionServerExtensions != null && !sessionServerExtensions.isEmpty()) {
            boolean serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(sessionServerExtensions);
            if (serverSentEncryptThenMAC && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            securityParameters.maxFragmentLength = TlsUtils.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(sessionServerExtensions);
            if (!securityParameters.isResumedSession()) {
                if (TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.statusRequestVersion = 1;
                }
                securityParameters.clientCertificateType = TlsUtils.processClientCertificateTypeExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
                securityParameters.serverCertificateType = TlsUtils.processServerCertificateTypeExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
                state.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (sessionClientExtensions != null) {
            client.processServerExtensions(sessionServerExtensions);
        }
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.keyExchange.processServerKeyExchange(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Vector serverSupplementalData = TlsProtocol.readSupplementalDataMessage(buf);
        state.client.processServerSupplementalData(serverSupplementalData);
    }

    protected void reportServerVersion(ClientHandshakeState state, ProtocolVersion server_version) throws IOException {
        TlsClientContextImpl clientContext = state.clientContext;
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        ProtocolVersion currentServerVersion = securityParameters.getNegotiatedVersion();
        if (null != currentServerVersion) {
            if (!currentServerVersion.equals(server_version)) {
                throw new TlsFatalAlert(47);
            }
            return;
        }
        if (!ProtocolVersion.contains(clientContext.getClientSupportedVersions(), server_version)) {
            throw new TlsFatalAlert(70);
        }
        securityParameters.negotiatedVersion = server_version;
        TlsUtils.negotiatedVersionDTLSClient(clientContext, state.client);
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int sessionIDPos = 34;
        short sessionIDLength = TlsUtils.readUint8(clientHelloBody, sessionIDPos);
        int cookieLengthPos = sessionIDPos + 1 + sessionIDLength;
        int cookiePos = cookieLengthPos + 1;
        byte[] patched = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, patched, 0, cookieLengthPos);
        TlsUtils.checkUint8(cookie.length);
        TlsUtils.writeUint8(cookie.length, patched, cookieLengthPos);
        System.arraycopy(cookie, 0, patched, cookiePos, cookie.length);
        System.arraycopy(clientHelloBody, cookiePos, patched, cookiePos + cookie.length, clientHelloBody.length - cookiePos);
        return patched;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        boolean expectSessionTicket = false;
        Hashtable clientAgreements = null;
        OfferedPsks.BindersConfig clientBinders = null;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ClientHandshakeState() {
        }
    }
}

