/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.util;

import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.util.CustomSSLSocketFactory;
import org.bouncycastle.jsse.util.SNIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNISocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SNISocketFactory.class.getName());
    protected static final ThreadLocal<SNISocketFactory> threadLocal = new ThreadLocal();
    protected final URL url;

    public static SocketFactory getDefault() {
        SSLSocketFactory sslSocketFactory = threadLocal.get();
        if (null != sslSocketFactory) {
            return sslSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SNISocketFactory(SSLSocketFactory delegate, URL url) {
        super(delegate);
        this.url = url;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket s2) {
        if (s2 instanceof BCSSLSocket) {
            BCSSLSocket ssl = (BCSSLSocket)((Object)s2);
            BCSNIHostName sniHostName = this.getBCSNIHostName();
            if (null != sniHostName) {
                LOG.fine("Setting SNI on socket: " + sniHostName);
                BCSSLParameters sslParameters = new BCSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(sniHostName));
                ssl.setParameters(sslParameters);
            }
        }
        return s2;
    }

    protected BCSNIHostName getBCSNIHostName() {
        return SNIUtil.getBCSNIHostName(this.url);
    }
}

