/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationHandler
implements AuthenticationHandler {
    public static final Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationHandler.class);
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String NAME_RULES = "kerberos.name.rules";
    public static final String RULE_MECHANISM = "kerberos.name.rules.mechanism";
    @VisibleForTesting
    static final String ENDPOINT_WHITELIST = "kerberos.endpoint.whitelist";
    private static final Pattern ENDPOINT_PATTERN = Pattern.compile("^/[\\w]+");
    private String type;
    private String keytab;
    private GSSManager gssManager;
    private Subject serverSubject = new Subject();
    private final Collection<String> whitelist = new HashSet<String>();

    public KerberosAuthenticationHandler() {
        this(TYPE);
    }

    public KerberosAuthenticationHandler(String type) {
        this.type = type;
    }

    @Override
    public void init(Properties config) throws ServletException {
        try {
            String whitelistStr;
            String ruleMechanism;
            String[] spnegoPrincipals;
            String principal = config.getProperty(PRINCIPAL);
            if (principal == null || principal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            this.keytab = config.getProperty(KEYTAB, this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            File keytabFile = new File(this.keytab);
            if (!keytabFile.exists()) {
                throw new ServletException("Keytab does not exist: " + this.keytab);
            }
            if (principal.equals("*")) {
                spnegoPrincipals = KerberosUtil.getPrincipalNames(this.keytab, Pattern.compile("HTTP/.*"));
                if (spnegoPrincipals.length == 0) {
                    throw new ServletException("Principals do not exist in the keytab");
                }
            } else {
                spnegoPrincipals = new String[]{principal};
            }
            KeyTab keytabInstance = KeyTab.getInstance(keytabFile);
            this.serverSubject.getPrivateCredentials().add(keytabInstance);
            for (String spnegoPrincipal : spnegoPrincipals) {
                KerberosPrincipal krbPrincipal = new KerberosPrincipal(spnegoPrincipal);
                LOG.info("Using keytab {}, for principal {}", (Object)this.keytab, (Object)krbPrincipal);
                this.serverSubject.getPrincipals().add(krbPrincipal);
            }
            String nameRules = config.getProperty(NAME_RULES, null);
            if (nameRules != null) {
                KerberosName.setRules(nameRules);
            }
            if ((ruleMechanism = config.getProperty(RULE_MECHANISM, null)) != null) {
                KerberosName.setRuleMechanism(ruleMechanism);
            }
            if ((whitelistStr = config.getProperty(ENDPOINT_WHITELIST, null)) != null) {
                String[] strs;
                for (String s2 : strs = whitelistStr.trim().split("\\s*[,\n]\\s*")) {
                    if (s2.isEmpty()) continue;
                    if (ENDPOINT_PATTERN.matcher(s2).matches()) {
                        this.whitelist.add(s2);
                        continue;
                    }
                    throw new ServletException("The element of the whitelist: " + s2 + " must start with '/' and must not contain special characters afterwards");
                }
            }
            try {
                this.gssManager = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                    @Override
                    public GSSManager run() throws Exception {
                        return GSSManager.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        }
        catch (Exception ex) {
            KerberosUtil.checkJCEKeyStrength();
            throw new ServletException(ex);
        }
    }

    @Override
    public void destroy() {
        this.keytab = null;
        this.serverSubject = null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected Set<KerberosPrincipal> getPrincipals() {
        return this.serverSubject.getPrincipals(KerberosPrincipal.class);
    }

    protected String getKeytab() {
        return this.keytab;
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationException {
        String path = request.getServletPath();
        for (String endpoint : this.whitelist) {
            if (!endpoint.equals(path)) continue;
            return AuthenticationToken.ANONYMOUS;
        }
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOG.trace("SPNEGO starting for url: {}", (Object)request.getRequestURL());
            } else {
                LOG.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            authorization = authorization.substring("Negotiate".length()).trim();
            final Base64 base642 = new Base64(0);
            final byte[] clientToken = base642.decode(authorization);
            try {
                final String serverPrincipal = KerberosUtil.getTokenServerName(clientToken);
                if (!serverPrincipal.startsWith("HTTP/")) {
                    throw new IllegalArgumentException("Invalid server principal " + serverPrincipal + "decoded from client request");
                }
                token = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<AuthenticationToken>(){

                    @Override
                    public AuthenticationToken run() throws Exception {
                        return KerberosAuthenticationHandler.this.runWithPrincipal(serverPrincipal, clientToken, base642, response);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw new AuthenticationException(ex.getException());
            }
            catch (Exception ex) {
                throw new AuthenticationException(ex);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationToken runWithPrincipal(String serverPrincipal, byte[] clientToken, Base64 base642, HttpServletResponse response) throws IOException, GSSException {
        GSSContext gssContext = null;
        GSSCredential gssCreds = null;
        AuthenticationToken token = null;
        try {
            LOG.trace("SPNEGO initiated with server principal [{}]", (Object)serverPrincipal);
            gssCreds = this.gssManager.createCredential(this.gssManager.createName(serverPrincipal, KerberosUtil.NT_GSS_KRB5_PRINCIPAL_OID), Integer.MAX_VALUE, new Oid[]{KerberosUtil.GSS_SPNEGO_MECH_OID, KerberosUtil.GSS_KRB5_MECH_OID}, 2);
            gssContext = this.gssManager.createContext(gssCreds);
            byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
            if (serverToken != null && serverToken.length > 0) {
                String authenticate = base642.encodeToString(serverToken);
                response.setHeader("WWW-Authenticate", "Negotiate " + authenticate);
            }
            if (!gssContext.isEstablished()) {
                response.setStatus(401);
                LOG.trace("SPNEGO in progress");
            } else {
                String clientPrincipal = gssContext.getSrcName().toString();
                KerberosName kerberosName = new KerberosName(clientPrincipal);
                String userName = kerberosName.getShortName();
                token = new AuthenticationToken(userName, clientPrincipal, this.getType());
                response.setStatus(200);
                LOG.trace("SPNEGO completed for client principal [{}]", (Object)clientPrincipal);
            }
        }
        finally {
            if (gssContext != null) {
                gssContext.dispose();
            }
            if (gssCreds != null) {
                gssCreds.dispose();
            }
        }
        return token;
    }
}

