/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.apache.hadoop.ipc.RpcWritable;
import org.apache.hadoop.util.Preconditions;

@InterfaceAudience.Private
public class ProtobufWrapperLegacy
extends RpcWritable {
    private Message message;
    private static final AtomicBoolean PROTOBUF_KNOWN_NOT_FOUND = new AtomicBoolean(false);

    public ProtobufWrapperLegacy(Object message) {
        Preconditions.checkArgument(ProtobufWrapperLegacy.isUnshadedProtobufMessage(message), "message class is not an unshaded protobuf message %s", message.getClass());
        this.message = (Message)message;
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public void writeTo(ResponseBuffer out) throws IOException {
        int length = this.message.getSerializedSize();
        length += CodedOutputStream.computeUInt32SizeNoTag(length);
        out.ensureCapacity(length);
        this.message.writeDelimitedTo(out);
    }

    @Override
    protected <T> T readFrom(ByteBuffer bb) throws IOException {
        CodedInputStream cis = CodedInputStream.newInstance(bb.array(), bb.position() + bb.arrayOffset(), bb.remaining());
        try {
            cis.pushLimit(cis.readRawVarint32());
            this.message = this.message.getParserForType().parseFrom(cis);
            cis.checkLastTagWas(0);
        }
        finally {
            bb.position(bb.position() + cis.getTotalBytesRead());
        }
        return (T)this.message;
    }

    public static boolean isUnshadedProtobufMessage(Object payload) {
        if (PROTOBUF_KNOWN_NOT_FOUND.get()) {
            return false;
        }
        try {
            Class<?> protobufMessageClazz = Class.forName("com.google.protobuf.Message");
            return protobufMessageClazz.isAssignableFrom(payload.getClass());
        }
        catch (ClassNotFoundException e) {
            PROTOBUF_KNOWN_NOT_FOUND.set(true);
            return false;
        }
    }
}

