/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.fs.sftp.SFTPFileSystem;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SFTPConnectionPool {
    public static final Logger LOG = LoggerFactory.getLogger(SFTPFileSystem.class);
    private int maxConnection;
    private int liveConnectionCount = 0;
    private HashMap<ConnectionInfo, HashSet<ChannelSftp>> idleConnections = new HashMap();
    private HashMap<ChannelSftp, ConnectionInfo> con2infoMap = new HashMap();

    SFTPConnectionPool(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    synchronized ChannelSftp getFromPool(ConnectionInfo info) throws IOException {
        Set cons = this.idleConnections.get(info);
        if (cons != null && cons.size() > 0) {
            Iterator it = cons.iterator();
            if (it.hasNext()) {
                ChannelSftp channel = (ChannelSftp)it.next();
                this.idleConnections.remove(info);
                return channel;
            }
            throw new IOException("Connection pool error.");
        }
        return null;
    }

    synchronized void returnToPool(ChannelSftp channel) {
        ConnectionInfo info = this.con2infoMap.get(channel);
        HashSet<ChannelSftp> cons = this.idleConnections.get(info);
        if (cons == null) {
            cons = new HashSet();
            this.idleConnections.put(info, cons);
        }
        cons.add(channel);
    }

    synchronized void shutdown() {
        if (this.con2infoMap == null) {
            return;
        }
        LOG.info("Inside shutdown, con2infoMap size=" + this.con2infoMap.size());
        this.maxConnection = 0;
        Set<ChannelSftp> cons = this.con2infoMap.keySet();
        if (cons != null && cons.size() > 0) {
            HashSet<ChannelSftp> copy = new HashSet<ChannelSftp>(cons);
            for (ChannelSftp con : copy) {
                try {
                    this.disconnect(con);
                }
                catch (IOException ioe) {
                    ConnectionInfo info = this.con2infoMap.get(con);
                    LOG.error("Error encountered while closing connection to " + info.getHost(), ioe);
                }
            }
        }
        this.idleConnections = null;
        this.con2infoMap = null;
    }

    public synchronized int getMaxConnection() {
        return this.maxConnection;
    }

    public synchronized void setMaxConnection(int maxConn) {
        this.maxConnection = maxConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSftp connect(String host, int port, String user, String password, String keyFile) throws IOException {
        ConnectionInfo info = new ConnectionInfo(host, port, user);
        ChannelSftp channel = this.getFromPool(info);
        if (channel != null) {
            if (channel.isConnected()) {
                return channel;
            }
            channel = null;
            SFTPConnectionPool sFTPConnectionPool = this;
            synchronized (sFTPConnectionPool) {
                --this.liveConnectionCount;
                this.con2infoMap.remove(channel);
            }
        }
        JSch jsch = new JSch();
        Session session = null;
        try {
            if (user == null || user.length() == 0) {
                user = System.getProperty("user.name");
            }
            if (password == null) {
                password = "";
            }
            if (keyFile != null && keyFile.length() > 0) {
                jsch.addIdentity(keyFile);
            }
            session = port <= 0 ? jsch.getSession(user, host) : jsch.getSession(user, host, port);
            session.setPassword(password);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            SFTPConnectionPool sFTPConnectionPool = this;
            synchronized (sFTPConnectionPool) {
                this.con2infoMap.put(channel, info);
                ++this.liveConnectionCount;
            }
            return channel;
        }
        catch (JSchException e) {
            throw new IOException(StringUtils.stringifyException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(ChannelSftp channel) throws IOException {
        if (channel != null) {
            boolean closeConnection = false;
            SFTPConnectionPool sFTPConnectionPool = this;
            synchronized (sFTPConnectionPool) {
                if (this.liveConnectionCount > this.maxConnection) {
                    --this.liveConnectionCount;
                    this.con2infoMap.remove(channel);
                    closeConnection = true;
                }
            }
            if (closeConnection) {
                if (channel.isConnected()) {
                    try {
                        Session session = channel.getSession();
                        channel.disconnect();
                        session.disconnect();
                    }
                    catch (JSchException e) {
                        throw new IOException(StringUtils.stringifyException(e));
                    }
                }
            } else {
                this.returnToPool(channel);
            }
        }
    }

    public int getIdleCount() {
        return this.idleConnections.size();
    }

    public int getLiveConnCount() {
        return this.liveConnectionCount;
    }

    public int getConnPoolSize() {
        return this.con2infoMap.size();
    }

    static class ConnectionInfo {
        private String host = "";
        private int port;
        private String user = "";

        ConnectionInfo(String hst, int prt, String usr) {
            this.host = hst;
            this.port = prt;
            this.user = usr;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String hst) {
            this.host = hst;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int prt) {
            this.port = prt;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String usr) {
            this.user = usr;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConnectionInfo) {
                ConnectionInfo con = (ConnectionInfo)obj;
                boolean ret = true;
                if (this.host == null || !this.host.equalsIgnoreCase(con.host)) {
                    ret = false;
                }
                if (this.port >= 0 && this.port != con.port) {
                    ret = false;
                }
                if (this.user == null || !this.user.equalsIgnoreCase(con.user)) {
                    ret = false;
                }
                return ret;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.host != null) {
                hashCode += this.host.hashCode();
            }
            hashCode += this.port;
            if (this.user != null) {
                hashCode += this.user.hashCode();
            }
            return hashCode;
        }
    }
}

